/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.utils.IterableUtils;
import java.util.Set;

public class KotlinMetadataMembersTracker {
    private int count;
    private final Set<DexMember<?, ?>> references;

    public KotlinMetadataMembersTracker(AppView<?> appView) {
        this.references = appView.options().testing.enableTestAssertions ? Sets.newIdentityHashSet() : null;
    }

    private boolean isKotlinJvmType(AppView<?> appView, DexType type) {
        return type.descriptor.startsWith(appView.dexItemFactory().kotlin.kotlinJvmTypePrefix);
    }

    public void add(DexMember<?, ?> reference) {
        ++this.count;
        if (this.references != null) {
            this.references.add(reference);
        }
    }

    public boolean isEqual(KotlinMetadataMembersTracker tracker, AppView<?> appView) {
        if (this.count != tracker.count) {
            return false;
        }
        if (this.references != null) {
            assert (tracker.references != null);
            assert (this.references.size() == tracker.references.size());
            Sets.SetView<DexMember<?, ?>> diffComparedToRewritten = Sets.difference(this.references, tracker.references);
            if (!diffComparedToRewritten.isEmpty()) {
                Sets.SetView<DexMember<?, ?>> diffComparedToOriginal = Sets.difference(tracker.references, this.references);
                diffComparedToRewritten.forEach(diff -> {
                    DexReference rewrittenReference = appView.graphLens().lookupReference((DexReference)diff);
                    assert (diffComparedToOriginal.contains(rewrittenReference));
                    assert (IterableUtils.findOrDefault(diff.getReferencedTypes(), type -> this.isKotlinJvmType(appView, (DexType)type), null) != null);
                });
            }
        }
        return true;
    }
}

