/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.naming.Range;
import com.android.tools.r8.utils.SegmentTree;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class KotlinSourceDebugExtensionParser {
    private static final String SMAP_IDENTIFIER = "SMAP";
    private static final String SMAP_SECTION_START = "*S";
    private static final String SMAP_SECTION_KOTLIN_START = "*S Kotlin";
    private static final String SMAP_SECTION_KOTLIN_DEBUG_START = "*S KotlinDebug";
    private static final String SMAP_FILES_IDENTIFIER = "*F";
    private static final String SMAP_LINES_IDENTIFIER = "*L";
    private static final String SMAP_END_IDENTIFIER = "*E";

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Result parse(String annotationData) {
        if (annotationData == null) return null;
        if (annotationData.isEmpty()) {
            return null;
        }
        try {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                block30: {
                                    reader = new BufferedStringReader(annotationData);
                                    var2_3 = null;
                                    try {
                                        if (!reader.readExpectedLine("SMAP")) {
                                            var3_4 = null;
                                            if (var2_3 == null) break block30;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var3_7) {
                                        try {
                                            var2_3 = var3_7;
                                            throw var3_7;
                                        }
                                        catch (Throwable var9_20) {
                                            if (var2_3 == null) {
                                                reader.close();
                                                throw var9_20;
                                            }
                                            try {
                                                reader.close();
                                                throw var9_20;
                                            }
                                            catch (Throwable var10_21) {
                                                var2_3.addSuppressed(var10_21);
                                                throw var9_20;
                                            }
                                        }
                                    }
                                    try {
                                        reader.close();
                                        return var3_4;
                                    }
                                    catch (Throwable var4_8) {
                                        var2_3.addSuppressed(var4_8);
                                        return var3_4;
                                    }
                                }
                                reader.close();
                                return var3_4;
lbl-1000:
                                // 1 sources

                                {
                                    if (!reader.readUntil("*S Kotlin").isEOF()) ** GOTO lbl-1000
                                    var3_5 = null;
                                    if (var2_3 == null) break block31;
                                }
                                try {
                                    reader.close();
                                    return var3_5;
                                }
                                catch (Throwable var4_9) {
                                    var2_3.addSuppressed(var4_9);
                                    return var3_5;
                                }
                            }
                            reader.close();
                            return var3_5;
lbl-1000:
                            // 1 sources

                            {
                                inlineePositions = new StratumBuilder();
                                calleePositions = new StratumBuilder();
                                terminatedLine = KotlinSourceDebugExtensionParser.parseStratumContents(reader, inlineePositions);
                                if (!terminatedLine.equals("*E")) ** GOTO lbl-1000
                                nextLine = reader.readNextLine();
                                if (!reader.isEOF()) ** GOTO lbl-1000
                                if (!KotlinSourceDebugExtensionParser.$assertionsDisabled && nextLine != null) {
                                    throw new AssertionError();
                                }
                                var7_14 = new Result(inlineePositions.segmentTree, calleePositions.segmentTree);
                                if (var2_3 == null) break block32;
                            }
                            try {
                                reader.close();
                                return var7_14;
                            }
                            catch (Throwable var8_18) {
                                var2_3.addSuppressed(var8_18);
                                return var7_14;
                            }
                        }
                        reader.close();
                        return var7_14;
lbl-1000:
                        // 1 sources

                        {
                            if (nextLine.equals("*S KotlinDebug")) ** GOTO lbl-1000
                            var7_15 = null;
                            if (var2_3 == null) break block33;
                        }
                        try {
                            reader.close();
                            return var7_15;
                        }
                        catch (Throwable var8_19) {
                            var2_3.addSuppressed(var8_19);
                            return var7_15;
                        }
                    }
                    reader.close();
                    return var7_15;
lbl-1000:
                    // 1 sources

                    {
                        if (terminatedLine.equals("*S KotlinDebug")) ** GOTO lbl-1000
                        var6_13 = null;
                        if (var2_3 == null) break block34;
                    }
                    try {
                        reader.close();
                        return var6_13;
                    }
                    catch (Throwable var7_16) {
                        var2_3.addSuppressed(var7_16);
                        return var6_13;
                    }
                }
                reader.close();
                return var6_13;
lbl-1000:
                // 2 sources

                {
                    KotlinSourceDebugExtensionParser.parseStratumContents(reader, calleePositions);
                    if (reader.isEOF() && !BufferedStringReader.access$000(reader).equals("*E")) {
                        throw new KotlinSourceDebugExtensionParserException("Unexpected EOF when parsing SMAP debug entries");
                    }
                    var6_12 = new Result(inlineePositions.segmentTree, calleePositions.segmentTree);
                    if (var2_3 == null) break block35;
                }
                try {
                    reader.close();
                    return var6_12;
                }
                catch (Throwable var7_17) {
                    var2_3.addSuppressed(var7_17);
                    return var6_12;
                }
            }
            reader.close();
            return var6_12;
        }
        catch (KotlinSourceDebugExtensionParserException | IOException e) {
            return null;
        }
    }

    private static String parseStratumContents(BufferedStringReader reader, StratumBuilder builder) throws KotlinSourceDebugExtensionParserException, IOException {
        reader.readExpectedLineOrThrow(SMAP_FILES_IDENTIFIER);
        reader.readUntil(SMAP_LINES_IDENTIFIER, 2, block -> KotlinSourceDebugExtensionParser.addFileToBuilder((String)block.get(0), (String)block.get(1), builder));
        if (reader.isEOF()) {
            throw new KotlinSourceDebugExtensionParserException("Unexpected EOF - no debug line positions");
        }
        return reader.readUntil(line -> line.equals(SMAP_END_IDENTIFIER) || line.startsWith(SMAP_SECTION_START), 1, block -> KotlinSourceDebugExtensionParser.addDebugEntryToBuilder((String)block.get(0), builder));
    }

    private static void addFileToBuilder(String entryLine, String filePath, StratumBuilder builder) throws KotlinSourceDebugExtensionParserException {
        String[] entries = entryLine.trim().split(" ");
        if (entries.length != 3 || !entries[0].equals("+")) {
            throw new KotlinSourceDebugExtensionParserException("Wrong number of entries on line " + entryLine);
        }
        String fileName = entries[2];
        if (fileName.isEmpty()) {
            throw new KotlinSourceDebugExtensionParserException("Did not expect file name to be empty for line " + entryLine);
        }
        if (filePath == null || filePath.isEmpty()) {
            throw new KotlinSourceDebugExtensionParserException("Did not expect file path to be null or empty for " + entryLine);
        }
        int index = KotlinSourceDebugExtensionParser.asInteger(entries[1]);
        Source source = new Source(fileName, filePath);
        Source existingSource = builder.files.put(index, source);
        if (existingSource != null) {
            throw new KotlinSourceDebugExtensionParserException("File index " + index + " was already mapped to an existing source: " + source);
        }
    }

    private static int asInteger(String numberAsString) throws KotlinSourceDebugExtensionParserException {
        int number = -1;
        try {
            number = Integer.parseInt(numberAsString);
        }
        catch (NumberFormatException e) {
            throw new KotlinSourceDebugExtensionParserException("Could not parse number " + numberAsString);
        }
        return number;
    }

    private static void addDebugEntryToBuilder(String debugEntry, StratumBuilder builder) throws KotlinSourceDebugExtensionParserException {
        try {
            int target;
            int size = 1;
            int targetSplit = debugEntry.indexOf(58);
            int targetRangeStart = targetSplit + 1;
            int targetRangeSeparator = debugEntry.indexOf(44, targetSplit);
            if (targetRangeSeparator > -1) {
                target = Integer.parseInt(debugEntry.substring(targetRangeStart, targetRangeSeparator));
                size = Integer.parseInt(debugEntry.substring(targetRangeSeparator + 1));
            } else {
                target = Integer.parseInt(debugEntry.substring(targetRangeStart));
            }
            String original = debugEntry.substring(0, targetSplit);
            int fileIndexSplit = original.indexOf(35);
            int originalStart = Integer.parseInt(original.substring(0, fileIndexSplit));
            String fileAndEndRange = original.substring(fileIndexSplit + 1);
            int endRangeCharPosition = fileAndEndRange.indexOf(44);
            if (endRangeCharPosition > -1) {
                assert (endRangeCharPosition > 0);
                size = Integer.parseInt(fileAndEndRange.substring(endRangeCharPosition + 1));
            } else {
                endRangeCharPosition = fileAndEndRange.length();
            }
            int fileIndex = Integer.parseInt(fileAndEndRange.substring(0, endRangeCharPosition));
            Source thisFileSource = builder.files.get(fileIndex);
            if (thisFileSource == null) {
                throw new KotlinSourceDebugExtensionParserException("Could not find file with index " + fileIndex);
            }
            Range range = new Range(originalStart, originalStart + (size - 1));
            Position position = new Position(thisFileSource, range);
            builder.segmentTree.add(target, target + (size - 1), position);
        }
        catch (NumberFormatException e) {
            throw new KotlinSourceDebugExtensionParserException("Could not convert position to number");
        }
    }

    public static class Position {
        private final Source source;
        private final Range range;

        public Position(Source source, Range range) {
            this.source = source;
            this.range = range;
        }

        public Source getSource() {
            return this.source;
        }

        public Range getRange() {
            return this.range;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.range.from);
            sb.append("#");
            sb.append(this.source);
            if (this.range.to != this.range.from) {
                sb.append(",");
                sb.append(this.range.to);
            }
            sb.append(":");
            return sb.toString();
        }
    }

    public static class Source {
        private final String fileName;
        private final String path;

        private Source(String fileName, String path) {
            this.fileName = fileName;
            this.path = path;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.path + "(" + this.fileName + ")";
        }
    }

    public static class StratumBuilder {
        SegmentTree<Position> segmentTree = new SegmentTree(false);
        Map<Integer, Source> files = new HashMap<Integer, Source>();
    }

    public static class Result {
        private final SegmentTree<Position> inlineePositions;
        private final SegmentTree<Position> calleePositions;

        public Result(SegmentTree<Position> inlineePositions, SegmentTree<Position> calleePositions) {
            this.inlineePositions = inlineePositions;
            this.calleePositions = calleePositions;
        }

        public Map.Entry<Integer, Position> lookupInlinedPosition(int point) {
            return this.inlineePositions.findEntry(point);
        }

        public Map.Entry<Integer, Position> lookupCalleePosition(int point) {
            return this.calleePositions.findEntry(point);
        }

        public int inlinePositionsCount() {
            return this.inlineePositions.size();
        }
    }

    public static class BufferedStringReader
    implements Closeable {
        private final BufferedReader reader;
        private String readLine;

        BufferedStringReader(String data2) {
            this.reader = new BufferedReader(new StringReader(data2));
        }

        static /* synthetic */ String access$000(BufferedStringReader x0) {
            return x0.readLine;
        }

        String readNextLine() throws IOException {
            this.readLine = this.reader.readLine();
            return this.readLine;
        }

        boolean readExpectedLine(String expected) throws IOException {
            return this.readNextLine().equals(expected);
        }

        void readExpectedLineOrThrow(String expected) throws KotlinSourceDebugExtensionParserException, IOException {
            if (!this.readExpectedLine(expected)) {
                throw new KotlinSourceDebugExtensionParserException("The string " + this.readLine + " does not match the expected string " + expected);
            }
        }

        boolean isEOF() {
            return this.readLine == null;
        }

        BufferedStringReader readUntil(String terminator) throws IOException {
            while (!terminator.equals(this.readLine) && !this.isEOF()) {
                this.readNextLine();
            }
            if (this.isEOF()) {
                return this;
            }
            return this;
        }

        void readUntil(String terminator, int linesInBlock, ThrowingConsumer<List<String>, KotlinSourceDebugExtensionParserException> callback) throws IOException, KotlinSourceDebugExtensionParserException {
            this.readUntil(terminator::equals, linesInBlock, callback);
        }

        String readUntil(Predicate<String> terminator, int linesInBlock, ThrowingConsumer<List<String>, KotlinSourceDebugExtensionParserException> callback) throws IOException, KotlinSourceDebugExtensionParserException {
            if (terminator.test(this.readLine)) {
                return this.readLine;
            }
            ArrayList<String> readStrings = new ArrayList<String>();
            readStrings.add(this.readNextLine());
            int linesLeft = linesInBlock;
            while (!terminator.test(this.readLine) && !this.isEOF()) {
                if (linesLeft == 1) {
                    assert (readStrings.size() == linesInBlock);
                    callback.accept(readStrings);
                    linesLeft = linesInBlock;
                    readStrings = new ArrayList();
                } else {
                    --linesLeft;
                }
                readStrings.add(this.readNextLine());
            }
            if (!readStrings.isEmpty() && !terminator.test((String)readStrings.get(0))) {
                throw new KotlinSourceDebugExtensionParserException("Block size does not match linesInBlock = " + linesInBlock);
            }
            return readStrings.isEmpty() ? null : (String)readStrings.get(0);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    public static class KotlinSourceDebugExtensionParserException
    extends Exception {
        KotlinSourceDebugExtensionParserException(String message) {
            super(message);
        }
    }
}

