/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmLambda;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinClassLevelInfo;
import com.android.tools.r8.kotlin.KotlinJvmSignatureExtensionInformation;
import com.android.tools.r8.kotlin.KotlinLambdaInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.Pair;

public class KotlinSyntheticClassInfo
implements KotlinClassLevelInfo {
    private final KotlinLambdaInfo lambda;
    private final String packageName;
    private final int[] metadataVersion;
    private final Flavour flavour;

    private KotlinSyntheticClassInfo(KotlinLambdaInfo lambda, Flavour flavour, String packageName, int[] metadataVersion) {
        this.lambda = lambda;
        this.flavour = flavour;
        this.packageName = packageName;
        this.metadataVersion = metadataVersion;
    }

    static KotlinSyntheticClassInfo create(KotlinClassMetadata.SyntheticClass syntheticClass, String packageName, int[] metadataVersion, DexClass clazz, Kotlin kotlin, AppView<?> appView) {
        KmLambda lambda = syntheticClass.toKmLambda();
        assert (lambda == null || syntheticClass.isLambda());
        KotlinJvmSignatureExtensionInformation extensionInformation = KotlinJvmSignatureExtensionInformation.readInformationFromMessage(syntheticClass, appView.options());
        return new KotlinSyntheticClassInfo(lambda != null ? KotlinLambdaInfo.create(clazz, lambda, appView.dexItemFactory(), appView.reporter(), extensionInformation) : null, KotlinSyntheticClassInfo.getFlavour(clazz, kotlin), packageName, metadataVersion);
    }

    public static Flavour getFlavour(DexClass clazz, Kotlin kotlin) {
        if (clazz.superType == kotlin.functional.lambdaType) {
            return Flavour.KotlinStyleLambda;
        }
        if (clazz.superType == kotlin.factory.objectType && clazz.interfaces.size() == 1) {
            return Flavour.JavaStyleLambda;
        }
        return Flavour.Unclassified;
    }

    public boolean isLambda() {
        return this.lambda != null && this.flavour != Flavour.Unclassified;
    }

    @Override
    public boolean isSyntheticClass() {
        return true;
    }

    @Override
    public KotlinSyntheticClassInfo asSyntheticClass() {
        return this;
    }

    @Override
    public Pair<KotlinClassHeader, Boolean> rewrite(DexClass clazz, AppView<?> appView, NamingLens namingLens) {
        KotlinClassMetadata.SyntheticClass.Writer writer = new KotlinClassMetadata.SyntheticClass.Writer();
        boolean rewritten = false;
        if (this.lambda != null) {
            KmLambda kmLambda = new KmLambda();
            rewritten = this.lambda.rewrite(() -> kmLambda, clazz, appView, namingLens);
            kmLambda.accept(writer);
        }
        return Pair.create(writer.write().getHeader(), rewritten);
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        if (this.lambda != null) {
            this.lambda.trace(definitionSupplier);
        }
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public int[] getMetadataVersion() {
        return this.metadataVersion;
    }

    public static enum Flavour {
        KotlinStyleLambda,
        JavaStyleLambda,
        Unclassified;

    }
}

