/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.kotlin.KotlinMetadataUtils;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.function.Consumer;

class KotlinTypeReference
implements EnqueuerMetadataTraceable {
    private final DexType known;
    private final String originalName;

    private KotlinTypeReference(String originalName, DexType known) {
        this.originalName = originalName;
        this.known = known;
        assert (known != null);
    }

    private KotlinTypeReference(String originalName) {
        this.known = null;
        this.originalName = originalName;
        assert (originalName != null);
    }

    static KotlinTypeReference fromBinaryName(String binaryName, DexItemFactory factory, String originalName) {
        if (DescriptorUtils.isValidBinaryName(binaryName)) {
            return KotlinTypeReference.fromDescriptor(DescriptorUtils.getDescriptorFromClassBinaryName(binaryName), factory, originalName);
        }
        return new KotlinTypeReference(binaryName);
    }

    static KotlinTypeReference fromDescriptor(String descriptor, DexItemFactory factory) {
        return KotlinTypeReference.fromDescriptor(descriptor, factory, descriptor);
    }

    static KotlinTypeReference fromDescriptor(String descriptor, DexItemFactory factory, String originalName) {
        if (DescriptorUtils.isDescriptor(descriptor)) {
            DexType type = factory.createType(descriptor);
            return new KotlinTypeReference(originalName, type);
        }
        return new KotlinTypeReference(originalName);
    }

    private static DexType toRewrittenTypeOrNull(AppView<?> appView, DexType type) {
        if (type.isArrayType()) {
            DexType rewrittenBaseType = KotlinTypeReference.toRewrittenTypeOrNull(appView, type.toBaseType(appView.dexItemFactory()));
            return rewrittenBaseType != null ? type.replaceBaseType(rewrittenBaseType, appView.dexItemFactory()) : null;
        }
        if (!type.isClassType()) {
            return type;
        }
        DexType rewrittenType = appView.graphLens().lookupClassType(type);
        if (((AppInfo)appView.appInfo()).hasLiveness() && !appView.withLiveness().appInfo().isNonProgramTypeOrLiveProgramType(rewrittenType)) {
            return null;
        }
        return rewrittenType;
    }

    public DexType getKnown() {
        return this.known;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    boolean toRenamedDescriptorOrDefault(Consumer<String> rewrittenConsumer, AppView<?> appView, NamingLens namingLens, String defaultValue) {
        if (this.known == null) {
            rewrittenConsumer.accept(this.originalName);
            return false;
        }
        DexType rewrittenType = KotlinTypeReference.toRewrittenTypeOrNull(appView, this.known);
        if (rewrittenType == null) {
            String knownDescriptor = this.known.toDescriptorString();
            if (Kotlin.ClassClassifiers.kotlinStaticallyKnownTypes.contains(knownDescriptor)) {
                rewrittenConsumer.accept(knownDescriptor);
                return false;
            }
            rewrittenConsumer.accept(defaultValue);
            return true;
        }
        String renamedString = namingLens.lookupDescriptor(rewrittenType).toString();
        rewrittenConsumer.accept(renamedString);
        return !this.known.toDescriptorString().equals(renamedString);
    }

    String toKotlinClassifier(boolean isLocalOrAnonymous) {
        if (this.known == null) {
            return this.originalName;
        }
        return KotlinMetadataUtils.getKotlinLocalOrAnonymousNameFromDescriptor(this.known.toDescriptorString(), isLocalOrAnonymous);
    }

    boolean toRenamedBinaryNameOrDefault(Consumer<String> rewrittenConsumer, AppView<?> appView, NamingLens namingLens, String defaultValue) {
        if (this.known == null) {
            rewrittenConsumer.accept(this.originalName);
            return false;
        }
        return this.toRenamedDescriptorOrDefault(descriptor -> {
            if (descriptor == null || descriptor.equals(defaultValue)) {
                rewrittenConsumer.accept((String)descriptor);
            } else {
                rewrittenConsumer.accept(DescriptorUtils.getBinaryNameFromDescriptor(descriptor));
            }
        }, appView, namingLens, defaultValue);
    }

    public String toString() {
        return this.known != null ? this.known.descriptor.toString() : this.originalName;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        if (this.known != null && this.known.isClassType()) {
            definitionSupplier.contextIndependentDefinitionFor(this.known);
        }
    }

    public DexType rewriteType(GraphLens graphLens) {
        if (this.known != null && this.known.isClassType()) {
            return graphLens.lookupClassType(this.known);
        }
        return null;
    }
}

