/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.kotlin;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmValueParameter;
import com.android.tools.r8.jetbrains.kotlinx.metadata.KmValueParameterVisitor;
import com.android.tools.r8.jetbrains.kotlinx.metadata.internal.metadata.deserialization.Flags;
import com.android.tools.r8.kotlin.KmVisitorProviders;
import com.android.tools.r8.kotlin.KotlinTypeInfo;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.EnqueuerMetadataTraceable;
import com.android.tools.r8.utils.Reporter;
import java.util.List;

class KotlinValueParameterInfo
implements EnqueuerMetadataTraceable {
    private static final List<KotlinValueParameterInfo> EMPTY_VALUE_PARAMETERS = ImmutableList.of();
    final String name;
    final int flags;
    final KotlinTypeInfo type;
    final KotlinTypeInfo varargElementType;

    private KotlinValueParameterInfo(int flags, String name, KotlinTypeInfo type, KotlinTypeInfo varargElementType) {
        this.name = name;
        this.flags = flags;
        this.type = type;
        this.varargElementType = varargElementType;
    }

    static KotlinValueParameterInfo create(KmValueParameter kmValueParameter, DexItemFactory factory, Reporter reporter) {
        if (kmValueParameter == null) {
            return null;
        }
        KmType kmType = kmValueParameter.getType();
        return new KotlinValueParameterInfo(kmValueParameter.getFlags(), kmValueParameter.getName(), KotlinTypeInfo.create(kmType, factory, reporter), KotlinTypeInfo.create(kmValueParameter.getVarargElementType(), factory, reporter));
    }

    static List<KotlinValueParameterInfo> create(List<KmValueParameter> parameters, DexItemFactory factory, Reporter reporter) {
        if (parameters.isEmpty()) {
            return EMPTY_VALUE_PARAMETERS;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (KmValueParameter parameter : parameters) {
            builder.add(KotlinValueParameterInfo.create(parameter, factory, reporter));
        }
        return builder.build();
    }

    boolean isCrossInline() {
        return Flags.IS_CROSSINLINE.get(this.flags);
    }

    boolean rewrite(KmVisitorProviders.KmValueParameterVisitorProvider visitorProvider, AppView<?> appView, NamingLens namingLens) {
        KmValueParameterVisitor kmValueParameterVisitor = visitorProvider.get(this.flags, this.name);
        boolean rewritten = this.type.rewrite(kmValueParameterVisitor::visitType, appView, namingLens);
        if (this.varargElementType != null) {
            rewritten |= this.varargElementType.rewrite(kmValueParameterVisitor::visitVarargElementType, appView, namingLens);
        }
        return rewritten;
    }

    @Override
    public void trace(DexDefinitionSupplier definitionSupplier) {
        this.type.trace(definitionSupplier);
        if (this.varargElementType != null) {
            this.varargElementType.trace(definitionSupplier);
        }
    }
}

