/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.common.collect.ImmutableBiMap;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.io.CharSource;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.IndexedDexItem;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMap;
import com.android.tools.r8.naming.ProguardMapReader;
import com.android.tools.r8.naming.mappinginformation.MapVersionMappingInformation;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.utils.BiMapContainer;
import com.android.tools.r8.utils.ChainableStringConsumer;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.Reporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ClassNameMapper
implements ProguardMap {
    private final ImmutableMap<String, ClassNamingForNameMapper> classNameMappings;
    private BiMapContainer<String, String> nameMapping;
    private final Map<MemberNaming.Signature, MemberNaming.Signature> signatureMap = new HashMap<MemberNaming.Signature, MemberNaming.Signature>();
    private final Set<MapVersionMappingInformation> mapVersions;

    public static Builder builder() {
        return new Builder();
    }

    public static ClassNameMapper mapperFromFile(Path path) throws IOException {
        return ClassNameMapper.mapperFromFile(path, MissingFileAction.MISSING_FILE_IS_ERROR);
    }

    public static ClassNameMapper mapperFromFile(Path path, MissingFileAction missingFileAction) throws IOException {
        assert (missingFileAction == MissingFileAction.MISSING_FILE_IS_EMPTY_MAP || missingFileAction == MissingFileAction.MISSING_FILE_IS_ERROR);
        if (missingFileAction == MissingFileAction.MISSING_FILE_IS_EMPTY_MAP && !path.toFile().exists()) {
            return ClassNameMapper.mapperFromString("");
        }
        return ClassNameMapper.mapperFromBufferedReader(Files.newBufferedReader(path, StandardCharsets.UTF_8), null);
    }

    public static ClassNameMapper mapperFromString(String contents) throws IOException {
        return ClassNameMapper.mapperFromBufferedReader(CharSource.wrap(contents).openBufferedStream(), null);
    }

    public static ClassNameMapper mapperFromString(String contents, DiagnosticsHandler diagnosticsHandler) throws IOException {
        return ClassNameMapper.mapperFromBufferedReader(CharSource.wrap(contents).openBufferedStream(), diagnosticsHandler);
    }

    public static ClassNameMapper mapperFromString(String contents, DiagnosticsHandler diagnosticsHandler, boolean allowEmptyMappedRanges, boolean allowExperimentalMapping) throws IOException {
        return ClassNameMapper.mapperFromBufferedReader(CharSource.wrap(contents).openBufferedStream(), diagnosticsHandler, allowEmptyMappedRanges, allowExperimentalMapping);
    }

    private static ClassNameMapper mapperFromBufferedReader(BufferedReader reader, DiagnosticsHandler diagnosticsHandler) throws IOException {
        return ClassNameMapper.mapperFromBufferedReader(reader, diagnosticsHandler, false, false);
    }

    public static ClassNameMapper mapperFromBufferedReader(BufferedReader reader, DiagnosticsHandler diagnosticsHandler, boolean allowEmptyMappedRanges, boolean allowExperimentalMapping) throws IOException {
        ClassNameMapper classNameMapper;
        block11: {
            ProguardMapReader proguardReader;
            block10: {
                proguardReader = new ProguardMapReader(reader, diagnosticsHandler != null ? diagnosticsHandler : new Reporter(), allowEmptyMappedRanges, allowExperimentalMapping);
                Throwable throwable = null;
                try {
                    Builder builder = ClassNameMapper.builder();
                    proguardReader.parse(builder);
                    classNameMapper = builder.build();
                    if (throwable == null) break block10;
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                proguardReader.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            proguardReader.close();
                        }
                        throw throwable3;
                    }
                }
                try {
                    proguardReader.close();
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                break block11;
            }
            proguardReader.close();
        }
        return classNameMapper;
    }

    private ClassNameMapper(ImmutableMap<String, ClassNamingForNameMapper> classNameMappings, Set<MapVersionMappingInformation> mapVersions) {
        this.classNameMappings = classNameMappings;
        this.mapVersions = mapVersions;
    }

    private MemberNaming.Signature canonicalizeSignature(MemberNaming.Signature signature) {
        MemberNaming.Signature result = this.signatureMap.get(signature);
        if (result != null) {
            return result;
        }
        this.signatureMap.put(signature, signature);
        return signature;
    }

    private String deobfuscateType(String asString2) {
        return DescriptorUtils.descriptorToJavaType(asString2, this);
    }

    private String lookupName(MemberNaming.Signature signature, DexType clazz) {
        String decoded = DescriptorUtils.descriptorToJavaType(clazz.descriptor.toString());
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return decoded + " " + signature.toString();
        }
        MemberNaming memberNaming = classNaming.lookup(signature);
        if (memberNaming == null) {
            return classNaming.originalName + " " + signature.toString();
        }
        return classNaming.originalName + " " + memberNaming.signature.toString();
    }

    public Map<String, ClassNamingForNameMapper> getClassNameMappings() {
        return this.classNameMappings;
    }

    public MemberNaming.MethodSignature getRenamedMethodSignature(DexMethod method) {
        DexType[] parameters = method.proto.parameters.values;
        String[] parameterTypes = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = this.deobfuscateType(parameters[i].toDescriptorString());
        }
        String returnType = this.deobfuscateType(method.proto.returnType.toDescriptorString());
        MemberNaming.MethodSignature signature = new MemberNaming.MethodSignature(method.name.toString(), returnType, parameterTypes);
        return (MemberNaming.MethodSignature)this.canonicalizeSignature(signature);
    }

    public MemberNaming.FieldSignature getRenamedFieldSignature(DexField field) {
        String type = this.deobfuscateType(field.type.toDescriptorString());
        return (MemberNaming.FieldSignature)this.canonicalizeSignature(new MemberNaming.FieldSignature(field.name.toString(), type));
    }

    public String deobfuscateClassName(String obfuscatedName) {
        ClassNamingForNameMapper classNaming = this.classNameMappings.get(obfuscatedName);
        if (classNaming == null) {
            return obfuscatedName;
        }
        return classNaming.originalName;
    }

    @Override
    public boolean hasMapping(DexType type) {
        String decoded = DescriptorUtils.descriptorToJavaType(type.descriptor.toString());
        return this.classNameMappings.containsKey(decoded);
    }

    @Override
    public ClassNamingForNameMapper getClassNaming(DexType type) {
        String decoded = DescriptorUtils.descriptorToJavaType(type.descriptor.toString());
        return this.classNameMappings.get(decoded);
    }

    public ClassNamingForNameMapper getClassNaming(String obfuscatedName) {
        return this.classNameMappings.get(obfuscatedName);
    }

    public boolean isEmpty() {
        return this.classNameMappings.isEmpty();
    }

    public ClassNameMapper sorted() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.orderEntriesByValue(Comparator.comparing(x -> x.originalName));
        this.classNameMappings.forEach(builder::put);
        return new ClassNameMapper(builder.build(), this.mapVersions);
    }

    public boolean verifyIsSorted() {
        Iterator<Map.Entry<String, ClassNamingForNameMapper>> iterator2 = this.getClassNameMappings().entrySet().iterator();
        Iterator<Map.Entry<String, ClassNamingForNameMapper>> sortedIterator = this.sorted().getClassNameMappings().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, ClassNamingForNameMapper> entry = iterator2.next();
            Map.Entry<String, ClassNamingForNameMapper> otherEntry = sortedIterator.next();
            assert (entry.getKey().equals(otherEntry.getKey()));
            assert (entry.getValue() == otherEntry.getValue());
        }
        return true;
    }

    public void write(ChainableStringConsumer consumer) {
        assert (this.verifyIsSorted());
        for (ClassNamingForNameMapper naming : this.getClassNameMappings().values()) {
            naming.write(consumer);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.write(ChainableStringConsumer.wrap(builder::append));
        return builder.toString();
    }

    public BiMapContainer<String, String> getObfuscatedToOriginalMapping() {
        if (this.nameMapping == null) {
            ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
            for (String name : this.classNameMappings.keySet()) {
                builder.put(name, this.classNameMappings.get((Object)name).originalName);
            }
            ImmutableMap classNameMappings = builder.build();
            this.nameMapping = new BiMapContainer(classNameMappings, classNameMappings.inverse());
        }
        return this.nameMapping;
    }

    public boolean equals(Object o) {
        return o instanceof ClassNameMapper && this.classNameMappings.equals(((ClassNameMapper)o).classNameMappings);
    }

    public int hashCode() {
        return 31 * this.classNameMappings.hashCode();
    }

    public String originalNameOf(IndexedDexItem item) {
        if (item instanceof DexField) {
            return this.lookupName(this.getRenamedFieldSignature((DexField)item), ((DexField)item).holder);
        }
        if (item instanceof DexMethod) {
            return this.lookupName(this.getRenamedMethodSignature((DexMethod)item), ((DexMethod)item).holder);
        }
        if (item instanceof DexType) {
            return DescriptorUtils.descriptorToJavaType(((DexType)item).toDescriptorString(), this);
        }
        return item.toString();
    }

    public MemberNaming.MethodSignature originalSignatureOf(DexMethod method) {
        String decoded = DescriptorUtils.descriptorToJavaType(method.holder.descriptor.toString());
        MemberNaming.MethodSignature memberSignature = this.getRenamedMethodSignature(method);
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return memberSignature;
        }
        MemberNaming memberNaming = classNaming.lookup(memberSignature);
        if (memberNaming == null) {
            return memberSignature;
        }
        return (MemberNaming.MethodSignature)memberNaming.signature;
    }

    public MemberNaming.FieldSignature originalSignatureOf(DexField field) {
        String decoded = DescriptorUtils.descriptorToJavaType(field.holder.descriptor.toString());
        MemberNaming.FieldSignature memberSignature = this.getRenamedFieldSignature(field);
        ClassNamingForNameMapper classNaming = this.getClassNaming(decoded);
        if (classNaming == null) {
            return memberSignature;
        }
        MemberNaming memberNaming = classNaming.lookup(memberSignature);
        if (memberNaming == null) {
            return memberSignature;
        }
        return (MemberNaming.FieldSignature)memberNaming.signature;
    }

    public String originalNameOf(DexType clazz) {
        return this.deobfuscateType(clazz.descriptor.toString());
    }

    public Set<MapVersionMappingInformation> getMapVersions() {
        return this.mapVersions;
    }

    public static class Builder
    extends ProguardMap.Builder {
        private final Map<String, ClassNamingForNameMapper.Builder> mapping = new HashMap<String, ClassNamingForNameMapper.Builder>();
        private LinkedHashSet<MapVersionMappingInformation> mapVersions = new LinkedHashSet();

        private Builder() {
        }

        private ImmutableMap<String, ClassNamingForNameMapper> buildClassNameMappings() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.orderEntriesByValue(Comparator.comparing(x -> x.originalName));
            this.mapping.forEach((renamedName, valueBuilder) -> builder.put(renamedName, valueBuilder.build()));
            return builder.build();
        }

        @Override
        public ClassNamingForNameMapper.Builder classNamingBuilder(String renamedName, String originalName, Position position) {
            ClassNamingForNameMapper.Builder classNamingBuilder = ClassNamingForNameMapper.builder(renamedName, originalName);
            this.mapping.put(renamedName, classNamingBuilder);
            return classNamingBuilder;
        }

        @Override
        public ClassNameMapper build() {
            return new ClassNameMapper(this.buildClassNameMappings(), this.mapVersions);
        }

        @Override
        ProguardMap.Builder setCurrentMapVersion(MapVersionMappingInformation mapVersion) {
            this.mapVersions.add(mapVersion);
            return this;
        }
    }

    public static enum MissingFileAction {
        MISSING_FILE_IS_EMPTY_MAP,
        MISSING_FILE_IS_ERROR;

    }
}

