/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ProgramOrClasspathClass;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

class ClassNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final ClassNamingStrategy classNamingStrategy;
    private final Iterable<? extends ProgramOrClasspathClass> classes;
    private final Set<String> usedTypeNames = Sets.newHashSet();
    private final Map<DexType, DexString> renaming = Maps.newIdentityHashMap();
    private final Map<String, Namespace> states = new HashMap<String, Namespace>();
    private final boolean keepInnerClassStructure;
    private final Namespace topLevelState;
    private final boolean allowMixedCaseNaming;
    private final Predicate<String> isUsed;

    ClassNameMinifier(AppView<AppInfoWithLiveness> appView, ClassNamingStrategy classNamingStrategy, Iterable<? extends ProgramOrClasspathClass> classes) {
        this.appView = appView;
        this.classNamingStrategy = classNamingStrategy;
        this.classes = classes;
        InternalOptions options = appView.options();
        this.keepInnerClassStructure = options.keepInnerClassStructure();
        this.topLevelState = new Namespace("");
        this.states.put("", this.topLevelState);
        if (options.getProguardConfiguration().hasDontUseMixedCaseClassnames()) {
            this.allowMixedCaseNaming = false;
            this.isUsed = candidate -> this.usedTypeNames.contains(candidate.toLowerCase());
        } else {
            this.allowMixedCaseNaming = true;
            this.isUsed = this.usedTypeNames::contains;
        }
    }

    private void setUsedTypeName(String typeName) {
        this.usedTypeNames.add(this.allowMixedCaseNaming ? typeName : typeName.toLowerCase());
    }

    private boolean verifyMemberRenamingOfInnerClasses(DexClass clazz, DexString renamed) {
        assert (!this.keepInnerClassStructure || !clazz.isMemberClass() || !clazz.getType().getInternalName().contains(String.valueOf('$')) || renamed.toString().contains(String.valueOf('$')) || this.classNamingStrategy.isRenamedByApplyMapping(clazz.getType())) : clazz + " -> " + renamed;
        return true;
    }

    private Map<String, String> getPackageRenaming() {
        ImmutableMap.Builder<String, String> packageRenaming = ImmutableMap.builder();
        for (Map.Entry<String, Namespace> entry : this.states.entrySet()) {
            String originalPackageName = entry.getKey();
            String minifiedPackageName = entry.getValue().getPackageName();
            if (minifiedPackageName.equals(originalPackageName)) continue;
            packageRenaming.put(originalPackageName, minifiedPackageName);
        }
        return packageRenaming.build();
    }

    private void renameDanglingTypes(ProgramOrClasspathClass clazz) {
        clazz.forEachClassMethod(this::renameDanglingTypesInMethod);
        clazz.forEachClassField(this::renameDanglingTypesInField);
    }

    private void renameDanglingTypesInField(DexClassAndField field) {
        this.renameDanglingType(((DexField)field.getReference()).type);
    }

    private void renameDanglingTypesInMethod(DexClassAndMethod method) {
        DexProto proto = ((DexMethod)method.getReference()).proto;
        this.renameDanglingType(proto.returnType);
        for (DexType type : proto.parameters.values) {
            this.renameDanglingType(type);
        }
    }

    private void renameDanglingType(DexType type) {
        if (this.appView.appInfo().wasPruned(type) && !this.renaming.containsKey(type)) {
            assert (this.appView.definitionFor(type) == null);
            DexString descriptor = this.classNamingStrategy.reservedDescriptor(type);
            this.renaming.put(type, descriptor != null ? descriptor : this.topLevelState.nextTypeName(type));
        }
    }

    private void registerClassAsUsed(DexType type, DexString descriptor) {
        DexType outerClass;
        this.renaming.put(type, descriptor);
        this.setUsedTypeName(descriptor.toString());
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null && !this.renaming.containsKey(outerClass) && this.classNamingStrategy.reservedDescriptor(outerClass) == null) {
            this.registerClassAsUsed(outerClass, outerClass.descriptor);
        }
    }

    private DexType getOutClassForType(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            return null;
        }
        InnerClassAttribute attribute = clazz.getInnerClassAttributeForThisClass();
        if (attribute == null) {
            return null;
        }
        return attribute.getLiveContext(this.appView);
    }

    private DexString computeName(DexType type) {
        DexType outerClass;
        Namespace state = null;
        if (this.keepInnerClassStructure && (outerClass = this.getOutClassForType(type)) != null) {
            DexClass clazz = this.appView.definitionFor(type);
            assert (clazz != null);
            InnerClassAttribute attribute = clazz.getInnerClassAttributeForThisClass();
            assert (attribute != null);
            String separator = DescriptorUtils.computeInnerClassSeparator(attribute.getOuter(), type, attribute.getInnerName());
            if (separator == null) {
                separator = String.valueOf('$');
            }
            state = this.getStateForOuterClass(outerClass, separator);
        }
        if (state == null) {
            state = this.getStateForClass(type);
        }
        return state.nextTypeName(type);
    }

    private Namespace getStateForClass(DexType type) {
        String packageName = DescriptorUtils.getPackageBinaryNameFromJavaType(type.getPackageDescriptor());
        return this.states.computeIfAbsent(packageName, x$0 -> new Namespace((String)x$0));
    }

    private Namespace getStateForOuterClass(DexType outer, String innerClassSeparator) {
        String prefix = DescriptorUtils.getClassBinaryNameFromDescriptor(outer.toDescriptorString());
        Namespace state = this.states.get(prefix);
        if (state == null) {
            DexString renamed = this.renaming.get(outer);
            if (renamed == null) {
                renamed = this.computeName(outer);
                this.renaming.put(outer, renamed);
            }
            String binaryName = DescriptorUtils.getClassBinaryNameFromDescriptor(renamed.toString());
            state = new Namespace(binaryName, innerClassSeparator);
            this.states.put(prefix, state);
        }
        return state;
    }

    static String getParentPackagePrefix(String packagePrefix) {
        int i = packagePrefix.lastIndexOf(47);
        if (i < 0) {
            return "";
        }
        return packagePrefix.substring(0, i);
    }

    ClassRenaming computeRenaming(Timing timing) {
        timing.begin("reserve");
        for (ProgramOrClasspathClass programOrClasspathClass : this.classes) {
            DexString descriptor = this.classNamingStrategy.reservedDescriptor(programOrClasspathClass.getType());
            if (descriptor == null) continue;
            assert (!this.renaming.containsKey(programOrClasspathClass.getType()));
            this.registerClassAsUsed(programOrClasspathClass.getType(), descriptor);
        }
        this.appView.appInfo().getMissingClasses().forEach(missingClass -> this.registerClassAsUsed((DexType)missingClass, missingClass.getDescriptor()));
        timing.end();
        timing.begin("rename-classes");
        for (ProgramOrClasspathClass programOrClasspathClass : this.classes) {
            if (this.renaming.containsKey(programOrClasspathClass.getType())) continue;
            DexString renamed = this.computeName(programOrClasspathClass.getType());
            this.renaming.put(programOrClasspathClass.getType(), renamed);
            assert (this.verifyMemberRenamingOfInnerClasses(programOrClasspathClass.asDexClass(), renamed));
        }
        timing.end();
        timing.begin("rename-dangling-types");
        for (ProgramOrClasspathClass programOrClasspathClass : this.classes) {
            this.renameDanglingTypes(programOrClasspathClass);
        }
        timing.end();
        return new ClassRenaming(Collections.unmodifiableMap(this.renaming), this.getPackageRenaming());
    }

    protected static interface ClassNamingStrategy {
        public DexString next(DexType var1, char[] var2, InternalNamingState var3, Predicate<String> var4);

        public DexString reservedDescriptor(DexType var1);

        public boolean isRenamedByApplyMapping(DexType var1);
    }

    protected class Namespace
    implements InternalNamingState {
        private final String packageName;
        private final char[] packagePrefix;
        private int dictionaryIndex = 0;
        private int nameIndex = 1;

        Namespace(String packageName) {
            this(packageName, String.valueOf('/'));
        }

        Namespace(String packageName, String separator) {
            this.packageName = packageName;
            this.packagePrefix = ("L" + packageName + (packageName.isEmpty() ? "" : separator)).toCharArray();
        }

        public String getPackageName() {
            return this.packageName;
        }

        DexString nextTypeName(DexType type) {
            DexString candidate = ClassNameMinifier.this.classNamingStrategy.next(type, this.packagePrefix, this, ClassNameMinifier.this.isUsed);
            assert (!ClassNameMinifier.this.usedTypeNames.contains(candidate.toString()));
            ClassNameMinifier.this.setUsedTypeName(candidate.toString());
            return candidate;
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        @Override
        public int incrementNameIndex() {
            return this.nameIndex++;
        }
    }

    static class ClassRenaming {
        final Map<String, String> packageRenaming;
        final Map<DexType, DexString> classRenaming;

        private ClassRenaming(Map<DexType, DexString> classRenaming, Map<String, String> packageRenaming) {
            this.classRenaming = classRenaming;
            this.packageRenaming = packageRenaming;
        }
    }
}

