/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.graph.TopDownClassHierarchyTraversal;
import com.android.tools.r8.naming.FieldNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.ReservedFieldNamingState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class FieldNameMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final SubtypingInfo subtypingInfo;
    private final Map<DexField, DexString> renaming = new IdentityHashMap<DexField, DexString>();
    private final Map<DexType, ReservedFieldNamingState> reservedNamingStates = new IdentityHashMap<DexType, ReservedFieldNamingState>();
    private final MemberNamingStrategy strategy;
    private final Map<DexType, DexType> frontiers = new IdentityHashMap<DexType, DexType>();
    private final Map<DexType, Set<ReservedFieldNamingState>> frontierStatesForInterfaces = new IdentityHashMap<DexType, Set<ReservedFieldNamingState>>();

    FieldNameMinifier(AppView<AppInfoWithLiveness> appView, SubtypingInfo subtypingInfo, MemberNamingStrategy strategy) {
        this.appView = appView;
        this.subtypingInfo = subtypingInfo;
        this.strategy = strategy;
    }

    private ReservedFieldNamingState getReservedFieldNamingState(DexType type) {
        return this.reservedNamingStates.get(type);
    }

    private ReservedFieldNamingState getOrCreateReservedFieldNamingState(DexType type) {
        return this.reservedNamingStates.computeIfAbsent(type, ignore -> new ReservedFieldNamingState(this.appView));
    }

    private void reserveFieldNames() {
        TopDownClassHierarchyTraversal.forAllClasses(this.appView).visit(this.appView.appInfo().classes(), clazz -> {
            DexType frontier;
            DexType dexType = frontier = clazz.superType == null ? this.appView.dexItemFactory().objectType : this.frontiers.getOrDefault(clazz.superType, clazz.type);
            if (frontier != clazz.type || clazz.isProgramClass()) {
                DexType existingValue = this.frontiers.put(clazz.type, frontier);
                assert (existingValue == null);
            }
            ReservedFieldNamingState reservationState = this.getOrCreateReservedFieldNamingState(frontier);
            for (DexEncodedField field : clazz.fields()) {
                DexString reservedName = this.strategy.getReservedName(field, (DexClass)clazz);
                if (reservedName == null) continue;
                reservationState.markReserved(reservedName, ((DexField)field.getReference()).name, ((DexField)field.getReference()).type);
                if (reservedName == ((DexField)field.getReference()).name) continue;
                this.renaming.put((DexField)field.getReference(), reservedName);
            }
            if (clazz.isInterface()) {
                this.frontierStatesForInterfaces.put(clazz.type, SetUtils.newIdentityHashSet(reservationState));
            }
            for (DexType superType : clazz.allImmediateSupertypes()) {
                DexClass superClass;
                if (superType == this.appView.dexItemFactory().objectType) continue;
                ReservedFieldNamingState superReservationState = this.getOrCreateReservedFieldNamingState(this.frontiers.getOrDefault(superType, superType));
                if (superReservationState != reservationState) {
                    reservationState.includeReservations(superReservationState);
                }
                if (!clazz.isProgramClass() || (superClass = this.appView.definitionFor(superType, clazz.asProgramClass())) == null || !superClass.isInterface()) continue;
                this.frontierStatesForInterfaces.get(superType).add(reservationState);
            }
            if (frontier == clazz.type && clazz.isProgramClass()) {
                this.patchUpAllIndirectlyImplementingInterfacesFromLibraryAndClassPath(clazz.asProgramClass(), reservationState);
            }
        });
    }

    private void patchUpAllIndirectlyImplementingInterfacesFromLibraryAndClassPath(DexProgramClass clazz, ReservedFieldNamingState reservationState) {
        this.appView.appInfo().traverseSuperTypes(clazz, (superType, superClass, isInterface) -> {
            Set<ReservedFieldNamingState> reservedNamingState;
            if (isInterface.booleanValue() && superClass.isNotProgramClass() && (reservedNamingState = this.frontierStatesForInterfaces.get(superType)) != null) {
                reservedNamingState.add(reservationState);
            }
            return TraversalContinuation.doContinue();
        });
    }

    private void renameFieldsInClasses() {
        IdentityHashMap states = new IdentityHashMap();
        ((TopDownClassHierarchyTraversal)TopDownClassHierarchyTraversal.forAllClasses(this.appView).excludeInterfaces()).visit(this.appView.appInfo().classes(), clazz -> {
            assert (!clazz.isInterface());
            FieldNamingState parentState = clazz.superType == null ? new FieldNamingState(this.appView, this.strategy) : states.computeIfAbsent(clazz.superType, key -> new FieldNamingState(this.appView, this.strategy)).clone();
            ReservedFieldNamingState reservedNames = this.getReservedFieldNamingState(this.frontiers.getOrDefault(clazz.type, clazz.type));
            FieldNamingState state = parentState.createChildState(reservedNames);
            if (clazz.isProgramClass()) {
                clazz.asProgramClass().forEachProgramField(field -> this.renameField((ProgramField)field, state));
            }
            assert (!states.containsKey(clazz.type));
            states.put(clazz.type, state);
        });
    }

    private void renameFieldsInUnrelatedClasspathClasses() {
        if (this.appView.options().getProguardConfiguration().hasApplyMappingFile()) {
            this.appView.appInfo().forEachReferencedClasspathClass(clazz -> {
                for (DexEncodedField field : clazz.fields()) {
                    DexString reservedName = this.strategy.getReservedName(field, (DexClass)clazz);
                    if (reservedName == null || reservedName == ((DexField)field.getReference()).name) continue;
                    this.renaming.put((DexField)field.getReference(), reservedName);
                }
            });
        }
    }

    private void renameFieldsInInterfaces(Collection<DexClass> interfaces) {
        InterfacePartitioning partitioning = new InterfacePartitioning(this);
        for (Set partition : partitioning.sortedPartitions(interfaces)) {
            this.renameFieldsInInterfacePartition(partition);
        }
    }

    private void renameFieldsInInterfacePartition(Set<DexClass> partition) {
        ReservedFieldNamingState namesToBeReservedInImplementsSubclasses = new ReservedFieldNamingState(this.appView);
        ReservedFieldNamingState reservedNamesInPartition = new ReservedFieldNamingState(this.appView);
        for (DexClass clazz : partition) {
            ReservedFieldNamingState reservedNamesInInterface = this.getReservedFieldNamingState(this.frontiers.getOrDefault(clazz.type, clazz.type));
            if (reservedNamesInInterface == null) continue;
            reservedNamesInPartition.includeReservations(reservedNamesInInterface);
            Set<ReservedFieldNamingState> reservedFieldNamingStates = this.frontierStatesForInterfaces.get(clazz.type);
            assert (reservedFieldNamingStates != null);
            reservedFieldNamingStates.forEach(reservedStates -> {
                reservedNamesInPartition.includeReservations((ReservedFieldNamingState)reservedStates);
                reservedStates.setInterfaceMinificationState(namesToBeReservedInImplementsSubclasses);
            });
        }
        FieldNamingState state = new FieldNamingState(this.appView, this.strategy, reservedNamesInPartition);
        for (DexClass clazz : partition) {
            if (!clazz.isProgramClass()) continue;
            assert (clazz.isInterface());
            clazz.asProgramClass().forEachProgramField(field -> {
                DexString newName = this.renameField((ProgramField)field, state);
                namesToBeReservedInImplementsSubclasses.markReserved(newName, ((DexField)field.getReference()).name, ((DexField)field.getReference()).type);
            });
        }
    }

    private DexString renameField(ProgramField field, FieldNamingState state) {
        DexString newName = state.getOrCreateNameFor(field);
        if (newName != ((DexField)field.getReference()).name) {
            this.renaming.put((DexField)field.getReference(), newName);
        }
        return newName;
    }

    private void renameNonReboundReferences() {
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        fieldAccessInfoCollection.forEach(this::renameNonReboundAccessesToField);
    }

    private void renameNonReboundAccessesToField(FieldAccessInfo fieldAccessInfo) {
        fieldAccessInfo.forEachIndirectAccess(this::renameNonReboundAccessToField);
    }

    private void renameNonReboundAccessToField(DexField field) {
        if (this.renaming.containsKey(field)) {
            return;
        }
        DexProgramClass holder = DexProgramClass.asProgramClassOrNull(this.appView.definitionForHolder(field));
        if (holder == null) {
            return;
        }
        DexEncodedField definition = this.appView.appInfo().resolveFieldOn(holder, field).getResolvedField();
        if (definition != null && definition.getReference() != field && this.renaming.containsKey(definition.getReference())) {
            this.renaming.put(field, this.renaming.get(definition.getReference()));
        }
    }

    FieldRenaming computeRenaming(Collection<DexClass> interfaces, Timing timing) {
        timing.begin("reserve-names");
        this.reserveFieldNames();
        timing.end();
        timing.begin("rename-definitions");
        this.renameFieldsInInterfaces(interfaces);
        this.renameFieldsInClasses();
        this.renameFieldsInUnrelatedClasspathClasses();
        timing.end();
        timing.begin("rename-references");
        this.renameNonReboundReferences();
        timing.end();
        return new FieldRenaming(this.renaming);
    }

    static class InterfacePartitioning {
        private final FieldNameMinifier minifier;
        private final AppView<AppInfoWithLiveness> appView;
        private final Set<DexType> visited = Sets.newIdentityHashSet();

        InterfacePartitioning(FieldNameMinifier minifier) {
            this.minifier = minifier;
            this.appView = minifier.appView;
        }

        private List<Set<DexClass>> sortedPartitions(Collection<DexClass> interfaces) {
            ArrayList<Set<DexClass>> partitions = new ArrayList<Set<DexClass>>();
            for (DexClass clazz : interfaces) {
                if (clazz == null || !this.visited.add(clazz.type)) continue;
                Set<DexClass> partition = this.buildSortedPartition(clazz);
                assert (!partition.isEmpty());
                assert (partition.stream().allMatch(DexClass::isInterface));
                assert (partition.stream().map(DexClass::getType).allMatch(this.visited::contains));
                partitions.add(partition);
            }
            return partitions;
        }

        private Set<DexClass> buildSortedPartition(DexClass src) {
            TreeSet<DexClass> partition = new TreeSet<DexClass>(Comparator.comparing(DexClass::getType));
            ArrayDeque<DexType> worklist = new ArrayDeque<DexType>();
            worklist.add(src.type);
            while (!worklist.isEmpty()) {
                DexType type = (DexType)worklist.removeFirst();
                DexClass clazz = this.appView.definitionFor(type);
                if (clazz == null) continue;
                for (DexType superinterface : clazz.interfaces.values) {
                    if (!this.visited.add(superinterface)) continue;
                    worklist.add(superinterface);
                }
                if (clazz.isInterface()) {
                    partition.add(clazz);
                    for (DexType subtype : this.minifier.subtypingInfo.allImmediateSubtypes(type)) {
                        if (!this.visited.add(subtype)) continue;
                        worklist.add(subtype);
                    }
                    continue;
                }
                if (clazz.type == this.appView.dexItemFactory().objectType) continue;
                if (this.visited.add(clazz.superType)) {
                    worklist.add(clazz.superType);
                }
                for (DexType subclass : this.minifier.subtypingInfo.allImmediateExtendsSubtypes(type)) {
                    if (!this.visited.add(subclass)) continue;
                    worklist.add(subclass);
                }
            }
            return partition;
        }
    }

    static class FieldRenaming {
        final Map<DexField, DexString> renaming;

        private FieldRenaming(Map<DexField, DexString> renaming) {
            this.renaming = renaming;
        }

        public static FieldRenaming empty() {
            return new FieldRenaming(ImmutableMap.of());
        }
    }
}

