/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.naming.FieldNamingStateBase;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.ReservedFieldNamingState;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;

public class FieldNamingState
extends FieldNamingStateBase<InternalState>
implements Cloneable {
    private final ReservedFieldNamingState reservedNames;
    private final MemberNamingStrategy strategy;
    private final BiPredicate<DexString, ProgramField> isAvailable;

    public FieldNamingState(AppView<? extends AppInfoWithClassHierarchy> appView, MemberNamingStrategy strategy) {
        this(appView, strategy, new ReservedFieldNamingState(appView));
    }

    public FieldNamingState(AppView<? extends AppInfoWithClassHierarchy> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames) {
        this(appView, strategy, reservedNames, new IdentityHashMap<DexType, InternalState>());
    }

    private FieldNamingState(AppView<? extends AppInfoWithClassHierarchy> appView, MemberNamingStrategy strategy, ReservedFieldNamingState reservedNames, Map<DexType, InternalState> internalStates) {
        super(appView, internalStates);
        this.reservedNames = reservedNames;
        this.strategy = strategy;
        this.isAvailable = (newName, field) -> !reservedNames.isReserved((DexString)newName, ((DexField)field.getReference()).type);
    }

    public FieldNamingState createChildState(ReservedFieldNamingState reservedNames) {
        return new FieldNamingState(this.appView, this.strategy, reservedNames, this.internalStates);
    }

    public DexString getOrCreateNameFor(ProgramField field) {
        DexString reservedName = this.strategy.getReservedName((DexEncodedField)field.getDefinition(), (DexClass)field.getHolder());
        if (reservedName != null) {
            return reservedName;
        }
        return ((InternalState)this.getOrCreateInternalState((DexField)field.getReference())).createNewName(field);
    }

    public void includeReservations(ReservedFieldNamingState reservedNames) {
        this.reservedNames.includeReservations(reservedNames);
    }

    @Override
    public InternalState createInternalState() {
        return new InternalState();
    }

    public FieldNamingState clone() {
        IdentityHashMap<DexType, InternalState> internalStatesClone = new IdentityHashMap<DexType, InternalState>();
        for (Map.Entry entry : this.internalStates.entrySet()) {
            internalStatesClone.put((DexType)entry.getKey(), ((InternalState)entry.getValue()).clone());
        }
        return new FieldNamingState(this.appView, this.strategy, this.reservedNames, internalStatesClone);
    }

    class InternalState
    implements InternalNamingState,
    Cloneable {
        private int dictionaryIndex;
        private int nextNameIndex;

        public InternalState() {
            this(1, 0);
        }

        public InternalState(int nextNameIndex, int dictionaryIndex) {
            this.dictionaryIndex = dictionaryIndex;
            this.nextNameIndex = nextNameIndex;
        }

        public DexString createNewName(ProgramField field) {
            DexString name = FieldNamingState.this.strategy.next(field, (InternalNamingState)this, FieldNamingState.this.isAvailable);
            assert (!FieldNamingState.this.reservedNames.isReserved(name, ((DexField)field.getReference()).type));
            return name;
        }

        public InternalState clone() {
            return new InternalState(this.nextNameIndex, this.dictionaryIndex);
        }

        @Override
        public int getDictionaryIndex() {
            return this.dictionaryIndex;
        }

        @Override
        public int incrementDictionaryIndex() {
            return this.dictionaryIndex++;
        }

        @Override
        public int incrementNameIndex() {
            return this.nextNameIndex++;
        }
    }
}

