/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.naming.MethodNamingStateBase;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

class MethodReservationState<KeyType>
extends MethodNamingStateBase<KeyType, InternalReservationState> {
    private final MethodReservationState<KeyType> parentNamingState;

    private MethodReservationState(MethodReservationState<KeyType> parentNamingState, Function<DexMethod, KeyType> keyTransform) {
        super(keyTransform);
        this.parentNamingState = parentNamingState;
    }

    public static <KeyType> MethodReservationState<KeyType> createRoot(Function<DexMethod, KeyType> keyTransform) {
        return new MethodReservationState<KeyType>(null, keyTransform);
    }

    MethodReservationState<KeyType> createChild() {
        return new MethodReservationState<KeyType>(this, this.keyTransform);
    }

    void reserveName(DexString reservedName, DexEncodedMethod method) {
        try {
            ((InternalReservationState)this.getOrCreateInternalState((DexMethod)method.getReference())).reserveName(method, reservedName);
        }
        catch (AssertionError err) {
            throw new RuntimeException(String.format("Assertion error when trying to reserve name '%s' for method '%s'", reservedName, method), (Throwable)((Object)err));
        }
    }

    boolean isReserved(DexString name, DexMethod method) {
        InternalReservationState internalState = (InternalReservationState)this.getInternalState(method);
        if (internalState != null && internalState.isReserved(name)) {
            return true;
        }
        if (this.parentNamingState != null) {
            return this.parentNamingState.isReserved(name, method);
        }
        return false;
    }

    Set<DexString> getReservedNamesFor(DexMethod method) {
        InternalReservationState internalState = (InternalReservationState)this.getInternalState(method);
        Set<DexString> reservedName = null;
        if (internalState != null) {
            reservedName = internalState.getAssignedNamesFor(method);
        }
        if (reservedName == null && this.parentNamingState != null) {
            reservedName = this.parentNamingState.getReservedNamesFor(method);
        }
        return reservedName;
    }

    @Override
    InternalReservationState createInternalState(DexMethod method) {
        return new InternalReservationState();
    }

    static class InternalReservationState {
        private Map<Equivalence.Wrapper<DexMethod>, Set<DexString>> originalToReservedNames = null;
        private Set<DexString> reservedNames = null;

        InternalReservationState() {
        }

        boolean isReserved(DexString name) {
            return this.reservedNames != null && this.reservedNames.contains(name);
        }

        Set<DexString> getAssignedNamesFor(DexMethod method) {
            if (this.originalToReservedNames == null) {
                return null;
            }
            return this.originalToReservedNames.get(MethodSignatureEquivalence.get().wrap(method));
        }

        void reserveName(DexEncodedMethod method, DexString name) {
            if (this.reservedNames == null) {
                assert (this.originalToReservedNames == null);
                this.originalToReservedNames = new HashMap<Equivalence.Wrapper<DexMethod>, Set<DexString>>();
                this.reservedNames = new HashSet<DexString>();
            }
            Equivalence.Wrapper<DexMethod> wrapped = MethodSignatureEquivalence.get().wrap((DexMethod)method.getReference());
            this.originalToReservedNames.computeIfAbsent(wrapped, ignore -> new HashSet()).add(name);
            this.reservedNames.add(name);
        }
    }
}

