/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.IdentityHashMap;
import java.util.Map;

class MinifiedRenaming
extends NamingLens.NonIdentityNamingLens {
    final AppView<? extends AppInfoWithClassHierarchy> appView;
    private final Map<String, String> packageRenaming;
    private final Map<DexItem, DexString> renaming = new IdentityHashMap<DexItem, DexString>();

    MinifiedRenaming(AppView<? extends AppInfoWithClassHierarchy> appView, ClassNameMinifier.ClassRenaming classRenaming, MethodNameMinifier.MethodRenaming methodRenaming, FieldNameMinifier.FieldRenaming fieldRenaming) {
        super(appView.dexItemFactory());
        this.appView = appView;
        this.packageRenaming = classRenaming.packageRenaming;
        this.renaming.putAll(classRenaming.classRenaming);
        this.renaming.putAll(methodRenaming.renaming);
        this.renaming.putAll(fieldRenaming.renaming);
    }

    @Override
    public String lookupPackageName(String packageName) {
        return this.packageRenaming.getOrDefault(packageName, packageName);
    }

    @Override
    protected DexString internalLookupClassDescriptor(DexType type) {
        return this.renaming.getOrDefault(type, type.descriptor);
    }

    @Override
    public DexString lookupInnerName(InnerClassAttribute attribute, InternalOptions options) {
        int index;
        String innerTypeMapped;
        if (attribute.getInnerName() == null) {
            return null;
        }
        DexType innerType = attribute.getInner();
        String inner = DescriptorUtils.descriptorToInternalName(innerType.descriptor.toString());
        if (inner.equals(innerTypeMapped = DescriptorUtils.descriptorToInternalName(this.lookupDescriptor(innerType).toString()))) {
            return attribute.getInnerName();
        }
        String separator = DescriptorUtils.computeInnerClassSeparator(attribute.getOuter(), innerType, attribute.getInnerName());
        if (separator == null) {
            separator = String.valueOf('$');
        }
        if ((index = innerTypeMapped.lastIndexOf(separator)) < 0) {
            assert (!options.keepInnerClassStructure() || options.getProguardConfiguration().hasApplyMappingFile()) : innerType + " -> " + innerTypeMapped;
            String descriptor = this.lookupDescriptor(innerType).toString();
            return options.itemFactory.createString(DescriptorUtils.getUnqualifiedClassNameFromDescriptor(descriptor));
        }
        return options.itemFactory.createString(innerTypeMapped.substring(index + separator.length()));
    }

    @Override
    public DexString lookupName(DexMethod method) {
        return this.renaming.getOrDefault(method, method.getName());
    }

    @Override
    public DexString lookupName(DexField field) {
        return this.renaming.getOrDefault(field, field.getName());
    }

    @Override
    public boolean verifyRenamingConsistentWithResolution(DexMethod method) {
        if (method.holder.isArrayType()) {
            return true;
        }
        MethodResolutionResult resolution = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(method);
        assert (resolution != null);
        if (resolution.isSingleResolution()) {
            DexEncodedMethod resolvedMethod = resolution.asSingleResolution().getResolvedMethod();
            assert (this.lookupName(method) == this.lookupName((DexMethod)resolvedMethod.getReference()));
            return true;
        }
        assert (resolution.isFailedResolution());
        resolution.asFailedResolution().forEachFailureDependency(failureDependence -> {
            assert (this.lookupName(method) == this.lookupName((DexMethod)failureDependence.getReference()));
        });
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.renaming.forEach((item, str) -> {
            if (item instanceof DexType) {
                builder.append("[c] ");
            } else if (item instanceof DexMethod) {
                builder.append("[m] ");
            } else if (item instanceof DexField) {
                builder.append("[f] ");
            }
            builder.append(item.toSourceString());
            builder.append(" -> ");
            builder.append(str.toSourceString());
            builder.append('\n');
        });
        return builder.toString();
    }
}

