/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.IdentifierMinifier;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNamingStrategy;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MinifiedRenaming;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringUtils;
import com.android.tools.r8.utils.SymbolGenerationUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class Minifier {
    private final AppView<AppInfoWithLiveness> appView;

    public Minifier(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private List<DexClass> computeReachableInterfacesWithDeterministicOrder(SubtypingInfo subtypingInfo) {
        ArrayList interfaces = new ArrayList();
        subtypingInfo.forAllInterfaceRoots(type -> {
            DexClass clazz = this.appView.contextIndependentDefinitionFor((DexType)type);
            if (clazz != null) {
                interfaces.add(clazz);
            }
        });
        return DexApplication.classesWithDeterministicOrder(interfaces);
    }

    public NamingLens run(ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (this.appView.options().isMinifying());
        SubtypingInfo subtypingInfo = this.appView.appInfo().computeSubtypingInfo();
        timing.begin("ComputeInterfaces");
        List<DexClass> interfaces = this.computeReachableInterfacesWithDeterministicOrder(subtypingInfo);
        timing.end();
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new MinificationClassNamingStrategy(this.appView), this.appView.appInfo().classesWithDeterministicOrder());
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, MethodNameMinifier.MethodRenaming.empty(), FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        MinifierMemberNamingStrategy minifyMembers = new MinifierMemberNamingStrategy(this.appView);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, minifyMembers).computeRenaming(interfaces, subtypingInfo, executorService, timing);
        timing.end();
        assert (new MinifiedRenaming(this.appView, classRenaming, methodRenaming, FieldNameMinifier.FieldRenaming.empty()).verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, subtypingInfo, minifyMembers).computeRenaming(interfaces, timing);
        timing.end();
        MinifiedRenaming lens = new MinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming);
        assert (lens.verifyNoCollisions(this.appView.appInfo().classes(), this.appView.dexItemFactory()));
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run(executorService);
        timing.end();
        return lens;
    }

    static class MinifierMemberNamingStrategy
    extends BaseMinificationNamingStrategy
    implements MemberNamingStrategy {
        final AppView<AppInfoWithLiveness> appView;
        private final DexItemFactory factory;
        private final boolean desugaredLibraryRenaming;

        public MinifierMemberNamingStrategy(AppView<AppInfoWithLiveness> appView) {
            super(appView.options().getProguardConfiguration().getObfuscationDictionary(), false);
            this.appView = appView;
            this.factory = appView.dexItemFactory();
            this.desugaredLibraryRenaming = appView.typeRewriter.isRewriting();
        }

        private DexString getNextName(InternalNamingState internalState) {
            return this.factory.createString(this.nextName(StringUtils.EMPTY_CHAR_ARRAY, internalState));
        }

        @Override
        public DexString next(DexEncodedMethod method, InternalNamingState internalState, BiPredicate<DexString, DexMethod> isAvailable) {
            DexString candidate;
            assert (this.checkAllowMemberRenaming(method.getHolderType()));
            while (!isAvailable.test(candidate = this.getNextName(internalState), (DexMethod)method.getReference())) {
            }
            return candidate;
        }

        @Override
        public DexString next(ProgramField field, InternalNamingState internalState, BiPredicate<DexString, ProgramField> isAvailable) {
            DexString candidate;
            assert (this.checkAllowMemberRenaming(field.getHolderType()));
            while (!isAvailable.test(candidate = this.getNextName(internalState), field)) {
            }
            return candidate;
        }

        @Override
        public DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            if (!this.allowMemberRenaming(holder) || holder.accessFlags.isAnnotation() || method.accessFlags.isConstructor() || !this.appView.appInfo().isMinificationAllowed(method.getReference())) {
                return ((DexMethod)method.getReference()).name;
            }
            if (this.desugaredLibraryRenaming && method.isLibraryMethodOverride().isTrue() && this.appView.typeRewriter.hasRewrittenTypeInSignature(((DexMethod)method.getReference()).proto, this.appView)) {
                return ((DexMethod)method.getReference()).name;
            }
            return null;
        }

        @Override
        public DexString getReservedName(DexEncodedField field, DexClass holder) {
            if (holder.isLibraryClass() || !this.appView.appInfo().isMinificationAllowed(field.getReference())) {
                return ((DexField)field.getReference()).name;
            }
            return null;
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return holder.isProgramClass();
        }

        public boolean checkAllowMemberRenaming(DexType holder) {
            DexClass clazz = this.appView.definitionFor(holder);
            assert (clazz != null && this.allowMemberRenaming(clazz));
            return true;
        }
    }

    public static class MinificationPackageNamingStrategy
    extends BaseMinificationNamingStrategy {
        private final InternalNamingState namingState = new InternalNamingState(){
            private int dictionaryIndex = 0;
            private int nameIndex = 1;

            @Override
            public int getDictionaryIndex() {
                return this.dictionaryIndex;
            }

            @Override
            public int incrementDictionaryIndex() {
                return this.dictionaryIndex++;
            }

            @Override
            public int incrementNameIndex() {
                return this.nameIndex++;
            }
        };

        public MinificationPackageNamingStrategy(AppView<?> appView) {
            super(appView.options().getProguardConfiguration().getPackageObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
        }

        public String next(String packagePrefix, Predicate<String> isUsed) {
            String nextPackageName;
            while (isUsed.test(nextPackageName = this.nextName(packagePrefix.toCharArray(), this.namingState))) {
            }
            return nextPackageName;
        }
    }

    static class MinificationClassNamingStrategy
    extends BaseMinificationNamingStrategy
    implements ClassNameMinifier.ClassNamingStrategy {
        final AppView<AppInfoWithLiveness> appView;
        final DexItemFactory factory;

        MinificationClassNamingStrategy(AppView<AppInfoWithLiveness> appView) {
            super(appView.options().getProguardConfiguration().getClassObfuscationDictionary(), appView.options().getProguardConfiguration().hasDontUseMixedCaseClassnames());
            this.appView = appView;
            this.factory = appView.dexItemFactory();
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state, Predicate<String> isUsed) {
            String candidate = null;
            String lastName = null;
            do {
                String newName;
                if ((newName = this.nextName(packagePrefix, state) + ";").equals(lastName)) {
                    throw new CompilationError("Generating same name '" + newName + "' when given a new minified name to '" + type.toString() + "'.");
                }
                lastName = newName;
                if (newName.endsWith("LR;") || newName.endsWith("/R;")) continue;
                candidate = newName;
            } while (candidate == null || isUsed.test(candidate));
            return this.factory.createString(candidate);
        }

        @Override
        public DexString reservedDescriptor(DexType type) {
            if (!this.appView.appInfo().isMinificationAllowed(type)) {
                return type.descriptor;
            }
            return null;
        }

        @Override
        public boolean isRenamedByApplyMapping(DexType type) {
            return false;
        }
    }

    static abstract class BaseMinificationNamingStrategy {
        private final List<String> obfuscationDictionary;
        private final Set<String> obfuscationDictionaryForLookup;
        private final SymbolGenerationUtils.MixedCasing mixedCasing;

        BaseMinificationNamingStrategy(List<String> obfuscationDictionary, boolean dontUseMixedCasing) {
            assert (obfuscationDictionary != null);
            this.obfuscationDictionary = obfuscationDictionary;
            this.obfuscationDictionaryForLookup = new HashSet<String>(obfuscationDictionary);
            this.mixedCasing = dontUseMixedCasing ? SymbolGenerationUtils.MixedCasing.DONT_USE_MIXED_CASE : SymbolGenerationUtils.MixedCasing.USE_MIXED_CASE;
        }

        String nextName(char[] packagePrefix, InternalNamingState state) {
            String nextString;
            StringBuilder nextName = new StringBuilder();
            nextName.append(packagePrefix);
            do {
                if (state.getDictionaryIndex() < this.obfuscationDictionary.size()) {
                    nextString = this.obfuscationDictionary.get(state.incrementDictionaryIndex());
                    continue;
                }
                while (this.obfuscationDictionaryForLookup.contains(nextString = SymbolGenerationUtils.numberToIdentifier(state.incrementNameIndex(), this.mixedCasing))) {
                }
            } while (SymbolGenerationUtils.RESERVED_NAMES.contains(nextString));
            nextName.append(nextString);
            return nextName.toString();
        }
    }
}

