/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinition;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMember;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramOrClasspathClass;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.naming.ApplyMappingError;
import com.android.tools.r8.naming.ClassNameMinifier;
import com.android.tools.r8.naming.ClassNamingForMapApplier;
import com.android.tools.r8.naming.FieldNameMinifier;
import com.android.tools.r8.naming.IdentifierMinifier;
import com.android.tools.r8.naming.InternalNamingState;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.MethodNameMinifier;
import com.android.tools.r8.naming.MinifiedRenaming;
import com.android.tools.r8.naming.Minifier;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.SeedMapper;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class ProguardMapMinifier {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory factory;
    private final SeedMapper seedMapper;
    private final BiMap<DexType, DexString> mappedNames = HashBiMap.create();
    private final Set<ProgramOrClasspathClass> mappedClasses = Sets.newIdentityHashSet();
    private final Map<DexReference, MemberNaming> memberNames = Maps.newIdentityHashMap();
    private final Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames = Maps.newIdentityHashMap();
    private final Map<DexMethod, DexString> additionalMethodNamings = Maps.newIdentityHashMap();
    private final Map<DexField, DexString> additionalFieldNamings = Maps.newIdentityHashMap();

    public ProguardMapMinifier(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.seedMapper = appView.getApplyMappingSeedMapper();
        assert (this.seedMapper != null);
    }

    private void computeMapping(DexType type, Deque<Map<DexReference, MemberNaming>> buildUpNames, Set<DexReference> notMappedReferences, SubtypingInfo subtypingInfo) {
        ClassNamingForMapApplier classNaming = this.seedMapper.getClassNaming(type);
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz != null) {
            if (clazz.isClasspathClass() && classNaming != null) {
                this.mappedClasses.add(clazz.asClasspathClass());
            } else if (clazz.isProgramClass()) {
                this.mappedClasses.add(clazz.asProgramClass());
            }
        }
        IdentityHashMap<DexReference, MemberNaming> nonPrivateMembers = new IdentityHashMap<DexReference, MemberNaming>();
        if (!(classNaming == null || clazz != null && clazz.isLibraryClass())) {
            DexString mappedName = this.factory.createString(classNaming.renamedName);
            this.checkAndAddMappedNames(type, mappedName, classNaming.position);
            classNaming.forAllMemberNaming(memberNaming -> this.addMemberNamings(type, (MemberNaming)memberNaming, (Map<DexReference, MemberNaming>)nonPrivateMembers, false));
        } else if (clazz == null || !this.appView.options().isMinifying()) {
            notMappedReferences.add(type);
        } else if (this.appView.options().isMinifying() && !this.appView.appInfo().isMinificationAllowed(type)) {
            notMappedReferences.add(type);
        }
        for (Map<DexReference, MemberNaming> parentMembers : buildUpNames) {
            for (DexReference key : parentMembers.keySet()) {
                DexMember parentReferenceOnCurrentType;
                DexMember parentReference;
                if (key.isDexMethod()) {
                    parentReference = key.asDexMethod();
                    parentReferenceOnCurrentType = this.factory.createMethod(type, parentReference.proto, parentReference.name);
                    if (!this.memberNames.containsKey(parentReferenceOnCurrentType)) {
                        this.addMemberNaming(parentReferenceOnCurrentType, parentMembers.get(key), this.additionalMethodNamings);
                        continue;
                    }
                    if (clazz == null) continue;
                    DexEncodedMethod method = clazz.lookupMethod((DexMethod)parentReferenceOnCurrentType);
                    assert (method == null || method.isStatic() || this.memberNames.get(parentReferenceOnCurrentType).getRenamedName().equals(parentMembers.get(key).getRenamedName()));
                    continue;
                }
                parentReference = key.asDexField();
                parentReferenceOnCurrentType = this.factory.createField(type, ((DexField)parentReference).type, ((DexField)parentReference).name);
                if (this.memberNames.containsKey(parentReferenceOnCurrentType)) continue;
                this.addMemberNaming(parentReferenceOnCurrentType, parentMembers.get(key), this.additionalFieldNamings);
            }
        }
        if (clazz != null && (clazz.isProgramClass() || clazz.isAbstract())) {
            this.addNonPrivateInterfaceMappings(type, nonPrivateMembers, clazz.interfaces.values);
        }
        if (nonPrivateMembers.size() > 0) {
            buildUpNames.addLast(nonPrivateMembers);
            subtypingInfo.forAllImmediateExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames, notMappedReferences, subtypingInfo));
            buildUpNames.removeLast();
        } else {
            subtypingInfo.forAllImmediateExtendsSubtypes(type, subType -> this.computeMapping((DexType)subType, buildUpNames, notMappedReferences, subtypingInfo));
        }
    }

    private void addNonPrivateInterfaceMappings(DexType type, Map<DexReference, MemberNaming> nonPrivateMembers, DexType[] interfaces) {
        for (DexType iface : interfaces) {
            DexClass ifaceClass;
            ClassNamingForMapApplier interfaceNaming = this.seedMapper.getClassNaming(iface);
            if (interfaceNaming != null) {
                interfaceNaming.forAllMemberNaming(memberNaming -> this.addMemberNamings(type, (MemberNaming)memberNaming, nonPrivateMembers, true));
            }
            if ((ifaceClass = this.appView.definitionFor(iface)) == null) continue;
            this.addNonPrivateInterfaceMappings(type, nonPrivateMembers, ifaceClass.interfaces.values);
        }
    }

    private void addMemberNamings(DexType type, MemberNaming memberNaming, Map<DexReference, MemberNaming> nonPrivateMembers, boolean addToAdditionalMaps) {
        MemberNaming.Signature signature = memberNaming.getOriginalSignature();
        assert (!signature.isQualified());
        if (signature instanceof MemberNaming.MethodSignature) {
            DexMethod originalMethod = ((MemberNaming.MethodSignature)signature).toDexMethod(this.factory, type);
            this.addMemberNaming(originalMethod, memberNaming, addToAdditionalMaps ? this.additionalMethodNamings : null);
            DexClass holder = this.appView.definitionForHolder(originalMethod);
            DexEncodedMethod definition = originalMethod.lookupOnClass(holder);
            if (definition == null || !definition.accessFlags.isPrivate()) {
                nonPrivateMembers.put(originalMethod, memberNaming);
            }
        } else {
            DexField originalField = ((MemberNaming.FieldSignature)signature).toDexField(this.factory, type);
            this.addMemberNaming(originalField, memberNaming, addToAdditionalMaps ? this.additionalFieldNamings : null);
            DexClass holder = this.appView.definitionForHolder(originalField);
            DexEncodedField field = originalField.lookupOnClass(holder);
            if (field == null || !field.isPrivate()) {
                nonPrivateMembers.put(originalField, memberNaming);
            }
        }
    }

    private <T extends DexReference> void addMemberNaming(T member, MemberNaming memberNaming, Map<T, DexString> additionalMemberNamings) {
        assert (!this.memberNames.containsKey(member) || this.memberNames.get(member).getRenamedName().equals(memberNaming.getRenamedName()));
        this.memberNames.put(member, memberNaming);
        if (additionalMemberNamings != null) {
            DexString renamedName = this.factory.createString(memberNaming.getRenamedName());
            additionalMemberNamings.put(member, renamedName);
        }
    }

    private void checkAndAddMappedNames(DexType type, DexString mappedName, Position position) {
        if (this.mappedNames.inverse().containsKey(mappedName) && this.mappedNames.inverse().get(mappedName) != type) {
            this.appView.options().reporter.error(ApplyMappingError.mapToExistingClass(type.toString(), mappedName.toString(), position));
        } else {
            this.mappedNames.put(type, mappedName);
        }
    }

    private void computeDefaultInterfaceMethodMethods() {
        for (String key : this.seedMapper.getKeyset()) {
            DexClass dexClass;
            ClassNamingForMapApplier classNaming = this.seedMapper.getMapping(key);
            DexType type = this.factory.lookupType(this.factory.createString(key));
            if (type == null || (dexClass = this.appView.appInfo().definitionForWithoutExistenceAssert(type)) != null && !dexClass.isClasspathClass()) continue;
            this.computeDefaultInterfaceMethodMappingsForType(type, classNaming, this.defaultInterfaceMethodImplementationNames);
        }
    }

    private void computeDefaultInterfaceMethodMappingsForType(DexType type, ClassNamingForMapApplier classNaming, Map<DexMethod, DexString> defaultInterfaceMethodImplementationNames) {
        if (!InterfaceDesugaringSyntheticHelper.isCompanionClassType(type)) {
            return;
        }
        DexClass interfaceType = this.appView.definitionFor(InterfaceDesugaringSyntheticHelper.getInterfaceClassType(type, this.factory));
        if (interfaceType == null || !interfaceType.isClasspathClass()) {
            return;
        }
        for (List namings : classNaming.getQualifiedMethodMembers().values()) {
            if (namings.size() != 1) continue;
            MemberNaming naming = (MemberNaming)namings.get(0);
            MemberNaming.MethodSignature signature = (MemberNaming.MethodSignature)naming.getOriginalSignature();
            if (!signature.name.startsWith(interfaceType.type.toSourceString())) continue;
            DexMethod defaultMethod = InterfaceDesugaringSyntheticHelper.defaultAsMethodOfCompanionClass(signature.toUnqualified().toDexMethod(this.factory, interfaceType.type), this.factory);
            assert (defaultMethod.holder == type);
            defaultInterfaceMethodImplementationNames.put(defaultMethod, this.factory.createString(naming.getRenamedName()));
        }
    }

    public NamingLens run(ExecutorService executorService, Timing timing) throws ExecutionException {
        ArrayDeque nonPrivateMembers = new ArrayDeque();
        HashSet<DexReference> notMappedReferences = new HashSet<DexReference>();
        timing.begin("MappingInterfaces");
        Set<DexProgramClass> classesToBuildSubtypeInformationFor = SetUtils.newIdentityHashSet(this.appView.app().classes());
        this.appView.appInfo().getObjectAllocationInfoCollection().forEachInstantiatedLambdaInterfaces(type -> {
            DexClass lambdaInterface = this.appView.contextIndependentDefinitionFor((DexType)type);
            if (lambdaInterface != null) {
                classesToBuildSubtypeInformationFor.add((DexProgramClass)lambdaInterface);
            }
        });
        this.appView.appInfo().forEachReferencedClasspathClass(classesToBuildSubtypeInformationFor::add);
        SubtypingInfo subtypingInfo = SubtypingInfo.create(classesToBuildSubtypeInformationFor, this.appView);
        timing.begin("MappingInterfaces");
        TreeSet<DexClass> interfaces = new TreeSet<DexClass>(Comparator.comparing(DexClass::getType));
        subtypingInfo.forAllInterfaceRoots(iFace -> {
            DexClass iFaceDefinition = this.appView.definitionFor((DexType)iFace);
            if (iFaceDefinition != null) {
                interfaces.add(iFaceDefinition);
                this.computeMapping((DexType)iFace, nonPrivateMembers, (Set<DexReference>)notMappedReferences, subtypingInfo);
            }
        });
        assert (nonPrivateMembers.isEmpty());
        timing.end();
        timing.begin("MappingClasses");
        subtypingInfo.forAllImmediateExtendsSubtypes(this.factory.objectType, subType -> {
            DexClass dexClass = this.appView.definitionFor((DexType)subType);
            if (dexClass != null && !dexClass.isInterface()) {
                this.computeMapping((DexType)subType, nonPrivateMembers, (Set<DexReference>)notMappedReferences, subtypingInfo);
            }
        });
        assert (nonPrivateMembers.isEmpty());
        timing.end();
        timing.begin("MappingDefaultInterfaceMethods");
        this.computeDefaultInterfaceMethodMethods();
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        timing.begin("MinifyClasses");
        ClassNameMinifier classNameMinifier = new ClassNameMinifier(this.appView, new ApplyMappingClassNamingStrategy(this.appView, this.mappedNames, this.seedMapper.getMappedToDescriptorNames()), DexApplication.classesWithDeterministicOrder(this.mappedClasses));
        ClassNameMinifier.ClassRenaming classRenaming = classNameMinifier.computeRenaming(timing);
        timing.end();
        ApplyMappingMemberNamingStrategy nameStrategy = new ApplyMappingMemberNamingStrategy(this.appView, this.memberNames);
        timing.begin("MinifyMethods");
        MethodNameMinifier.MethodRenaming methodRenaming = new MethodNameMinifier(this.appView, nameStrategy).computeRenaming(interfaces, subtypingInfo, executorService, timing);
        methodRenaming.renaming.putAll(this.defaultInterfaceMethodImplementationNames);
        methodRenaming.renaming.putAll(this.additionalMethodNamings);
        timing.end();
        timing.begin("MinifyFields");
        FieldNameMinifier.FieldRenaming fieldRenaming = new FieldNameMinifier(this.appView, subtypingInfo, nameStrategy).computeRenaming(interfaces, timing);
        fieldRenaming.renaming.putAll(this.additionalFieldNamings);
        timing.end();
        this.appView.options().reporter.failIfPendingErrors();
        ProguardMapMinifiedRenaming lens = new ProguardMapMinifiedRenaming(this.appView, classRenaming, methodRenaming, fieldRenaming, notMappedReferences);
        timing.begin("MinifyIdentifiers");
        new IdentifierMinifier(this.appView, lens).run(executorService);
        timing.end();
        return lens;
    }

    public static class ProguardMapMinifiedRenaming
    extends MinifiedRenaming {
        private final Set<DexReference> unmappedReferences;
        private final Map<DexString, DexType> classRenamingsMappingToDifferentName;

        ProguardMapMinifiedRenaming(AppView<? extends AppInfoWithClassHierarchy> appView, ClassNameMinifier.ClassRenaming classRenaming, MethodNameMinifier.MethodRenaming methodRenaming, FieldNameMinifier.FieldRenaming fieldRenaming, Set<DexReference> unmappedReferences) {
            super(appView, classRenaming, methodRenaming, fieldRenaming);
            this.unmappedReferences = unmappedReferences;
            this.classRenamingsMappingToDifferentName = new HashMap<DexString, DexType>();
            classRenaming.classRenaming.forEach((type, dexString) -> {
                if (type.descriptor != dexString) {
                    this.classRenamingsMappingToDifferentName.put((DexString)dexString, (DexType)type);
                }
            });
        }

        private void checkForUseOfNotMappedReference(DexType type) {
            if (this.unmappedReferences.contains(type) && this.classRenamingsMappingToDifferentName.containsKey(type.descriptor)) {
                DexType mappedType = this.classRenamingsMappingToDifferentName.get(type.descriptor);
                this.appView.options().reporter.error(ApplyMappingError.mapToExistingClass(mappedType.toString(), type.toSourceString(), Position.UNKNOWN));
                this.unmappedReferences.remove(type);
            }
        }

        @Override
        protected DexString internalLookupClassDescriptor(DexType type) {
            this.checkForUseOfNotMappedReference(type);
            return super.internalLookupClassDescriptor(type);
        }
    }

    static class ApplyMappingMemberNamingStrategy
    extends Minifier.MinifierMemberNamingStrategy {
        private final Map<DexReference, MemberNaming> mappedNames;
        private final DexItemFactory factory;
        private final Reporter reporter;

        public ApplyMappingMemberNamingStrategy(AppView<AppInfoWithLiveness> appView, Map<DexReference, MemberNaming> mappedNames) {
            super(appView);
            this.mappedNames = mappedNames;
            this.factory = appView.dexItemFactory();
            this.reporter = appView.options().reporter;
        }

        private DexString getReservedName(DexDefinition definition, DexString name, DexClass holder) {
            DexString reservedName;
            assert (definition.isDexEncodedMethod() || definition.isDexEncodedField());
            DexReference reference = definition.getReference();
            if (holder.isNotProgramClass()) {
                if (this.mappedNames.containsKey(reference)) {
                    return this.factory.createString(this.mappedNames.get(reference).getRenamedName());
                }
                return name;
            }
            assert (holder.isProgramClass());
            DexString dexString = reservedName = definition.isDexEncodedMethod() ? super.getReservedName(definition.asDexEncodedMethod(), holder) : super.getReservedName(definition.asDexEncodedField(), holder);
            if (reservedName != null) {
                return reservedName;
            }
            if (this.mappedNames.containsKey(reference)) {
                return this.factory.createString(this.mappedNames.get(reference).getRenamedName());
            }
            return null;
        }

        @Override
        public DexString next(DexEncodedMethod method, InternalNamingState internalState, BiPredicate<DexString, DexMethod> isAvailable) {
            DexString nextName;
            DexMethod reference = (DexMethod)method.getReference();
            DexClass holder = this.appView.definitionForHolder(reference);
            assert (holder != null);
            DexString reservedName = this.getReservedName(method, reference.name, holder);
            if (reservedName != null) {
                if (!isAvailable.test(reservedName, reference)) {
                    this.reportReservationError(reference, reservedName);
                }
                nextName = reservedName;
            } else {
                assert (!this.mappedNames.containsKey(reference));
                assert (((AppInfoWithLiveness)this.appView.appInfo()).isMinificationAllowed(reference));
                nextName = super.next(method, internalState, isAvailable);
            }
            assert (nextName == reference.name || !method.isInitializer());
            assert (nextName == reference.name || !holder.isAnnotation());
            return nextName;
        }

        @Override
        public DexString next(ProgramField field, InternalNamingState internalState, BiPredicate<DexString, ProgramField> isAvailable) {
            DexField reference = (DexField)field.getReference();
            DexString reservedName = this.getReservedName(field.getDefinition(), reference.name, field.getHolder());
            if (reservedName != null) {
                if (!isAvailable.test(reservedName, field)) {
                    this.reportReservationError(reference, reservedName);
                }
                return reservedName;
            }
            assert (!this.mappedNames.containsKey(reference));
            assert (((AppInfoWithLiveness)this.appView.appInfo()).isMinificationAllowed(reference));
            return super.next(field, internalState, isAvailable);
        }

        @Override
        public DexString getReservedName(DexEncodedMethod method, DexClass holder) {
            return this.getReservedName(method, ((DexMethod)method.getReference()).name, holder);
        }

        @Override
        public DexString getReservedName(DexEncodedField field, DexClass holder) {
            return this.getReservedName(field, ((DexField)field.getReference()).name, holder);
        }

        @Override
        public boolean allowMemberRenaming(DexClass holder) {
            return true;
        }

        void reportReservationError(DexReference source, DexString name) {
            MemberNaming memberNaming = this.mappedNames.get(source);
            assert (source.isDexMethod() || source.isDexField());
            ApplyMappingError applyMappingError = ApplyMappingError.mapToExistingMember(source.toSourceString(), name.toString(), memberNaming == null ? Position.UNKNOWN : memberNaming.position);
        }
    }

    static class ApplyMappingClassNamingStrategy
    extends Minifier.MinificationClassNamingStrategy {
        private final Map<DexType, DexString> mappings;
        private final Set<String> mappedNames;

        ApplyMappingClassNamingStrategy(AppView<AppInfoWithLiveness> appView, Map<DexType, DexString> mappings, Set<String> mappedNames) {
            super(appView);
            this.mappings = mappings;
            this.mappedNames = mappedNames;
        }

        @Override
        public DexString next(DexType type, char[] packagePrefix, InternalNamingState state, Predicate<String> isUsed) {
            assert (!this.mappings.containsKey(type));
            assert (((AppInfoWithLiveness)this.appView.appInfo()).isMinificationAllowed(type));
            return super.next(type, packagePrefix, state, candidate -> {
                if (this.mappedNames.contains(candidate)) {
                    return true;
                }
                return isUsed.test((String)candidate);
            });
        }

        @Override
        public DexString reservedDescriptor(DexType type) {
            DexClass clazz = ((AppInfoWithLiveness)this.appView.appInfo()).definitionForWithoutExistenceAssert(type);
            if (clazz == null) {
                return type.descriptor;
            }
            if (clazz.isNotProgramClass() && this.mappings.containsKey(type)) {
                return this.mappings.get(type);
            }
            if (clazz.isProgramClass() && ((AppInfoWithLiveness)this.appView.appInfo()).isMinificationAllowed(type)) {
                return this.mappings.get(type);
            }
            return type.descriptor;
        }

        @Override
        public boolean isRenamedByApplyMapping(DexType type) {
            return this.mappings.containsKey(type);
        }
    }
}

