/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonParser;
import com.android.tools.r8.com.google.gson.JsonSyntaxException;
import com.android.tools.r8.naming.ClassNaming;
import com.android.tools.r8.naming.ClassNamingForNameMapper;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.MemberNaming;
import com.android.tools.r8.naming.ProguardMap;
import com.android.tools.r8.naming.Range;
import com.android.tools.r8.naming.mappinginformation.MapVersionMappingInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformationDiagnostics;
import com.android.tools.r8.position.TextPosition;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.IdentifierUtils;
import com.android.tools.r8.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.function.Consumer;

public class ProguardMapReader
implements AutoCloseable {
    private final BufferedReader reader;
    private final JsonParser jsonParser = new JsonParser();
    private final DiagnosticsHandler diagnosticsHandler;
    private final boolean allowEmptyMappedRanges;
    private final boolean allowExperimentalMapping;
    private int lineNo = 0;
    private int lineOffset = 0;
    private String line;
    private MapVersion version = MapVersion.MAP_VERSION_NONE;
    final HashMap<String, String> cache = new HashMap();

    ProguardMapReader(BufferedReader reader, DiagnosticsHandler diagnosticsHandler, boolean allowEmptyMappedRanges, boolean allowExperimentalMapping) {
        this.reader = reader;
        this.diagnosticsHandler = diagnosticsHandler;
        this.allowEmptyMappedRanges = allowEmptyMappedRanges;
        this.allowExperimentalMapping = allowExperimentalMapping;
        assert (reader != null);
        assert (diagnosticsHandler != null);
    }

    private int peekCodePoint() {
        return this.lineOffset < this.line.length() ? this.line.codePointAt(this.lineOffset) : 10;
    }

    private char peekChar(int distance) {
        return this.lineOffset + distance < this.line.length() ? this.line.charAt(this.lineOffset + distance) : (char)'\n';
    }

    private boolean hasNext() {
        return this.lineOffset < this.line.length();
    }

    private int nextCodePoint() {
        try {
            int cp = this.line.codePointAt(this.lineOffset);
            this.lineOffset += Character.charCount(cp);
            return cp;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private char nextChar() {
        assert (this.hasNext());
        try {
            return this.line.charAt(this.lineOffset++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Unexpected end of line");
        }
    }

    private boolean nextLine() throws IOException {
        if (this.line.length() != this.lineOffset) {
            throw new ParseException("Expected end of line");
        }
        return this.skipLine();
    }

    private boolean isEmptyOrCommentLine(String line) {
        if (line == null) {
            return true;
        }
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '#') {
                return !ProguardMapReader.hasFirstCharJsonBrace(line, i);
            }
            if (StringUtils.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    private boolean isCommentLineWithJsonBrace() {
        if (this.line == null) {
            return false;
        }
        for (int i = 0; i < this.line.length(); ++i) {
            char c = this.line.charAt(i);
            if (c == '#') {
                return ProguardMapReader.hasFirstCharJsonBrace(this.line, i);
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    private static boolean hasFirstCharJsonBrace(String line, int commentCharIndex) {
        for (int i = commentCharIndex + 1; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '{') {
                return true;
            }
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return false;
    }

    private boolean skipLine() throws IOException {
        this.lineOffset = 0;
        do {
            ++this.lineNo;
            this.line = this.reader.readLine();
        } while (this.hasLine() && this.isEmptyOrCommentLine(this.line));
        return this.hasLine();
    }

    private boolean hasLine() {
        return this.line != null;
    }

    private void skipWhitespace() {
        while (this.hasNext() && StringUtils.isWhitespace(this.peekCodePoint())) {
            this.nextCodePoint();
        }
    }

    private void expectWhitespace() {
        boolean seen = false;
        while (this.hasNext() && StringUtils.isWhitespace(this.peekCodePoint())) {
            seen = seen || !StringUtils.isBOM(this.peekCodePoint());
            this.nextCodePoint();
        }
        if (!seen) {
            throw new ParseException("Expected whitespace", true);
        }
    }

    private void expect(char c) {
        if (!this.hasNext()) {
            throw new ParseException("Expected '" + c + "'", true);
        }
        if (this.nextChar() != c) {
            throw new ParseException("Expected '" + c + "'");
        }
    }

    private void parseClassMappings(ProguardMap.Builder mapBuilder) throws IOException {
        while (this.hasLine()) {
            this.skipWhitespace();
            if (this.isCommentLineWithJsonBrace()) {
                this.parseMappingInformation(info -> {
                    assert (info.isMapVersionMappingInformation() || info.isUnknownJsonMappingInformation());
                    if (info.isMapVersionMappingInformation()) {
                        mapBuilder.setCurrentMapVersion(info.asMapVersionMappingInformation());
                    }
                });
                this.lineOffset = this.line.length();
                this.nextLine();
                continue;
            }
            String before = this.parseType(false);
            this.skipWhitespace();
            assert (IdentifierUtils.isDexIdentifierPart(45));
            if (before.endsWith("-") && this.acceptString(">")) {
                before = before.substring(0, before.length() - 1);
            } else {
                this.skipWhitespace();
                this.acceptArrow();
            }
            this.skipWhitespace();
            String after = this.parseType(false);
            this.skipWhitespace();
            this.expect(':');
            ClassNaming.Builder currentClassBuilder = mapBuilder.classNamingBuilder(after, before, this.getPosition());
            this.skipWhitespace();
            if (!this.nextLine()) continue;
            this.parseMemberMappings(currentClassBuilder);
        }
    }

    private void parseMappingInformation(Consumer<MappingInformation> onMappingInfo) {
        MappingInformation.fromJsonObject(this.version, this.parseJsonInComment(), this.diagnosticsHandler, this.lineNo, info -> {
            MapVersionMappingInformation generatorInfo = info.asMapVersionMappingInformation();
            if (generatorInfo != null) {
                this.version = generatorInfo.getMapVersion().equals(MapVersion.MAP_VERSION_EXPERIMENTAL) ? (this.allowExperimentalMapping ? MapVersion.MAP_VERSION_EXPERIMENTAL : MapVersion.MAP_VERSION_NONE) : generatorInfo.getMapVersion();
            }
            onMappingInfo.accept((MappingInformation)info);
        });
    }

    private void parseMemberMappings(ClassNaming.Builder classNamingBuilder) throws IOException {
        MemberNaming lastAddedNaming = null;
        MemberNaming activeMemberNaming = null;
        ClassNamingForNameMapper.MappedRange activeMappedRange = null;
        Range previousMappedRange = null;
        do {
            Range originalRange = null;
            if (this.isCommentLineWithJsonBrace()) {
                MemberNaming currentMember = activeMemberNaming;
                ClassNamingForNameMapper.MappedRange currentRange = activeMappedRange;
                BooleanBox readGlobalInfo = new BooleanBox(false);
                this.parseMappingInformation(info -> {
                    readGlobalInfo.set(info.isGlobalMappingInformation());
                    if (currentMember == null) {
                        classNamingBuilder.addMappingInformation((MappingInformation)info, conflictingInfo -> this.diagnosticsHandler.warning(MappingInformationDiagnostics.notAllowedCombination(info, conflictingInfo, this.lineNo)));
                    } else if (currentRange != null) {
                        currentRange.addMappingInformation((MappingInformation)info, conflictingInfo -> this.diagnosticsHandler.warning(MappingInformationDiagnostics.notAllowedCombination(info, conflictingInfo, this.lineNo)));
                    }
                });
                if (readGlobalInfo.isTrue()) break;
                this.lineOffset = this.line.length();
                continue;
            }
            if (!StringUtils.isWhitespace(this.peekCodePoint())) break;
            this.skipWhitespace();
            Range mappedRange = this.parseRange();
            if (mappedRange != null) {
                if (mappedRange.isCardinal) {
                    throw new ParseException(String.format("Invalid obfuscated line number range (%s).", mappedRange));
                }
                this.skipWhitespace();
                this.expect(':');
            }
            this.skipWhitespace();
            MemberNaming.Signature signature = this.parseSignature();
            this.skipWhitespace();
            if (this.peekChar(0) == ':') {
                this.nextChar();
                this.skipWhitespace();
                originalRange = this.parseRange();
                if (originalRange == null) {
                    throw new ParseException("No number follows the colon after the method signature.");
                }
            }
            if (!this.allowEmptyMappedRanges && mappedRange == null && originalRange != null) {
                throw new ParseException("No mapping for original range " + originalRange + ".");
            }
            this.skipWhitespace();
            this.skipArrow();
            this.skipWhitespace();
            String renamedName = this.parseMethodName();
            if (signature instanceof MemberNaming.MethodSignature) {
                activeMappedRange = classNamingBuilder.addMappedRange(mappedRange, (MemberNaming.MethodSignature)signature, originalRange, renamedName);
            }
            assert (mappedRange == null || signature instanceof MemberNaming.MethodSignature);
            if (activeMemberNaming != null) {
                boolean originalRangeChange;
                boolean changedName = !activeMemberNaming.getRenamedName().equals(renamedName);
                boolean changedMappedRange = !Objects.equals(previousMappedRange, mappedRange);
                boolean bl = originalRangeChange = originalRange == null || !originalRange.isCardinal;
                if ((changedName || previousMappedRange == null || changedMappedRange || originalRangeChange) && (lastAddedNaming == null || !lastAddedNaming.getOriginalSignature().equals(activeMemberNaming.signature))) {
                    classNamingBuilder.addMemberEntry(activeMemberNaming);
                    lastAddedNaming = activeMemberNaming;
                }
            }
            activeMemberNaming = new MemberNaming(signature, signature.asRenamed(renamedName), this.getPosition());
            previousMappedRange = mappedRange;
        } while (this.nextLine());
        if (activeMemberNaming != null) {
            boolean notAdded;
            boolean bl = notAdded = lastAddedNaming == null || !lastAddedNaming.getOriginalSignature().equals(activeMemberNaming.signature);
            if (previousMappedRange == null || notAdded) {
                classNamingBuilder.addMemberEntry(activeMemberNaming);
            }
        }
    }

    private TextPosition getPosition() {
        return new TextPosition(0L, this.lineNo, 1);
    }

    private void skipIdentifier(boolean allowInit) {
        boolean isInit = false;
        if (allowInit && this.peekChar(0) == '<') {
            this.nextChar();
            isInit = true;
        }
        if (!IdentifierUtils.isDexIdentifierStart(this.peekCodePoint()) && !IdentifierUtils.isQuestionMark(this.peekCodePoint())) {
            throw new ParseException("Identifier expected");
        }
        this.nextCodePoint();
        while (IdentifierUtils.isDexIdentifierPart(this.peekCodePoint()) || IdentifierUtils.isQuestionMark(this.peekCodePoint())) {
            this.nextCodePoint();
        }
        if (isInit) {
            this.expect('>');
        }
        if (IdentifierUtils.isDexIdentifierPart(this.peekCodePoint())) {
            throw new ParseException("End of identifier expected (was 0x" + Integer.toHexString(this.peekCodePoint()) + ")");
        }
    }

    private String substring(int start) {
        String result = this.line.substring(start, this.lineOffset);
        if (this.cache.containsKey(result)) {
            return this.cache.get(result);
        }
        this.cache.put(result, result);
        return result;
    }

    private String parseMethodName() {
        int startPosition = this.lineOffset;
        this.skipIdentifier(true);
        while (this.peekChar(0) == '.') {
            this.nextChar();
            this.skipIdentifier(true);
        }
        return this.substring(startPosition);
    }

    private String parseType(boolean allowArray) {
        int startPosition = this.lineOffset;
        this.skipIdentifier(false);
        while (this.peekChar(0) == '.') {
            this.nextChar();
            this.skipIdentifier(false);
        }
        if (allowArray) {
            while (this.peekChar(0) == '[') {
                this.nextChar();
                this.expect(']');
            }
        }
        return this.substring(startPosition);
    }

    private MemberNaming.Signature parseSignature() {
        MemberNaming.Signature signature;
        String type = this.parseType(true);
        this.expectWhitespace();
        String name = this.parseMethodName();
        this.skipWhitespace();
        if (this.peekChar(0) == '(') {
            String[] arguments;
            this.nextChar();
            this.skipWhitespace();
            if (this.peekChar(0) == ')') {
                arguments = new String[]{};
            } else {
                LinkedList<String> items = new LinkedList<String>();
                items.add(this.parseType(true));
                this.skipWhitespace();
                while (this.peekChar(0) != ')') {
                    this.skipWhitespace();
                    this.expect(',');
                    this.skipWhitespace();
                    items.add(this.parseType(true));
                }
                arguments = items.toArray(StringUtils.EMPTY_ARRAY);
            }
            this.expect(')');
            signature = new MemberNaming.MethodSignature(name, type, arguments);
        } else {
            signature = new MemberNaming.FieldSignature(name, type);
        }
        return signature;
    }

    private void skipArrow() {
        this.expect('-');
        this.expect('>');
    }

    private boolean acceptArrow() {
        if (this.peekChar(0) == '-' && this.peekChar(1) == '>') {
            this.nextChar();
            this.nextChar();
            return true;
        }
        return false;
    }

    private boolean acceptString(String s2) {
        int i;
        for (i = 0; i < s2.length(); ++i) {
            if (this.peekChar(i) == s2.charAt(i)) continue;
            return false;
        }
        for (i = 0; i < s2.length(); ++i) {
            this.nextChar();
        }
        return true;
    }

    private boolean isSimpleDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private Range parseRange() {
        if (!this.isSimpleDigit(this.peekChar(0))) {
            return null;
        }
        int from = this.parseNumber();
        this.skipWhitespace();
        if (this.peekChar(0) != ':') {
            return new Range(from);
        }
        this.expect(':');
        this.skipWhitespace();
        int to = this.parseNumber();
        return new Range(from, to);
    }

    private int parseNumber() {
        int result = 0;
        if (!this.isSimpleDigit(this.peekChar(0))) {
            throw new ParseException("Number expected");
        }
        do {
            result *= 10;
            result += Character.getNumericValue(this.nextChar());
        } while (this.isSimpleDigit(this.peekChar(0)));
        return result;
    }

    private JsonObject parseJsonInComment() {
        assert (this.isCommentLineWithJsonBrace());
        try {
            int firstIndex = 0;
            while (this.line.charAt(firstIndex) != '{') {
                ++firstIndex;
            }
            return this.jsonParser.parse(this.line.substring(firstIndex)).getAsJsonObject();
        }
        catch (JsonSyntaxException ex) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    void parse(ProguardMap.Builder mapBuilder) throws IOException {
        do {
            this.line = this.reader.readLine();
            ++this.lineNo;
        } while (this.hasLine() && this.isEmptyOrCommentLine(this.line));
        this.parseClassMappings(mapBuilder);
    }

    public class ParseException
    extends RuntimeException {
        private final int lineNo;
        private final int lineOffset;
        private final boolean eol;
        private final String msg;

        ParseException(String msg) {
            this(msg, false);
        }

        ParseException(String msg, boolean eol) {
            this.lineNo = ProguardMapReader.this.lineNo;
            this.lineOffset = ProguardMapReader.this.lineOffset;
            this.eol = eol;
            this.msg = msg;
        }

        @Override
        public String toString() {
            if (this.eol) {
                return "Parse error [" + this.lineNo + ":eol] " + this.msg;
            }
            return "Parse error [" + this.lineNo + ":" + this.lineOffset + "] " + this.msg;
        }
    }
}

