/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import java.util.Objects;

public class Range {
    public final int from;
    public final int to;
    public final boolean isCardinal;

    public Range(int line) {
        this(line, line, true);
    }

    public Range(int from, int to) {
        this(from, to, false);
    }

    private Range(int from, int to, boolean isCardinal) {
        this.from = from;
        this.to = to;
        this.isCardinal = isCardinal;
        assert (from <= to);
    }

    public boolean contains(int value) {
        return this.from <= value && value <= this.to;
    }

    public String toString() {
        return this.isCardinal ? this.from + "" : this.from + ":" + this.to;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range range = (Range)o;
        return this.from == range.from && this.to == range.to && this.isCardinal == range.isCardinal;
    }

    public int span() {
        if (this.isCardinal) {
            return 1;
        }
        return this.to - this.from + 1;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.isCardinal);
    }
}

