/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming;

import com.android.tools.r8.SourceFileEnvironment;
import com.android.tools.r8.SourceFileProvider;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.shaking.ProguardConfiguration;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Objects;

public class SourceFileRewriter {
    public static SourceFileProvider computeSourceFileProvider(SourceFileProvider provider, ProguardConfiguration configuration, InternalOptions options) {
        if (provider != null) {
            return provider;
        }
        if (!configuration.getKeepAttributes().sourceFile) {
            return SourceFileRewriter.rewriteToDefaultSourceFile(options.dexItemFactory());
        }
        if (options.forceProguardCompatibility) {
            return SourceFileRewriter.computeCompatProvider(options);
        }
        return SourceFileRewriter.computeNonCompatProvider(options);
    }

    private static SourceFileProvider computeCompatProvider(InternalOptions options) {
        String renaming;
        if (options.isMinifying() && (renaming = SourceFileRewriter.getRenameSourceFileAttribute(options)) != null) {
            return SourceFileRewriter.rewriteTo(renaming, SourceFileRewriter.isDefaultOrEmpty(renaming, options));
        }
        return null;
    }

    private static SourceFileProvider computeNonCompatProvider(InternalOptions options) {
        String renaming = SourceFileRewriter.getRenameSourceFileAttribute(options);
        if (renaming != null) {
            return SourceFileRewriter.rewriteTo(renaming, SourceFileRewriter.isDefaultOrEmpty(renaming, options));
        }
        if (options.isMinifying() || options.isOptimizing()) {
            return SourceFileRewriter.rewriteToDefaultSourceFile(options.dexItemFactory());
        }
        return null;
    }

    private static String getRenameSourceFileAttribute(InternalOptions options) {
        return options.getProguardConfiguration().getRenameSourceFileAttribute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDefaultOrEmpty(String sourceFile, InternalOptions options) {
        if (sourceFile.isEmpty()) return true;
        Objects.requireNonNull(options.dexItemFactory());
        if (!"SourceFile".equals(sourceFile)) return false;
        return true;
    }

    private static SourceFileProvider rewriteToDefaultSourceFile(DexItemFactory factory) {
        Objects.requireNonNull(factory);
        return SourceFileRewriter.rewriteTo("SourceFile", true);
    }

    private static SourceFileProvider rewriteTo(final String renaming, final boolean allowDiscard) {
        return new SourceFileProvider(){

            @Override
            public String get(SourceFileEnvironment environment) {
                return renaming;
            }

            @Override
            public boolean allowDiscardingSourceFile() {
                return allowDiscard;
            }
        };
    }
}

