/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonPrimitive;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import java.util.function.Consumer;

public class CompilerSynthesizedMappingInformation
extends MappingInformation {
    public static final MapVersion SUPPORTED_VERSION = MapVersion.MAP_VERSION_1_0;
    public static final String ID = "com.android.tools.r8.synthesized";

    public static boolean isSupported(MapVersion version) {
        return version.isGreaterThanOrEqualTo(SUPPORTED_VERSION);
    }

    private CompilerSynthesizedMappingInformation() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static void deserialize(MapVersion version, Consumer<MappingInformation> onMappingInfo) {
        if (CompilerSynthesizedMappingInformation.isSupported(version)) {
            onMappingInfo.accept(CompilerSynthesizedMappingInformation.builder().build());
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isCompilerSynthesizedMappingInformation() {
        return true;
    }

    @Override
    public CompilerSynthesizedMappingInformation asCompilerSynthesizedMappingInformation() {
        return this;
    }

    @Override
    public boolean allowOther(MappingInformation information) {
        return !information.isCompilerSynthesizedMappingInformation();
    }

    @Override
    public String serialize() {
        JsonObject object = new JsonObject();
        object.add("id", new JsonPrimitive(ID));
        return object.toString();
    }

    public static class Builder {
        public CompilerSynthesizedMappingInformation build() {
            return new CompilerSynthesizedMappingInformation();
        }
    }
}

