/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonPrimitive;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformationDiagnostics;
import java.util.function.Consumer;

public class FileNameInformation
extends MappingInformation {
    public static final String ID = "sourceFile";
    static final String FILE_NAME_KEY = "fileName";
    private final String fileName;

    private FileNameInformation(String fileName) {
        this.fileName = fileName;
    }

    public static FileNameInformation build(String fileName) {
        return new FileNameInformation(fileName);
    }

    public static void deserialize(MapVersion version, JsonObject object, DiagnosticsHandler diagnosticsHandler, int lineNumber, Consumer<MappingInformation> onMappingInfo) {
        try {
            JsonElement fileName = FileNameInformation.getJsonElementFromObject(object, diagnosticsHandler, lineNumber, FILE_NAME_KEY, ID);
            if (fileName != null) {
                onMappingInfo.accept(new FileNameInformation(fileName.getAsString()));
            }
        }
        catch (IllegalStateException | UnsupportedOperationException ignored) {
            diagnosticsHandler.info(MappingInformationDiagnostics.invalidValueForObjectWithId(lineNumber, FILE_NAME_KEY, ID));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public boolean isFileNameInformation() {
        return true;
    }

    @Override
    public FileNameInformation asFileNameInformation() {
        return this;
    }

    @Override
    public boolean allowOther(MappingInformation information) {
        return !information.isFileNameInformation();
    }

    @Override
    public String serialize() {
        JsonObject object = new JsonObject();
        object.add("id", new JsonPrimitive(ID));
        object.add(FILE_NAME_KEY, new JsonPrimitive(this.fileName));
        return object.toString();
    }
}

