/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonPrimitive;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.naming.mappinginformation.MappingInformationDiagnostics;
import java.util.function.Consumer;

public class MapVersionMappingInformation
extends MappingInformation {
    public static final String ID = "com.android.tools.r8.mapping";
    public static final String MAP_VERSION_KEY = "version";
    private final MapVersion mapVersion;
    private final String value;

    public MapVersionMappingInformation(MapVersion mapVersion, String value) {
        this.mapVersion = mapVersion;
        this.value = value;
    }

    public static void deserialize(JsonObject object, int lineNumber, Consumer<MappingInformation> onMappingInfo) {
        String mapVersionString = object.get(MAP_VERSION_KEY).getAsString();
        if (mapVersionString == null) {
            MappingInformationDiagnostics.noKeyForObjectWithId(lineNumber, MAP_VERSION_KEY, "id", ID);
            return;
        }
        MapVersion mapVersion = MapVersion.fromName(mapVersionString);
        if (mapVersion == null) {
            mapVersion = MapVersion.MAP_VERSION_UNKNOWN;
        }
        onMappingInfo.accept(new MapVersionMappingInformation(mapVersion, mapVersionString));
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean isMapVersionMappingInformation() {
        return true;
    }

    @Override
    public MapVersionMappingInformation asMapVersionMappingInformation() {
        return this;
    }

    @Override
    public boolean allowOther(MappingInformation information) {
        return true;
    }

    public MapVersion getMapVersion() {
        return this.mapVersion;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isGlobalMappingInformation() {
        return true;
    }

    @Override
    public String serialize() {
        JsonObject result = new JsonObject();
        result.add("id", new JsonPrimitive(ID));
        result.add(MAP_VERSION_KEY, new JsonPrimitive(this.mapVersion.getName()));
        return result.toString();
    }
}

