/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.Diagnostic;
import com.android.tools.r8.Keep;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.position.TextPosition;

@Keep
public class MappingInformationDiagnostics
implements Diagnostic {
    private final String message;
    private final Position position;

    private MappingInformationDiagnostics(String message, Position position) {
        this.message = message;
        this.position = position;
    }

    static MappingInformationDiagnostics noHandlerFor(int lineNumber, String value) {
        return new MappingInformationDiagnostics(String.format("Could not find a handler for %s", value), new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics noKeyInJson(int lineNumber, String key) {
        return new MappingInformationDiagnostics(String.format("Could not locate '%s' in the JSON object", key), new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics notValidJson(int lineNumber) {
        return new MappingInformationDiagnostics("Not valid JSON", new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics notValidString(int lineNumber, String key) {
        return new MappingInformationDiagnostics(String.format("The value of '%s' is not a valid string in the JSON object", key), new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics tooManyInformationalParameters(int lineNumber) {
        return new MappingInformationDiagnostics("More informational parameters than actual parameters for method signature", new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics noKeyForObjectWithId(int lineNumber, String key, String mappingKey, String mappingValue) {
        return new MappingInformationDiagnostics(String.format("Could not find '%s' for object with %s '%s'", key, mappingKey, mappingValue), new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics invalidValueForObjectWithId(int lineNumber, String mappingKey, String mappingValue) {
        return new MappingInformationDiagnostics(String.format("Could not decode the information for the object with %s '%s'", mappingKey, mappingValue), new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics tooManyEntriesForParameterInformation(int lineNumber) {
        return new MappingInformationDiagnostics("Parameter information do not have 1 or 2 entries", new TextPosition(1L, lineNumber, -1));
    }

    static MappingInformationDiagnostics invalidParameterInformationObject(int lineNumber) {
        return new MappingInformationDiagnostics("Parameter information is not an index and a string representation of a type", new TextPosition(1L, lineNumber, -1));
    }

    public static MappingInformationDiagnostics notAllowedCombination(MappingInformation one, MappingInformation other, int lineNumber) {
        return new MappingInformationDiagnostics("The mapping '" + one + "' is not allowed in combination with '" + other + "'", new TextPosition(1L, lineNumber, -1));
    }

    @Override
    public Origin getOrigin() {
        return Origin.unknown();
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public String getDiagnosticMessage() {
        return this.message;
    }
}

