/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonPrimitive;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntSortedMap;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import java.util.function.Consumer;

public class OutlineCallsiteMappingInformation
extends MappingInformation {
    public static final MapVersion SUPPORTED_VERSION = MapVersion.MAP_VERSION_2_0;
    public static final String ID = "com.android.tools.r8.outlineCallsite";
    private static final String POSITIONS_KEY = "positions";
    private final Int2IntSortedMap positions;

    private OutlineCallsiteMappingInformation(Int2IntSortedMap positions) {
        this.positions = positions;
    }

    public static OutlineCallsiteMappingInformation create(Int2IntSortedMap positions) {
        return new OutlineCallsiteMappingInformation(positions);
    }

    public static boolean isSupported(MapVersion version) {
        return version.isGreaterThanOrEqualTo(SUPPORTED_VERSION);
    }

    public static void deserialize(MapVersion version, JsonObject object, Consumer<MappingInformation> onMappingInfo) {
        if (OutlineCallsiteMappingInformation.isSupported(version)) {
            JsonObject postionsMapObject = object.getAsJsonObject(POSITIONS_KEY);
            if (postionsMapObject == null) {
                throw new CompilationError("Expected 'positions' to be present: " + object.getAsString());
            }
            Int2IntLinkedOpenHashMap positionsMap = new Int2IntLinkedOpenHashMap();
            postionsMapObject.entrySet().forEach(entry -> {
                try {
                    String key = (String)entry.getKey();
                    int originalPosition = Integer.parseInt(key);
                    int newPosition = ((JsonElement)entry.getValue()).getAsInt();
                    positionsMap.put(originalPosition, newPosition);
                }
                catch (Throwable ex) {
                    throw new CompilationError("Invalid position entry: " + entry.toString());
                }
            });
            onMappingInfo.accept(OutlineCallsiteMappingInformation.create(positionsMap));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String serialize() {
        JsonObject result = new JsonObject();
        result.add("id", new JsonPrimitive(ID));
        JsonObject mappedPositions = new JsonObject();
        this.positions.forEach((obfuscatedPosition, originalPosition) -> mappedPositions.add(obfuscatedPosition + "", new JsonPrimitive((Number)originalPosition)));
        result.add(POSITIONS_KEY, mappedPositions);
        return result.toString();
    }

    @Override
    public boolean allowOther(MappingInformation information) {
        return !information.isOutlineCallsiteInformation();
    }

    @Override
    public boolean isOutlineCallsiteInformation() {
        return true;
    }

    @Override
    public OutlineCallsiteMappingInformation asOutlineCallsiteInformation() {
        return this;
    }

    public int rewritePosition(int originalPosition) {
        return this.positions.getOrDefault(originalPosition, originalPosition);
    }
}

