/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.naming.mappinginformation;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.gson.JsonArray;
import com.android.tools.r8.com.google.gson.JsonElement;
import com.android.tools.r8.com.google.gson.JsonObject;
import com.android.tools.r8.com.google.gson.JsonPrimitive;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2IntMap;
import com.android.tools.r8.naming.MapVersion;
import com.android.tools.r8.naming.mappinginformation.MappingInformation;
import com.android.tools.r8.references.ClassReference;
import com.android.tools.r8.references.Reference;
import com.android.tools.r8.retrace.internal.RetraceStackTraceContextImpl;
import com.android.tools.r8.retrace.internal.RetraceStackTraceCurrentEvaluationInformation;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class RewriteFrameMappingInformation
extends MappingInformation {
    public static final MapVersion SUPPORTED_VERSION = MapVersion.MAP_VERSION_2_0;
    public static final String ID = "com.android.tools.r8.rewriteFrame";
    private static final String CONDITIONS_KEY = "conditions";
    private static final String ACTIONS_KEY = "actions";
    private final List<Condition> conditions;
    private final List<RewriteAction> actions;

    private RewriteFrameMappingInformation(List<Condition> conditions, List<RewriteAction> actions) {
        this.conditions = conditions;
        this.actions = actions;
    }

    public static boolean isSupported(MapVersion version) {
        return version.isGreaterThanOrEqualTo(SUPPORTED_VERSION);
    }

    public static void deserialize(MapVersion mapVersion, JsonObject object, Consumer<MappingInformation> onMappingInfo) {
        if (!RewriteFrameMappingInformation.isSupported(mapVersion)) {
            return;
        }
        ImmutableList.Builder conditions = ImmutableList.builder();
        object.get(CONDITIONS_KEY).getAsJsonArray().forEach(element -> conditions.add(Condition.deserialize(element)));
        ImmutableList.Builder actions = ImmutableList.builder();
        object.get(ACTIONS_KEY).getAsJsonArray().forEach(element -> actions.add(RewriteAction.deserialize(element)));
        onMappingInfo.accept(new RewriteFrameMappingInformation((List<Condition>)((Object)conditions.build()), (List<RewriteAction>)((Object)actions.build())));
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public List<RewriteAction> getActions() {
        return this.actions;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String serialize() {
        JsonObject object = new JsonObject();
        object.add("id", new JsonPrimitive(ID));
        JsonArray conditionsArray = new JsonArray();
        this.conditions.forEach(condition -> conditionsArray.add(condition.serialize()));
        object.add(CONDITIONS_KEY, conditionsArray);
        JsonArray actionsArray = new JsonArray();
        this.actions.forEach(action -> actionsArray.add(action.serialize()));
        object.add(ACTIONS_KEY, actionsArray);
        return object.toString();
    }

    @Override
    public boolean allowOther(MappingInformation information) {
        return !information.isRewriteFrameMappingInformation();
    }

    @Override
    public boolean isRewriteFrameMappingInformation() {
        return true;
    }

    @Override
    public RewriteFrameMappingInformation asRewriteFrameMappingInformation() {
        return this;
    }

    public static class RewritePreviousObfuscatedPosition
    extends RewriteAction {
        private final Int2IntMap rewriteMap;

        private RewritePreviousObfuscatedPosition(Int2IntMap rewriteMap) {
            this.rewriteMap = rewriteMap;
        }

        public static RewritePreviousObfuscatedPosition create(Int2IntMap rewriteMap) {
            return new RewritePreviousObfuscatedPosition(rewriteMap);
        }

        @Override
        JsonElement serialize() {
            throw new CompilationError("Do not serialize this");
        }

        @Override
        public void evaluate(RetraceStackTraceCurrentEvaluationInformation.Builder builder) {
            builder.setPosition(this.rewriteMap.getOrDefault(builder.getPosition(), builder.getPosition()));
        }
    }

    public static class RemoveInnerFramesAction
    extends RewriteAction {
        static final String REMOVE_INNER_FRAMES_NAME = "removeInnerFrames";
        private final int numberOfFrames;

        public RemoveInnerFramesAction(int numberOfFrames) {
            this.numberOfFrames = numberOfFrames;
        }

        public static RemoveInnerFramesAction create(int numberOfFrames) {
            return new RemoveInnerFramesAction(numberOfFrames);
        }

        public static RemoveInnerFramesAction deserialize(String contents) {
            try {
                return RemoveInnerFramesAction.create(Integer.parseInt(contents));
            }
            catch (NumberFormatException nfe) {
                throw new CompilationError("Unexpected number for removeInnerFrames: " + contents);
            }
        }

        public int getNumberOfFrames() {
            return this.numberOfFrames;
        }

        @Override
        JsonElement serialize() {
            return new JsonPrimitive("removeInnerFrames(" + this.numberOfFrames + ")");
        }

        @Override
        public boolean isRemoveInnerFramesAction() {
            return true;
        }

        @Override
        public RemoveInnerFramesAction asRemoveInnerFramesRewriteAction() {
            return this;
        }

        @Override
        public void evaluate(RetraceStackTraceCurrentEvaluationInformation.Builder builder) {
            builder.incrementRemoveInnerFramesCount(this.numberOfFrames);
        }
    }

    public static abstract class RewriteAction {
        private static RewriteAction deserialize(JsonElement element) {
            String functionString = element.getAsString();
            int startArgsIndex = functionString.indexOf("(");
            int endArgsIndex = functionString.indexOf(")");
            if (endArgsIndex <= startArgsIndex) {
                throw new Unimplemented("Unexpected action: " + functionString);
            }
            String functionName = functionString.substring(0, startArgsIndex);
            String args2 = functionString.substring(startArgsIndex + 1, endArgsIndex);
            if ("removeInnerFrames".equals(functionName)) {
                return RemoveInnerFramesAction.deserialize(args2);
            }
            assert (false) : "Unknown function " + functionName;
            throw new Unimplemented("Unexpected action: " + functionName);
        }

        abstract JsonElement serialize();

        public boolean isRemoveInnerFramesAction() {
            return false;
        }

        public RemoveInnerFramesAction asRemoveInnerFramesRewriteAction() {
            return null;
        }

        public abstract void evaluate(RetraceStackTraceCurrentEvaluationInformation.Builder var1);
    }

    public static class ThrowsCondition
    extends Condition {
        static final String FUNCTION_NAME = "throws";
        private final ClassReference classReference;

        private ThrowsCondition(ClassReference classReference) {
            this.classReference = classReference;
        }

        public static ThrowsCondition deserialize(String conditionString) {
            if (!DescriptorUtils.isClassDescriptor(conditionString)) {
                throw new CompilationError("Unexpected throws-descriptor: " + conditionString);
            }
            return new ThrowsCondition(Reference.classFromDescriptor(conditionString));
        }

        public static ThrowsCondition create(ClassReference classReference) {
            return new ThrowsCondition(classReference);
        }

        @Override
        protected JsonPrimitive serialize() {
            return new JsonPrimitive("throws(" + this.classReference.getDescriptor() + ")");
        }

        @Override
        public boolean isThrowsCondition() {
            return true;
        }

        @Override
        public ThrowsCondition asThrowsCondition() {
            return this;
        }

        @Override
        public boolean evaluate(RetraceStackTraceContextImpl context) {
            return this.classReference.equals(context.getThrownException());
        }
    }

    public static abstract class Condition {
        private static Condition deserialize(JsonElement element) {
            String elementString = element.getAsString();
            int argIndex = elementString.indexOf(40);
            if (argIndex < 1 || !elementString.endsWith(")")) {
                throw new CompilationError("Invalid formatted condition: " + elementString);
            }
            String functionName = elementString.substring(0, argIndex);
            String contents = elementString.substring(argIndex + 1, elementString.length() - 1);
            if ("throws".equals(functionName)) {
                return ThrowsCondition.deserialize(contents);
            }
            throw new CompilationError("Unexpected condition: " + elementString);
        }

        protected abstract JsonPrimitive serialize();

        public boolean isThrowsCondition() {
            return false;
        }

        public ThrowsCondition asThrowsCondition() {
            return null;
        }

        public abstract boolean evaluate(RetraceStackTraceContextImpl var1);
    }

    public static class Builder {
        private final List<Condition> conditions = new ArrayList<Condition>();
        private final List<RewriteAction> actions = new ArrayList<RewriteAction>();

        public Builder addCondition(Condition condition) {
            this.conditions.add(condition);
            return this;
        }

        public Builder addRewriteAction(RewriteAction action) {
            this.actions.add(action);
            return this;
        }

        public RewriteFrameMappingInformation build() {
            return new RewriteFrameMappingInformation(this.conditions, this.actions);
        }
    }
}

