/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfo;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.optimize.MemberRebindingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.AndroidApiLevelUtils;
import com.android.tools.r8.utils.BiForEachable;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.TriConsumer;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;
import java.util.function.Function;

public class MemberRebindingAnalysis {
    private final AndroidApiLevelCompute androidApiLevelCompute;
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions options;
    private final MemberRebindingLens.Builder lensBuilder;

    public MemberRebindingAnalysis(AppView<AppInfoWithLiveness> appView) {
        assert (appView.graphLens().isContextFreeForMethods());
        this.androidApiLevelCompute = appView.apiLevelCompute();
        this.appView = appView;
        this.options = appView.options();
        this.lensBuilder = MemberRebindingLens.builder(appView);
    }

    private DexMethod validMemberRebindingTargetForNonProgramMethod(DexClassAndMethod resolvedMethod, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethodSet contexts, Invoke.Type invokeType, DexMethod original) {
        assert (!resolvedMethod.isProgramMethod());
        if (invokeType.isDirect()) {
            return original;
        }
        if (invokeType.isSuper() && this.options.canHaveSuperInvokeBug()) {
            DexType firstLibraryTarget = MemberRebindingAnalysis.firstLibraryClassOrFirstInterfaceTarget(resolutionResult.getResolvedHolder(), this.appView, (DexMethod)resolvedMethod.getReference(), original.getHolderType(), DexClass::lookupMethod);
            if (firstLibraryTarget == null) {
                return original;
            }
            DexClass libraryHolder = this.appView.definitionFor(firstLibraryTarget);
            if (libraryHolder == null) {
                return original;
            }
            if (libraryHolder == resolvedMethod.getHolder()) {
                return (DexMethod)resolvedMethod.getReference();
            }
            return ((DexMethod)resolvedMethod.getReference()).withHolder(libraryHolder, this.appView.dexItemFactory());
        }
        DexClassAndMember eligibleLibraryMethod = null;
        MethodResolutionResult.SingleResolutionResult currentResolutionResult = resolutionResult;
        while (currentResolutionResult != null) {
            DexClassAndMethod currentResolvedMethod = currentResolutionResult.getResolutionPair();
            if (this.canRebindDirectlyToLibraryMethod(currentResolvedMethod, currentResolutionResult.withInitialResolutionHolder(currentResolutionResult.getResolvedHolder()), contexts, invokeType)) {
                eligibleLibraryMethod = currentResolvedMethod.asLibraryMethod();
            }
            if (this.appView.appInfo().isAssumeMethod(currentResolvedMethod)) break;
            DexClass currentResolvedHolder = currentResolvedMethod.getHolder();
            if (!((DexEncodedMethod)resolvedMethod.getDefinition()).belongsToVirtualPool() || currentResolvedHolder.isInterface() || currentResolvedHolder.getSuperType() == null) break;
            currentResolutionResult = this.appView.appInfo().resolveMethodOnClass(original, currentResolvedHolder.getSuperType()).asSingleResolution();
        }
        if (eligibleLibraryMethod != null) {
            return (DexMethod)eligibleLibraryMethod.getReference();
        }
        DexType newHolder = MemberRebindingAnalysis.firstLibraryClassOrFirstInterfaceTarget(resolvedMethod.getHolder(), this.appView, (DexMethod)resolvedMethod.getReference(), original.getHolderType(), DexClass::lookupMethod);
        return newHolder != null ? original.withHolder(newHolder, this.appView.dexItemFactory()) : original;
    }

    private boolean canRebindDirectlyToLibraryMethod(DexClassAndMethod resolvedMethod, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethodSet contexts, Invoke.Type invokeType) {
        return resolvedMethod.isLibraryMethod() && this.isAccessibleInAllContexts(resolvedMethod, resolutionResult, contexts) && !this.isInvokeSuperToInterfaceMethod(resolvedMethod, invokeType) && !this.isInvokeSuperToAbstractMethod(resolvedMethod, invokeType) && AndroidApiLevelUtils.isApiSafeForMemberRebinding(resolvedMethod.asLibraryMethod(), this.androidApiLevelCompute, this.options);
    }

    private boolean isAccessibleInAllContexts(DexClassAndMethod resolvedMethod, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethodSet contexts) {
        if (resolvedMethod.getHolder().isPublic() && ((DexEncodedMethod)resolvedMethod.getDefinition()).isPublic()) {
            return true;
        }
        return Iterables.all(contexts, context -> resolutionResult.isAccessibleFrom((ProgramDefinition)context, this.appView.appInfo()).isTrue());
    }

    private boolean isInvokeSuperToInterfaceMethod(DexClassAndMethod method, Invoke.Type invokeType) {
        return method.getHolder().isInterface() && invokeType.isSuper();
    }

    private boolean isInvokeSuperToAbstractMethod(DexClassAndMethod method, Invoke.Type invokeType) {
        return method.getAccessFlags().isAbstract() && invokeType.isSuper();
    }

    public static DexField validMemberRebindingTargetFor(DexDefinitionSupplier definitions, DexClassAndField field, DexField original) {
        if (field.isProgramField()) {
            return (DexField)field.getReference();
        }
        DexClass fieldHolder = field.getHolder();
        DexType newHolder = MemberRebindingAnalysis.firstLibraryClassOrFirstInterfaceTarget(fieldHolder, definitions, (DexField)field.getReference(), original.getHolderType(), DexClass::lookupField);
        return newHolder != null ? original.withHolder(newHolder, definitions.dexItemFactory()) : original;
    }

    private static <T> DexType firstLibraryClassOrFirstInterfaceTarget(DexClass holder, DexDefinitionSupplier definitions, T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        return holder.isInterface() ? MemberRebindingAnalysis.firstLibraryClassForInterfaceTarget(definitions, target, current, lookup) : MemberRebindingAnalysis.firstLibraryClass(definitions, current);
    }

    private static <T> DexType firstLibraryClassForInterfaceTarget(DexDefinitionSupplier definitions, T target, DexType current, BiFunction<DexClass, T, ?> lookup) {
        DexType matchingSuper;
        DexClass clazz = definitions.definitionFor(current);
        if (clazz == null) {
            return null;
        }
        Object potential = lookup.apply(clazz, (DexClass)target);
        if (potential != null) {
            return current;
        }
        if (clazz.superType != null && (matchingSuper = MemberRebindingAnalysis.firstLibraryClassForInterfaceTarget(definitions, target, clazz.superType, lookup)) != null) {
            return clazz.isNotProgramClass() ? current : matchingSuper;
        }
        for (DexType iface : clazz.getInterfaces()) {
            DexType matchingIface = MemberRebindingAnalysis.firstLibraryClassForInterfaceTarget(definitions, target, iface, lookup);
            if (matchingIface == null) continue;
            return clazz.isNotProgramClass() ? current : matchingIface;
        }
        return null;
    }

    private static DexType firstLibraryClass(DexDefinitionSupplier definitions, DexType bottom) {
        DexClass searchClass = definitions.contextIndependentDefinitionFor(bottom);
        while (searchClass != null && searchClass.isProgramClass()) {
            searchClass = definitions.definitionFor(searchClass.getSuperType(), searchClass.asProgramClass());
        }
        return searchClass != null ? searchClass.getType() : null;
    }

    private MethodResolutionResult resolveMethodOnClass(DexMethod method) {
        return this.appView.appInfo().resolveMethodOnClass(method, method.holder);
    }

    private MethodResolutionResult resolveMethodOnInterface(DexMethod method) {
        return this.appView.appInfo().resolveMethodOnInterface(method.holder, method);
    }

    private MethodResolutionResult resolveMethod(DexMethod method) {
        return this.appView.appInfo().unsafeResolveMethodDueToDexFormat(method);
    }

    private void computeMethodRebinding(MethodAccessInfoCollection methodAccessInfoCollection) {
        this.computeMethodRebinding(methodAccessInfoCollection::forEachVirtualInvoke, this::resolveMethodOnClass, Invoke.Type.VIRTUAL);
        this.computeMethodRebinding(methodAccessInfoCollection::forEachInterfaceInvoke, this::resolveMethodOnInterface, Invoke.Type.INTERFACE);
        this.computeMethodRebinding(methodAccessInfoCollection::forEachSuperInvoke, this::resolveMethod, Invoke.Type.SUPER);
        this.computeMethodRebinding(methodAccessInfoCollection::forEachStaticInvoke, this::resolveMethod, Invoke.Type.STATIC);
    }

    private void computeMethodRebinding(BiForEachable<DexMethod, ProgramMethodSet> methodsWithContexts, Function<DexMethod, MethodResolutionResult> resolver, Invoke.Type invokeType) {
        IdentityHashMap<DexProgramClass, List> bridges = new IdentityHashMap<DexProgramClass, List>();
        TriConsumer<DexProgramClass, DexMethod, DexClassAndMethod> addBridge = (bridgeHolder, method, target) -> bridges.computeIfAbsent((DexProgramClass)bridgeHolder, k -> new ArrayList()).add(new Pair<DexMethod, DexClassAndMethod>((DexMethod)method, (DexClassAndMethod)target));
        methodsWithContexts.forEach((method, contexts) -> {
            MethodResolutionResult resolutionResult = (MethodResolutionResult)resolver.apply((DexMethod)method);
            if (!resolutionResult.isSingleResolution()) {
                return;
            }
            DexClassAndMethod resolvedMethod = resolutionResult.getResolutionPair();
            if (resolvedMethod.getReference() == method) {
                return;
            }
            DexClass initialResolutionHolder = resolutionResult.getInitialResolutionHolder();
            DexMethod bridgeMethod = null;
            if (initialResolutionHolder.isProgramClass()) {
                if (this.needsBridgeForInterfaceMethod(initialResolutionHolder, resolvedMethod, invokeType)) {
                    bridgeMethod = this.insertBridgeForInterfaceMethod((DexMethod)method, resolvedMethod, initialResolutionHolder.asProgramClass(), addBridge);
                } else if (contexts.stream().anyMatch(context -> this.mayNeedBridgeForVisibility((ProgramMethod)context, resolvedMethod))) {
                    bridgeMethod = this.insertBridgeForVisibilityIfNeeded((DexMethod)method, resolvedMethod, initialResolutionHolder, addBridge);
                }
            }
            if (bridgeMethod != null) {
                this.lensBuilder.map((DexMethod)method, bridgeMethod, invokeType);
            } else if (resolvedMethod.isProgramMethod()) {
                this.lensBuilder.map((DexMethod)method, (DexMethod)resolvedMethod.getReference(), invokeType);
            } else {
                this.lensBuilder.map((DexMethod)method, this.validMemberRebindingTargetForNonProgramMethod(resolvedMethod, resolutionResult.asSingleResolution(), (ProgramMethodSet)contexts, invokeType, (DexMethod)method), invokeType);
            }
        });
        bridges.forEach((bridgeHolder, targets) -> {
            targets.sort((p1, p2) -> ((DexMethod)p1.getFirst()).compareTo((DexMethod)p2.getFirst()));
            for (Pair pair : targets) {
                DexMethod method = (DexMethod)pair.getFirst();
                DexClassAndMethod target = (DexClassAndMethod)pair.getSecond();
                DexMethod bridgeMethod = method.withHolder(bridgeHolder.getType(), this.appView.dexItemFactory());
                if (bridgeHolder.getMethodCollection().getMethod(bridgeMethod) == null) {
                    DexEncodedMethod bridgeMethodDefinition = ((DexEncodedMethod)target.getDefinition()).toForwardingMethod((DexClass)bridgeHolder, this.appView);
                    bridgeHolder.addMethod(bridgeMethodDefinition);
                }
                assert (((MethodResolutionResult)resolver.apply(method)).getResolvedMethod().getReference() == bridgeMethod);
            }
        });
    }

    private boolean needsBridgeForInterfaceMethod(DexClass originalClass, DexClassAndMethod method, Invoke.Type invokeType) {
        return this.options.isGeneratingClassFiles() && invokeType == Invoke.Type.SUPER && method.getHolder() != originalClass && method.getHolder().isInterface();
    }

    private DexMethod insertBridgeForInterfaceMethod(DexMethod method, DexClassAndMethod target, DexProgramClass originalClass, TriConsumer<DexProgramClass, DexMethod, DexClassAndMethod> bridges) {
        DexProgramClass bridgeHolder = this.findHolderForInterfaceMethodBridge(originalClass, target.getHolderType());
        assert (bridgeHolder != null);
        assert (bridgeHolder != target.getHolder());
        bridges.accept(bridgeHolder, method, target);
        return ((DexMethod)target.getReference()).withHolder(bridgeHolder.getType(), this.appView.dexItemFactory());
    }

    private DexProgramClass findHolderForInterfaceMethodBridge(DexProgramClass clazz, DexType iface) {
        if (clazz.accessFlags.isInterface()) {
            return clazz;
        }
        DexClass superClass = this.appView.definitionFor(clazz.superType);
        if (superClass == null || superClass.isNotProgramClass() || !this.appView.appInfo().isSubtype(superClass.type, iface)) {
            return clazz;
        }
        return this.findHolderForInterfaceMethodBridge(superClass.asProgramClass(), iface);
    }

    private boolean mayNeedBridgeForVisibility(ProgramMethod context, DexClassAndMethod method) {
        DexType holderType = method.getHolderType();
        DexClass holder = this.appView.definitionFor(holderType);
        if (holder == null) {
            return false;
        }
        Inliner.ConstraintWithTarget classVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, holder.getAccessFlags(), this.appView);
        Inliner.ConstraintWithTarget methodVisibility = Inliner.ConstraintWithTarget.deriveConstraint(context, holderType, method.getAccessFlags(), this.appView);
        return classVisibility == Inliner.ConstraintWithTarget.NEVER && methodVisibility != Inliner.ConstraintWithTarget.NEVER;
    }

    private DexMethod insertBridgeForVisibilityIfNeeded(DexMethod method, DexClassAndMethod target, DexClass originalClass, TriConsumer<DexProgramClass, DexMethod, DexClassAndMethod> bridges) {
        String packageDescriptor;
        String string = packageDescriptor = originalClass.accessFlags.isPublic() ? null : method.holder.getPackageDescriptor();
        if (packageDescriptor == null || !packageDescriptor.equals(target.getHolderType().getPackageDescriptor())) {
            DexProgramClass bridgeHolder = this.findHolderForVisibilityBridge(originalClass, target.getHolder(), packageDescriptor);
            assert (bridgeHolder != null);
            bridges.accept(bridgeHolder, method, target);
            return ((DexMethod)target.getReference()).withHolder(bridgeHolder.getType(), this.appView.dexItemFactory());
        }
        return (DexMethod)target.getReference();
    }

    private DexProgramClass findHolderForVisibilityBridge(DexClass originalClass, DexClass targetClass, String packageDescriptor) {
        if (originalClass == targetClass || originalClass.isNotProgramClass()) {
            return null;
        }
        DexProgramClass newHolder = null;
        if (this.appView.appInfo().isSubtype(originalClass.superType, targetClass.type)) {
            DexClass superClass = this.appView.definitionFor(originalClass.superType);
            newHolder = this.findHolderForVisibilityBridge(superClass, targetClass, packageDescriptor);
        } else {
            for (DexType iface : originalClass.interfaces.values) {
                if (!this.appView.appInfo().isSubtype(iface, targetClass.type)) continue;
                DexClass interfaceClass = this.appView.definitionFor(iface);
                newHolder = this.findHolderForVisibilityBridge(interfaceClass, targetClass, packageDescriptor);
            }
        }
        if (newHolder != null) {
            return newHolder;
        }
        if (originalClass.accessFlags.isPublic() || originalClass.type.getPackageDescriptor().equals(packageDescriptor)) {
            return originalClass.asProgramClass();
        }
        return null;
    }

    private void recordNonReboundFieldAccesses(ExecutorService executorService) throws ExecutionException {
        assert (this.verifyFieldAccessCollectionContainsAllNonReboundFieldReferences(executorService));
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        fieldAccessInfoCollection.forEach(this.lensBuilder::recordNonReboundFieldAccesses);
    }

    private boolean verifyFieldAccessCollectionContainsAllNonReboundFieldReferences(ExecutorService executorService) throws ExecutionException {
        Set<DexField> nonReboundFieldReferences = this.computeNonReboundFieldReferences(executorService);
        FieldAccessInfoCollection<? extends FieldAccessInfo> fieldAccessInfoCollection = this.appView.appInfo().getFieldAccessInfoCollection();
        fieldAccessInfoCollection.forEach(info -> {
            DexField reboundFieldReference = info.getField();
            info.forEachIndirectAccess(nonReboundFieldReference -> {
                assert (reboundFieldReference != nonReboundFieldReference);
                assert (reboundFieldReference == this.appView.appInfo().resolveField((DexField)nonReboundFieldReference).getResolvedFieldReference());
                nonReboundFieldReferences.remove(nonReboundFieldReference);
            });
        });
        assert (nonReboundFieldReferences.isEmpty());
        return true;
    }

    private Set<DexField> computeNonReboundFieldReferences(ExecutorService executorService) throws ExecutionException {
        final Set<DexField> nonReboundFieldReferences = Sets.newConcurrentHashSet();
        ThreadUtils.processItems(this.appView.appInfo()::forEachMethod, method -> {
            if (((DexEncodedMethod)method.getDefinition()).hasCode()) {
                method.registerCodeReferences(new UseRegistry<ProgramMethod>(this.appView, method){

                    private void registerFieldReference(DexField field) {
                        ((AppInfoWithLiveness)MemberRebindingAnalysis.this.appView.appInfo()).resolveField(field).forEachSuccessfulFieldResolutionResult(resolutionResult -> {
                            if (resolutionResult.getResolvedField().getReference() != field) {
                                nonReboundFieldReferences.add(field);
                            }
                        });
                    }

                    @Override
                    public void registerInstanceFieldRead(DexField field) {
                        this.registerFieldReference(field);
                    }

                    @Override
                    public void registerInstanceFieldWrite(DexField field) {
                        this.registerFieldReference(field);
                    }

                    @Override
                    public void registerStaticFieldRead(DexField field) {
                        this.registerFieldReference(field);
                    }

                    @Override
                    public void registerStaticFieldWrite(DexField field) {
                        this.registerFieldReference(field);
                    }

                    @Override
                    public void registerInitClass(DexType type) {
                    }

                    @Override
                    public void registerInvokeDirect(DexMethod method) {
                    }

                    @Override
                    public void registerInvokeInterface(DexMethod method) {
                    }

                    @Override
                    public void registerInvokeStatic(DexMethod method) {
                    }

                    @Override
                    public void registerInvokeSuper(DexMethod method) {
                    }

                    @Override
                    public void registerInvokeVirtual(DexMethod method) {
                    }

                    @Override
                    public void registerNewInstance(DexType type) {
                    }

                    @Override
                    public void registerInstanceOf(DexType type) {
                    }

                    @Override
                    public void registerTypeReference(DexType type) {
                    }
                });
            }
        }, executorService);
        return nonReboundFieldReferences;
    }

    public MemberRebindingLens run(ExecutorService executorService) throws ExecutionException {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        this.computeMethodRebinding(appInfo.getMethodAccessInfoCollection());
        this.recordNonReboundFieldAccesses(executorService);
        appInfo.getFieldAccessInfoCollection().flattenAccessContexts();
        return this.lensBuilder.build();
    }
}

