/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AbstractAccessContexts;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldAccessInfoCollection;
import com.android.tools.r8.graph.FieldAccessInfoCollectionImpl;
import com.android.tools.r8.graph.FieldAccessInfoImpl;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistry;
import com.android.tools.r8.optimize.MemberRebindingIdentityLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class MemberRebindingIdentityLensFactory {
    public static MemberRebindingIdentityLens create(AppView<? extends AppInfoWithClassHierarchy> appView, ExecutorService executorService) throws ExecutionException {
        MethodAccessInfoCollection methodAccessInfoCollection;
        FieldAccessInfoCollectionImpl fieldAccessInfoCollection;
        if (appView.appInfo().hasLiveness() && appView.options().testing.alwaysUseExistingAccessInfoCollectionsInMemberRebinding) {
            AppInfoWithLiveness appInfo = appView.appInfo().withLiveness();
            fieldAccessInfoCollection = appInfo.getFieldAccessInfoCollection();
            methodAccessInfoCollection = appInfo.getMethodAccessInfoCollection();
        } else {
            FieldAccessInfoCollectionImpl mutableFieldAccessInfoCollection = new FieldAccessInfoCollectionImpl(new ConcurrentHashMap<DexField, FieldAccessInfoImpl>());
            MethodAccessInfoCollection.ConcurrentBuilder methodAccessInfoCollectionBuilder = MethodAccessInfoCollection.concurrentBuilder();
            MemberRebindingIdentityLensFactory.initializeMemberAccessInfoCollectionsForMemberRebinding(appView, mutableFieldAccessInfoCollection, methodAccessInfoCollectionBuilder, executorService);
            fieldAccessInfoCollection = mutableFieldAccessInfoCollection;
            methodAccessInfoCollection = methodAccessInfoCollectionBuilder.build();
        }
        return MemberRebindingIdentityLensFactory.create(appView, fieldAccessInfoCollection, methodAccessInfoCollection);
    }

    public static MemberRebindingIdentityLens create(AppView<? extends AppInfoWithClassHierarchy> appView, FieldAccessInfoCollection<?> fieldAccessInfoCollection, MethodAccessInfoCollection methodAccessInfoCollection) {
        MemberRebindingIdentityLens.Builder builder = MemberRebindingIdentityLens.builder(appView);
        fieldAccessInfoCollection.forEach(builder::recordNonReboundFieldAccesses);
        methodAccessInfoCollection.forEachMethodReference(builder::recordMethodAccess);
        return builder.build();
    }

    private static void initializeMemberAccessInfoCollectionsForMemberRebinding(AppView<? extends AppInfoWithClassHierarchy> appView, FieldAccessInfoCollectionImpl fieldAccessInfoCollection, MethodAccessInfoCollection.ConcurrentBuilder methodAccessInfoCollectionBuilder, ExecutorService executorService) throws ExecutionException {
        Set seenFieldReferences = Sets.newConcurrentHashSet();
        Set seenMethodReferences = Sets.newConcurrentHashSet();
        ThreadUtils.processItems(appView.appInfo()::forEachMethod, method -> new NonReboundMemberReferencesRegistry(appView, (ProgramMethod)method, fieldAccessInfoCollection, methodAccessInfoCollectionBuilder, seenFieldReferences, seenMethodReferences).accept((ProgramMethod)method), executorService);
    }

    private static class NonReboundMemberReferencesRegistry
    extends UseRegistry<ProgramMethod> {
        private final AppInfoWithClassHierarchy appInfo;
        private final FieldAccessInfoCollectionImpl fieldAccessInfoCollection;
        private final MethodAccessInfoCollection.ConcurrentBuilder methodAccessInfoCollectionBuilder;
        private final Set<DexField> seenFieldReferences;
        private final Set<DexMethod> seenMethodReferences;

        public NonReboundMemberReferencesRegistry(AppView<? extends AppInfoWithClassHierarchy> appView, ProgramMethod context, FieldAccessInfoCollectionImpl fieldAccessInfoCollection, MethodAccessInfoCollection.ConcurrentBuilder methodAccessInfoCollectionBuilder, Set<DexField> seenFieldReferences, Set<DexMethod> seenMethodReferences) {
            super(appView, context);
            this.appInfo = appView.appInfo();
            this.fieldAccessInfoCollection = fieldAccessInfoCollection;
            this.methodAccessInfoCollectionBuilder = methodAccessInfoCollectionBuilder;
            this.seenFieldReferences = seenFieldReferences;
            this.seenMethodReferences = seenMethodReferences;
        }

        private void registerFieldAccess(DexField field) {
            if (!this.seenFieldReferences.add(field)) {
                return;
            }
            this.appInfo.resolveField(field).forEachSuccessfulFieldResolutionResult(resolutionResult -> {
                FieldAccessInfoImpl fieldAccessInfo;
                DexField reboundReference = (DexField)resolutionResult.getResolvedField().getReference();
                if (field == reboundReference) {
                    return;
                }
                FieldAccessInfoImpl fieldAccessInfoImpl = fieldAccessInfo = this.fieldAccessInfoCollection.computeIfAbsent(reboundReference, FieldAccessInfoImpl::new);
                synchronized (fieldAccessInfoImpl) {
                    if (fieldAccessInfo.getReadsWithContexts().isBottom()) {
                        fieldAccessInfo.setReadsWithContexts(new AbstractAccessContexts.ConcreteAccessContexts());
                    } else assert (fieldAccessInfo.getReadsWithContexts().isConcrete());
                    AbstractAccessContexts.ConcreteAccessContexts accessContexts = fieldAccessInfo.getReadsWithContexts().asConcrete();
                    accessContexts.getAccessesWithContexts().put(field, ProgramMethodSet.empty());
                }
            });
        }

        private void registerInvokeMethod(DexMethod method, Map<DexMethod, ProgramMethodSet> invokes) {
            if (!this.seenMethodReferences.add(method)) {
                return;
            }
            if (method.getHolderType().isArrayType()) {
                return;
            }
            DexClass holder = this.appInfo.definitionFor(method.getHolderType(), (ProgramMethod)this.getContext());
            if (holder == null) {
                return;
            }
            MethodResolutionResult.SingleResolutionResult resolutionResult = this.appInfo.resolveMethodOn(holder, method).asSingleResolution();
            if (resolutionResult == null) {
                return;
            }
            DexMethod reboundReference = (DexMethod)resolutionResult.getResolvedMethod().getReference();
            if (method == reboundReference) {
                return;
            }
            invokes.put(method, ProgramMethodSet.empty());
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            this.registerInvokeMethod(method, (Map<DexMethod, ProgramMethodSet>)this.methodAccessInfoCollectionBuilder.getDirectInvokes());
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            this.registerInvokeMethod(method, (Map<DexMethod, ProgramMethodSet>)this.methodAccessInfoCollectionBuilder.getInterfaceInvokes());
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            this.registerInvokeMethod(method, (Map<DexMethod, ProgramMethodSet>)this.methodAccessInfoCollectionBuilder.getStaticInvokes());
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            this.registerInvokeMethod(method, (Map<DexMethod, ProgramMethodSet>)this.methodAccessInfoCollectionBuilder.getSuperInvokes());
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            this.registerInvokeMethod(method, (Map<DexMethod, ProgramMethodSet>)this.methodAccessInfoCollectionBuilder.getVirtualInvokes());
        }

        @Override
        public void registerInitClass(DexType type) {
        }

        @Override
        public void registerNewInstance(DexType type) {
        }

        @Override
        public void registerTypeReference(DexType type) {
        }

        @Override
        public void registerInstanceOf(DexType type) {
        }
    }
}

