/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.ir.code.Invoke;
import java.util.Set;

final class PublicizerLens
extends NestedGraphLens {
    private final AppView<?> appView;
    private final Set<DexMethod> publicizedMethods;

    private PublicizerLens(AppView<?> appView, Set<DexMethod> publicizedMethods) {
        super(appView, EMPTY_FIELD_MAP, EMPTY_METHOD_MAP, EMPTY_TYPE_MAP);
        this.appView = appView;
        this.publicizedMethods = publicizedMethods;
    }

    private boolean publicizedMethodIsPresentOnHolder(DexMethod method, DexMethod context) {
        GraphLens.MethodLookupResult lookup = this.appView.graphLens().lookupMethod(method, context, Invoke.Type.VIRTUAL);
        DexMethod signatureInCurrentWorld = (DexMethod)lookup.getReference();
        DexClass clazz = this.appView.definitionFor(signatureInCurrentWorld.holder);
        assert (clazz != null);
        DexEncodedMethod actualEncodedTarget = clazz.lookupVirtualMethod(signatureInCurrentWorld);
        assert (actualEncodedTarget != null);
        assert (actualEncodedTarget.isPublic());
        return true;
    }

    static PublicizedLensBuilder createBuilder() {
        return new PublicizedLensBuilder();
    }

    @Override
    protected boolean isLegitimateToHaveEmptyMappings() {
        return true;
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        return previous;
    }

    @Override
    public GraphLens.MethodLookupResult internalDescribeLookupMethod(GraphLens.MethodLookupResult previous, DexMethod context) {
        if (previous.getType() == Invoke.Type.DIRECT && this.publicizedMethods.contains(previous.getReference())) {
            assert (this.publicizedMethodIsPresentOnHolder((DexMethod)previous.getReference(), context));
            return ((GraphLens.MethodLookupResult.Builder)GraphLens.MethodLookupResult.builder(this).setReference((DexMethod)previous.getReference())).setPrototypeChanges(previous.getPrototypeChanges()).setType(Invoke.Type.VIRTUAL).build();
        }
        return previous;
    }

    static class PublicizedLensBuilder {
        private final Set<DexMethod> publicizedMethods = Sets.newIdentityHashSet();

        private PublicizedLensBuilder() {
        }

        public GraphLens build(AppView appView) {
            if (this.publicizedMethods.isEmpty()) {
                return appView.graphLens();
            }
            return new PublicizerLens(appView, this.publicizedMethods);
        }

        public void add(DexMethod publicizedMethod) {
            this.publicizedMethods.add(publicizedMethod);
        }
    }
}

