/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.logging.Log;
import com.android.tools.r8.optimize.InvokeSingleTargetExtractor;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class VisibilityBridgeRemover {
    private final AppView<AppInfoWithLiveness> appView;

    public VisibilityBridgeRemover(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private boolean isUnneededVisibilityBridge(ProgramMethod method) {
        if (this.appView.appInfo().isPinned(method.getReference())) {
            return false;
        }
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        if (!definition.isBridge() || definition.isAbstract()) {
            return false;
        }
        InvokeSingleTargetExtractor targetExtractor = new InvokeSingleTargetExtractor(this.appView, method);
        method.registerCodeReferences(targetExtractor);
        DexMethod target = targetExtractor.getTarget();
        if (target == null || !target.match((DexMethod)method.getReference())) {
            return false;
        }
        assert (!definition.isPrivate() && !definition.isInstanceInitializer());
        if (!this.isTargetingSuperMethod(method, targetExtractor.getKind(), target)) {
            return false;
        }
        ProgramMethod targetMethod = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(target).getResolvedProgramMethod();
        if (targetMethod == null || !targetMethod.getAccessFlags().isPublic()) {
            return false;
        }
        if (definition.isStatic() && method.getHolder().hasClassInitializer() && method.getHolder().classInitializationMayHaveSideEffectsInContext(this.appView, targetMethod)) {
            return false;
        }
        if (Log.ENABLED) {
            Log.info(this.getClass(), "Removing visibility forwarding %s -> %s", method, targetMethod.getReference());
        }
        return true;
    }

    private boolean isTargetingSuperMethod(ProgramMethod method, InvokeSingleTargetExtractor.InvokeKind kind, DexMethod target) {
        if (kind == InvokeSingleTargetExtractor.InvokeKind.SUPER) {
            return true;
        }
        if (kind == InvokeSingleTargetExtractor.InvokeKind.STATIC) {
            return this.appView.appInfo().isStrictSubtypeOf(method.getHolderType(), target.holder);
        }
        assert (false) : "Unexpected invoke-kind for visibility bridge";
        return false;
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        if (!this.appView.options().enableVisibilityBridgeRemoval) {
            return;
        }
        ConcurrentHashMap<DexProgramClass, Set> visibilityBridgesToRemove = new ConcurrentHashMap<DexProgramClass, Set>();
        ThreadUtils.processItems(this.appView.appInfo().classes(), clazz -> {
            Set bridgesToRemoveForClass = Sets.newIdentityHashSet();
            clazz.forEachProgramMethod(method -> {
                if (this.isUnneededVisibilityBridge((ProgramMethod)method)) {
                    bridgesToRemoveForClass.add((DexEncodedMethod)method.getDefinition());
                }
            });
            if (!bridgesToRemoveForClass.isEmpty()) {
                visibilityBridgesToRemove.put((DexProgramClass)clazz, bridgesToRemoveForClass);
            }
        }, executorService);
        PrunedItems.Builder builder = PrunedItems.builder();
        visibilityBridgesToRemove.forEach((clazz, methods) -> {
            clazz.getMethodCollection().removeMethods((Set<DexEncodedMethod>)methods);
            methods.forEach(method -> builder.addRemovedMethod((DexMethod)method.getReference()));
        });
    }
}

