/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorApplicationFixer;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorCodeScanner;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorGraphLens;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorMethodReprocessingEnqueuer;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorOptimizationInfoPopulator;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorProgramOptimizer;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorUnoptimizableMethods;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.VirtualRootMethodsAnalysis;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ArgumentPropagatorReprocessingCriteriaCollection;
import com.android.tools.r8.optimize.argumentpropagation.unusedarguments.EffectivelyUnusedArgumentsAnalysis;
import com.android.tools.r8.optimize.argumentpropagation.utils.ProgramClassesBidirectedGraph;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;

public class ArgumentPropagator {
    private final AppView<AppInfoWithLiveness> appView;
    private ArgumentPropagatorCodeScanner codeScanner;
    private EffectivelyUnusedArgumentsAnalysis effectivelyUnusedArgumentsAnalysis;
    private ArgumentPropagatorReprocessingCriteriaCollection reprocessingCriteriaCollection;

    public ArgumentPropagator(AppView<AppInfoWithLiveness> appView) {
        assert (appView.enableWholeProgramOptimizations());
        assert (appView.options().isOptimizing());
        assert (appView.options().callSiteOptimizationOptions().isEnabled());
        this.appView = appView;
    }

    private void populateParameterOptimizationInfo(IRConverter converter, ImmediateProgramSubtypingInfo immediateSubtypingInfo, List<Set<DexProgramClass>> stronglyConnectedProgramComponents, BiConsumer<Set<DexProgramClass>, DexMethodSignature> interfaceDispatchOutsideProgram, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (this.appView.isAllCodeProcessed());
        MethodStateCollectionByReference codeScannerResult = this.codeScanner.getMethodStates();
        this.appView.testing().argumentPropagatorEventConsumer.acceptCodeScannerResult(codeScannerResult);
        this.codeScanner = null;
        postMethodProcessorBuilder.rewrittenWithLens(this.appView);
        timing.begin("Compute optimization info");
        new ArgumentPropagatorOptimizationInfoPopulator(this.appView, converter, immediateSubtypingInfo, codeScannerResult, postMethodProcessorBuilder, stronglyConnectedProgramComponents, interfaceDispatchOutsideProgram).populateOptimizationInfo(executorService, timing);
        timing.end();
        timing.begin("Compute unused arguments");
        this.effectivelyUnusedArgumentsAnalysis.computeEffectivelyUnusedArguments();
        this.effectivelyUnusedArgumentsAnalysis = null;
        timing.end();
    }

    public void initializeCodeScanner(ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (!this.appView.getSyntheticItems().hasPendingSyntheticClasses());
        timing.begin("Argument propagator");
        timing.begin("Initialize code scanner");
        this.reprocessingCriteriaCollection = new ArgumentPropagatorReprocessingCriteriaCollection(this.appView);
        this.codeScanner = new ArgumentPropagatorCodeScanner(this.appView, this.reprocessingCriteriaCollection);
        this.effectivelyUnusedArgumentsAnalysis = new EffectivelyUnusedArgumentsAnalysis(this.appView);
        ImmediateProgramSubtypingInfo immediateSubtypingInfo = ImmediateProgramSubtypingInfo.create(this.appView);
        List stronglyConnectedProgramClasses = new ProgramClassesBidirectedGraph(this.appView, immediateSubtypingInfo).computeStronglyConnectedComponents();
        ThreadUtils.processItems(stronglyConnectedProgramClasses, classes -> {
            new ArgumentPropagatorUnoptimizableMethods(this.appView, immediateSubtypingInfo, this.codeScanner.getMethodStates()).initializeUnoptimizableMethodStates((Collection<DexProgramClass>)classes);
            new VirtualRootMethodsAnalysis(this.appView, immediateSubtypingInfo).initializeVirtualRootMethods((Collection<DexProgramClass>)classes, this.codeScanner);
            this.effectivelyUnusedArgumentsAnalysis.initializeOptimizableVirtualMethods((Set<DexProgramClass>)classes);
        }, executorService);
        timing.end();
        timing.end();
    }

    public void scan(ProgramMethod method, IRCode code, MethodProcessor methodProcessor, Timing timing) {
        if (this.codeScanner != null) {
            assert (methodProcessor.isPrimaryMethodProcessor());
            this.codeScanner.scan(method, code, timing);
            assert (this.effectivelyUnusedArgumentsAnalysis != null);
            this.effectivelyUnusedArgumentsAnalysis.scan(method, code);
            assert (this.reprocessingCriteriaCollection != null);
            this.reprocessingCriteriaCollection.analyzeArgumentUses(method, code);
        } else {
            assert (!methodProcessor.isPrimaryMethodProcessor());
            assert (this.effectivelyUnusedArgumentsAnalysis == null);
            assert (!methodProcessor.isPostMethodProcessor() || this.reprocessingCriteriaCollection == null);
        }
    }

    public void publishDelayedReprocessingCriteria() {
        assert (this.reprocessingCriteriaCollection != null);
        this.reprocessingCriteriaCollection.publishDelayedReprocessingCriteria();
    }

    public void transferArgumentInformation(ProgramMethod from, ProgramMethod to) {
        assert (this.codeScanner != null);
        MethodStateCollectionByReference methodStates = this.codeScanner.getMethodStates();
        MethodState methodState = methodStates.remove(from);
        if (!methodState.isBottom()) {
            methodStates.addMethodState((AppView)this.appView, to, methodState);
        }
    }

    public void tearDownCodeScanner(IRConverter converter, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        assert (!this.appView.getSyntheticItems().hasPendingSyntheticClasses());
        assert (this.reprocessingCriteriaCollection.verifyNoDelayedReprocessingCriteria());
        timing.begin("Argument propagator");
        timing.begin("Compute components");
        ImmediateProgramSubtypingInfo immediateSubtypingInfo = ImmediateProgramSubtypingInfo.create(this.appView);
        List<Set<DexProgramClass>> stronglyConnectedProgramComponents = new ProgramClassesBidirectedGraph(this.appView, immediateSubtypingInfo).computeStronglyConnectedComponents();
        timing.end();
        IdentityHashMap<Set<DexProgramClass>, DexMethodSignatureSet> interfaceDispatchOutsideProgram = new IdentityHashMap<Set<DexProgramClass>, DexMethodSignatureSet>();
        this.populateParameterOptimizationInfo(converter, immediateSubtypingInfo, stronglyConnectedProgramComponents, (stronglyConnectedProgramComponent, signature) -> interfaceDispatchOutsideProgram.computeIfAbsent((Set<DexProgramClass>)stronglyConnectedProgramComponent, unused -> DexMethodSignatureSet.create()).add((DexMethodSignature)signature), postMethodProcessorBuilder, executorService, timing);
        Set<DexProgramClass> affectedClasses = Sets.newConcurrentHashSet();
        ArgumentPropagatorGraphLens graphLens = new ArgumentPropagatorProgramOptimizer(this.appView, immediateSubtypingInfo, interfaceDispatchOutsideProgram).run(stronglyConnectedProgramComponents, affectedClasses::add, executorService, timing);
        new ArgumentPropagatorMethodReprocessingEnqueuer(this.appView, this.reprocessingCriteriaCollection).enqueueMethodForReprocessing(graphLens, postMethodProcessorBuilder, executorService, timing);
        this.reprocessingCriteriaCollection = null;
        new ArgumentPropagatorApplicationFixer(this.appView, graphLens).fixupApplication(affectedClasses, executorService, timing);
        timing.end();
    }

    public void onMethodPruned(ProgramMethod method) {
        assert (this.codeScanner != null);
        MethodState methodState = this.codeScanner.getMethodStates().removeOrElse(method, null);
        assert (methodState == null || ((DexEncodedMethod)method.getDefinition()).belongsToDirectPool());
        assert (this.effectivelyUnusedArgumentsAnalysis != null);
        this.effectivelyUnusedArgumentsAnalysis.onMethodPruned(method);
    }

    public void onMethodCodePruned(ProgramMethod method) {
    }
}

