/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.code.AliasedValueConfiguration;
import com.android.tools.r8.ir.code.AssumeAndCheckCastAliasedValueConfiguration;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.BottomMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteArrayTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteClassTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodStateOrBottom;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodStateOrUnknown;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodStateOrBottom;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePrimitiveTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReceiverParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameterFactory;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.UnknownMethodState;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ArgumentPropagatorReprocessingCriteriaCollection;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.MethodReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ParameterReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.utils.WideningUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;

public class ArgumentPropagatorCodeScanner {
    private static AliasedValueConfiguration aliasedValueConfiguration = AssumeAndCheckCastAliasedValueConfiguration.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final MethodParameterFactory methodParameterFactory = new MethodParameterFactory();
    private final Set<DexMethod> monomorphicVirtualMethods = Sets.newIdentityHashSet();
    private final ArgumentPropagatorReprocessingCriteriaCollection reprocessingCriteriaCollection;
    private final Map<DexMethod, DexMethod> virtualRootMethods = new IdentityHashMap<DexMethod, DexMethod>();
    private final MethodStateCollectionByReference methodStates = MethodStateCollectionByReference.createConcurrent();

    ArgumentPropagatorCodeScanner(AppView<AppInfoWithLiveness> appView, ArgumentPropagatorReprocessingCriteriaCollection reprocessingCriteriaCollection) {
        this.appView = appView;
        this.reprocessingCriteriaCollection = reprocessingCriteriaCollection;
    }

    private void scan(InvokeMethod invoke, ProgramMethod context, Timing timing) {
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.getHolderType().isArrayType()) {
            return;
        }
        if (invoke.isInvokeMethodWithReceiver() && invoke.asInvokeMethodWithReceiver().getReceiver().isAlwaysNull(this.appView)) {
            return;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invokedMethod).asSingleResolution();
        if (resolutionResult == null) {
            return;
        }
        if (!resolutionResult.getResolvedHolder().isProgramClass()) {
            return;
        }
        ProgramMethod resolvedMethod = resolutionResult.getResolvedProgramMethod();
        if (((DexEncodedMethod)resolvedMethod.getDefinition()).isLibraryMethodOverride().isPossiblyTrue()) {
            assert (((DexEncodedMethod)resolvedMethod.getDefinition()).isLibraryMethodOverride().isTrue());
            return;
        }
        if (invoke.arguments().size() != ((DexEncodedMethod)resolvedMethod.getDefinition()).getNumberOfArguments() || invoke.isInvokeStatic() != resolvedMethod.getAccessFlags().isStatic()) {
            return;
        }
        if (invoke.isInvokeInterface() && !resolutionResult.getInitialResolutionHolder().isInterface()) {
            return;
        }
        if (invoke.isInvokeSuper()) {
            DexClassAndMethod target = resolutionResult.lookupInvokeSuperTarget(context.getHolder(), this.appView.appInfo());
            if (target == null) {
                return;
            }
            if (!target.isProgramMethod()) {
                throw new Unreachable("Expected super target of a non-library override to be a program method (resolved program method: " + resolvedMethod + ", super non-program method: " + target + ")");
            }
            resolvedMethod = target.asProgramMethod();
        }
        ProgramMethod finalResolvedMethod = resolvedMethod;
        timing.begin("Add method state");
        this.methodStates.addTemporaryMethodState(this.appView, this.getRepresentative(invoke, resolvedMethod), existingMethodState -> this.computeMethodState(invoke, finalResolvedMethod, context, (MethodState)existingMethodState, timing), timing);
        timing.end();
    }

    private MethodState computeMethodState(InvokeMethod invoke, ProgramMethod resolvedMethod, ProgramMethod context, MethodState existingMethodState, Timing timing) {
        MethodState result;
        assert (!existingMethodState.isUnknown());
        timing.begin("Compute method state for invoke");
        if (this.shouldUsePolymorphicMethodState(invoke, resolvedMethod)) {
            assert (existingMethodState.isBottom() || existingMethodState.isPolymorphic());
            result = this.computePolymorphicMethodState(invoke.asInvokeMethodWithReceiver(), resolvedMethod, context, existingMethodState.asPolymorphicOrBottom());
        } else {
            assert (existingMethodState.isBottom() || existingMethodState.isMonomorphic());
            result = this.computeMonomorphicMethodState(invoke, resolvedMethod, invoke.lookupSingleProgramTarget(this.appView, context), context, existingMethodState.asMonomorphicOrBottom());
        }
        timing.end();
        return result;
    }

    private MethodState computePolymorphicMethodState(InvokeMethodWithReceiver invoke, ProgramMethod resolvedMethod, ProgramMethod context, ConcretePolymorphicMethodStateOrBottom existingMethodState) {
        BottomMethodState existingMethodStateForBounds;
        DynamicTypeWithUpperBound dynamicReceiverType = invoke.getReceiver().getDynamicType(this.appView);
        assert (!dynamicReceiverType.getDynamicUpperBoundType().nullability().isDefinitelyNull());
        ProgramMethod singleTarget = invoke.lookupSingleProgramTarget(this.appView, context);
        DynamicTypeWithUpperBound bounds = this.computeBoundsForPolymorphicMethodState(invoke, resolvedMethod, singleTarget, context, dynamicReceiverType);
        MethodState methodState = existingMethodStateForBounds = existingMethodState.isPolymorphic() ? existingMethodState.asPolymorphic().getMethodStateForBounds(bounds) : MethodState.bottom();
        if (existingMethodStateForBounds.isPolymorphic()) {
            assert (false);
            return MethodState.unknown();
        }
        if (existingMethodStateForBounds.isUnknown()) {
            return MethodState.bottom();
        }
        ConcreteMonomorphicMethodStateOrUnknown methodStateForBounds = this.computeMonomorphicMethodState(invoke, resolvedMethod, singleTarget, context, existingMethodStateForBounds.asMonomorphicOrBottom(), dynamicReceiverType);
        return ConcretePolymorphicMethodState.create(bounds, methodStateForBounds);
    }

    private DynamicTypeWithUpperBound computeBoundsForPolymorphicMethodState(InvokeMethodWithReceiver invoke, ProgramMethod resolvedMethod, ProgramMethod singleTarget, ProgramMethod context, DynamicTypeWithUpperBound dynamicReceiverType) {
        DynamicTypeWithUpperBound bounds;
        DynamicTypeWithUpperBound dynamicTypeWithUpperBound = bounds = singleTarget != null ? DynamicType.createExact(singleTarget.getHolderType().toTypeElement(this.appView).asClassType()) : dynamicReceiverType.withNullability(Nullability.maybeNull());
        assert (bounds.getDynamicUpperBoundType().nullability().isMaybeNull());
        DexMethod virtualRootMethod = this.getVirtualRootMethod(resolvedMethod);
        if (virtualRootMethod == null) {
            assert (false) : "Unexpected virtual method without root: " + resolvedMethod;
            return bounds;
        }
        DynamicTypeWithUpperBound trivialBounds = DynamicType.create(this.appView, virtualRootMethod.getHolderType().toTypeElement(this.appView).asClassType());
        if (bounds.equals(trivialBounds)) {
            return DynamicType.unknown();
        }
        return bounds;
    }

    private ConcreteMonomorphicMethodStateOrUnknown computeMonomorphicMethodState(InvokeMethod invoke, ProgramMethod resolvedMethod, ProgramMethod singleTarget, ProgramMethod context, ConcreteMonomorphicMethodStateOrBottom existingMethodState) {
        return this.computeMonomorphicMethodState(invoke, resolvedMethod, singleTarget, context, existingMethodState, invoke.isInvokeMethodWithReceiver() ? invoke.getFirstArgument().getDynamicType(this.appView) : null);
    }

    private ConcreteMonomorphicMethodStateOrUnknown computeMonomorphicMethodState(InvokeMethod invoke, ProgramMethod resolvedMethod, ProgramMethod singleTarget, ProgramMethod context, ConcreteMonomorphicMethodStateOrBottom existingMethodState, DynamicType dynamicReceiverType) {
        ArrayList<ParameterState> parameterStates = new ArrayList<ParameterState>(invoke.arguments().size());
        MethodReprocessingCriteria methodReprocessingCriteria = singleTarget != null ? this.reprocessingCriteriaCollection.getReprocessingCriteria(singleTarget) : MethodReprocessingCriteria.alwaysReprocess();
        int argumentIndex = 0;
        if (invoke.isInvokeMethodWithReceiver()) {
            assert (dynamicReceiverType != null);
            parameterStates.add(this.computeParameterStateForReceiver(invoke.asInvokeMethodWithReceiver(), resolvedMethod, dynamicReceiverType, existingMethodState, methodReprocessingCriteria.getParameterReprocessingCriteria(0)));
            ++argumentIndex;
        }
        while (argumentIndex < invoke.arguments().size()) {
            parameterStates.add(this.computeParameterStateForNonReceiver(invoke, argumentIndex, invoke.getArgument(argumentIndex), context, existingMethodState, methodReprocessingCriteria.getParameterReprocessingCriteria(argumentIndex)));
            ++argumentIndex;
        }
        boolean isReturnValueUsed = invoke.getReturnType().isVoidType() || invoke.hasUsedOutValue();
        return ConcreteMonomorphicMethodState.create(isReturnValueUsed, parameterStates);
    }

    private ParameterState computeParameterStateForReceiver(InvokeMethodWithReceiver invoke, ProgramMethod resolvedMethod, DynamicType dynamicReceiverType, ConcreteMonomorphicMethodStateOrBottom existingMethodState, ParameterReprocessingCriteria parameterReprocessingCriteria) {
        if (existingMethodState.isMonomorphic() && existingMethodState.asMonomorphic().getParameterState(0).isUnknown()) {
            return ParameterState.unknown();
        }
        if (!parameterReprocessingCriteria.shouldReprocessDueToDynamicType()) {
            return ParameterState.unknown();
        }
        DynamicType widenedDynamicReceiverType = WideningUtils.widenDynamicReceiverType(this.appView, resolvedMethod, dynamicReceiverType);
        return widenedDynamicReceiverType.isUnknown() ? ParameterState.unknown() : new ConcreteReceiverParameterState(dynamicReceiverType);
    }

    private ParameterState computeParameterStateForNonReceiver(InvokeMethod invoke, int argumentIndex, Value argument, ProgramMethod context, ConcreteMonomorphicMethodStateOrBottom existingMethodState, ParameterReprocessingCriteria parameterReprocessingCriteria) {
        if (existingMethodState.isMonomorphic() && existingMethodState.asMonomorphic().getParameterState(argumentIndex).isUnknown()) {
            return ParameterState.unknown();
        }
        Value argumentRoot = argument.getAliasedValue(aliasedValueConfiguration);
        DexType parameterType = invoke.getInvokedMethod().getArgumentType(argumentIndex, invoke.isInvokeStatic());
        TypeElement parameterTypeElement = parameterType.toTypeElement(this.appView);
        if (argumentRoot.isArgument()) {
            MethodParameter forwardedParameter = this.methodParameterFactory.create(context, argumentRoot.getDefinition().asArgument().getIndex());
            if (this.isMethodParameterAlreadyUnknown(forwardedParameter, context)) {
                return ParameterState.unknown();
            }
            if (parameterTypeElement.isClassType()) {
                return new ConcreteClassTypeParameterState(forwardedParameter);
            }
            if (parameterTypeElement.isArrayType()) {
                return new ConcreteArrayTypeParameterState(forwardedParameter);
            }
            assert (parameterTypeElement.isPrimitiveType());
            return new ConcretePrimitiveTypeParameterState(forwardedParameter);
        }
        if (parameterTypeElement.isArrayType()) {
            Nullability nullability = argument.getType().nullability();
            return nullability.isMaybeNull() ? ParameterState.unknown() : new ConcreteArrayTypeParameterState(nullability);
        }
        AbstractValue abstractValue = argument.getAbstractValue(this.appView, context);
        if (parameterTypeElement.isClassType()) {
            DynamicTypeWithUpperBound dynamicType = argument.getDynamicType(this.appView);
            DynamicType widenedDynamicType = WideningUtils.widenDynamicNonReceiverType(this.appView, dynamicType, parameterType);
            return abstractValue.isUnknown() && widenedDynamicType.isUnknown() ? ParameterState.unknown() : new ConcreteClassTypeParameterState(abstractValue, widenedDynamicType);
        }
        assert (parameterTypeElement.isPrimitiveType());
        return abstractValue.isUnknown() ? ParameterState.unknown() : new ConcretePrimitiveTypeParameterState(abstractValue);
    }

    private DexMethod getRepresentative(InvokeMethod invoke, ProgramMethod resolvedMethod) {
        if (((DexEncodedMethod)resolvedMethod.getDefinition()).belongsToDirectPool()) {
            return (DexMethod)resolvedMethod.getReference();
        }
        if (invoke.isInvokeInterface()) {
            assert (!this.isMonomorphicVirtualMethod(resolvedMethod));
            return this.getVirtualRootMethod(resolvedMethod);
        }
        assert (invoke.isInvokeSuper() || invoke.isInvokeVirtual());
        if (this.isMonomorphicVirtualMethod(resolvedMethod)) {
            return (DexMethod)resolvedMethod.getReference();
        }
        DexMethod rootMethod = this.getVirtualRootMethod(resolvedMethod);
        assert (rootMethod != null);
        assert (!this.isMonomorphicVirtualMethod(resolvedMethod) || rootMethod == resolvedMethod.getReference());
        return rootMethod;
    }

    private boolean shouldUsePolymorphicMethodState(InvokeMethod invoke, ProgramMethod resolvedMethod) {
        return !((DexEncodedMethod)resolvedMethod.getDefinition()).belongsToDirectPool() && !this.isMonomorphicVirtualMethod(this.getRepresentative(invoke, resolvedMethod));
    }

    private void scan(InvokeCustom invoke, ProgramMethod context) {
        DexMethodHandle bootstrapMethod = invoke.getCallSite().bootstrapMethod;
        MethodResolutionResult.SingleResolutionResult resolution = this.appView.appInfo().resolveMethod(bootstrapMethod.asMethod(), bootstrapMethod.isInterface).asSingleResolution();
        if (resolution != null && resolution.getResolvedHolder().isProgramClass()) {
            this.methodStates.set(resolution.getResolvedProgramMethod(), UnknownMethodState.get());
        }
    }

    public synchronized void addMonomorphicVirtualMethods(Set<DexMethod> extension) {
        this.monomorphicVirtualMethods.addAll(extension);
    }

    public synchronized void addVirtualRootMethods(Map<DexMethod, DexMethod> extension) {
        this.virtualRootMethods.putAll(extension);
    }

    MethodStateCollectionByReference getMethodStates() {
        return this.methodStates;
    }

    DexMethod getVirtualRootMethod(ProgramMethod method) {
        return this.virtualRootMethods.get(method.getReference());
    }

    boolean isMethodParameterAlreadyUnknown(MethodParameter methodParameter, ProgramMethod method) {
        MethodState methodState = this.methodStates.get(((DexEncodedMethod)method.getDefinition()).belongsToDirectPool() || this.isMonomorphicVirtualMethod(method) ? (DexMethod)method.getReference() : this.getVirtualRootMethod(method));
        if (methodState.isPolymorphic()) {
            methodState = methodState.asPolymorphic().getMethodStateForBounds(DynamicType.unknown());
        }
        if (methodState.isMonomorphic()) {
            ParameterState parameterState = methodState.asMonomorphic().getParameterState(methodParameter.getIndex());
            return parameterState.isUnknown();
        }
        assert (methodState.isBottom() || methodState.isUnknown());
        return methodState.isUnknown();
    }

    boolean isMonomorphicVirtualMethod(ProgramMethod method) {
        boolean isMonomorphicVirtualMethod = this.isMonomorphicVirtualMethod((DexMethod)method.getReference());
        assert (((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool() || !isMonomorphicVirtualMethod);
        return isMonomorphicVirtualMethod;
    }

    boolean isMonomorphicVirtualMethod(DexMethod method) {
        return this.monomorphicVirtualMethods.contains(method);
    }

    void scan(ProgramMethod method, IRCode code, Timing timing) {
        timing.begin("Argument propagation scanner");
        for (Invoke invoke : code.instructions(Instruction::isInvoke)) {
            if (invoke.isInvokeMethod()) {
                this.scan(invoke.asInvokeMethod(), method, timing);
                continue;
            }
            if (!invoke.isInvokeCustom()) continue;
            this.scan(invoke.asInvokeCustom(), method);
        }
        timing.end();
    }
}

