/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.NestedGraphLens;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneHashMap;
import com.android.tools.r8.utils.collections.BidirectionalOneToOneMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalOneToOneMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class ArgumentPropagatorGraphLens
extends NestedGraphLens {
    private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges;

    ArgumentPropagatorGraphLens(AppView<AppInfoWithLiveness> appView, BidirectionalOneToOneMap<DexField, DexField> fieldMap, BidirectionalOneToOneMap<DexMethod, DexMethod> methodMap, Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges) {
        super(appView, fieldMap, methodMap, EMPTY_TYPE_MAP);
        this.prototypeChanges = prototypeChanges;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView) {
        return new Builder(appView);
    }

    @Override
    public boolean isArgumentPropagatorGraphLens() {
        return true;
    }

    public boolean hasPrototypeChanges(DexMethod method) {
        return this.prototypeChanges.containsKey(method);
    }

    public RewrittenPrototypeDescription getPrototypeChanges(DexMethod method) {
        assert (this.hasPrototypeChanges(method));
        return this.prototypeChanges.getOrDefault(method, RewrittenPrototypeDescription.none());
    }

    @Override
    protected boolean isLegitimateToHaveEmptyMappings() {
        return true;
    }

    @Override
    protected GraphLens.FieldLookupResult internalDescribeLookupField(GraphLens.FieldLookupResult previous) {
        GraphLens.FieldLookupResult lookupResult = super.internalDescribeLookupField(previous);
        if (((DexField)lookupResult.getReference()).getType() != ((DexField)previous.getReference()).getType()) {
            return ((GraphLens.FieldLookupResult.Builder)((GraphLens.FieldLookupResult.Builder)GraphLens.FieldLookupResult.builder(this).setReboundReference((DexField)lookupResult.getReboundReference())).setReference((DexField)lookupResult.getReference())).setReadCastType(lookupResult.getReadCastType()).setWriteCastType(((DexField)lookupResult.getReference()).getType()).build();
        }
        return lookupResult;
    }

    @Override
    protected RewrittenPrototypeDescription internalDescribePrototypeChanges(RewrittenPrototypeDescription prototypeChanges, DexMethod method) {
        DexMethod previous = this.getPreviousMethodSignature(method);
        if (!this.hasPrototypeChanges(method)) {
            return prototypeChanges;
        }
        RewrittenPrototypeDescription newPrototypeChanges = prototypeChanges.combine(this.getPrototypeChanges(method));
        assert (previous.getReturnType().isVoidType() || !method.getReturnType().isVoidType() || newPrototypeChanges.hasRewrittenReturnInfo());
        return newPrototypeChanges;
    }

    @Override
    public DexMethod getPreviousMethodSignature(DexMethod method) {
        return super.getPreviousMethodSignature(method);
    }

    @Override
    public DexField internalGetNextFieldSignature(DexField field) {
        return super.internalGetNextFieldSignature(field);
    }

    @Override
    public DexMethod getNextMethodSignature(DexMethod method) {
        return super.getNextMethodSignature(method);
    }

    @Override
    protected Invoke.Type mapInvocationType(DexMethod newMethod, DexMethod originalMethod, Invoke.Type type) {
        return this.hasPrototypeChanges(newMethod) && this.getPrototypeChanges(newMethod).getArgumentInfoCollection().isConvertedToStaticMethod() ? Invoke.Type.STATIC : super.mapInvocationType(newMethod, originalMethod, type);
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private final MutableBidirectionalOneToOneMap<DexField, DexField> newFieldSignatures = new BidirectionalOneToOneHashMap<DexField, DexField>();
        private final MutableBidirectionalOneToOneMap<DexMethod, DexMethod> newMethodSignatures = new BidirectionalOneToOneHashMap<DexMethod, DexMethod>();
        private final Map<DexMethod, RewrittenPrototypeDescription> prototypeChanges = new IdentityHashMap<DexMethod, RewrittenPrototypeDescription>();

        Builder(AppView<AppInfoWithLiveness> appView) {
            this.appView = appView;
        }

        private void fixupPrototypeChangesAfterFieldSignatureChanges(ArgumentPropagatorGraphLens argumentPropagatorGraphLens) {
            for (Map.Entry<DexMethod, RewrittenPrototypeDescription> entry : this.prototypeChanges.entrySet()) {
                RewrittenPrototypeDescription prototypeChangesForMethod = entry.getValue();
                RewrittenPrototypeDescription rewrittenPrototypeChangesForMethod = prototypeChangesForMethod.rewrittenWithLens(this.appView, argumentPropagatorGraphLens, argumentPropagatorGraphLens.getPrevious());
                if (rewrittenPrototypeChangesForMethod == prototypeChangesForMethod) continue;
                entry.setValue(rewrittenPrototypeChangesForMethod);
            }
        }

        public boolean isEmpty() {
            return this.newFieldSignatures.isEmpty() && this.newMethodSignatures.isEmpty() && this.prototypeChanges.isEmpty();
        }

        public Builder mergeDisjoint(Builder partialGraphLensBuilder) {
            this.newFieldSignatures.putAll(partialGraphLensBuilder.newFieldSignatures);
            this.newMethodSignatures.putAll(partialGraphLensBuilder.newMethodSignatures);
            this.prototypeChanges.putAll(partialGraphLensBuilder.prototypeChanges);
            return this;
        }

        public Builder recordMove(DexField from, DexField to) {
            assert (from != to);
            this.newFieldSignatures.put(from, to);
            return this;
        }

        public Builder recordMove(DexMethod from, DexMethod to, RewrittenPrototypeDescription prototypeChangesForMethod) {
            assert (from != to);
            this.newMethodSignatures.put(from, to);
            if (!prototypeChangesForMethod.isEmpty()) {
                this.prototypeChanges.put(to, prototypeChangesForMethod);
            }
            assert (from.getReturnType().isVoidType() || !to.getReturnType().isVoidType() || prototypeChangesForMethod.hasRewrittenReturnInfo());
            return this;
        }

        public Builder recordStaticized(DexMethod method, RewrittenPrototypeDescription prototypeChangesForMethod) {
            this.prototypeChanges.put(method, prototypeChangesForMethod);
            return this;
        }

        public ArgumentPropagatorGraphLens build() {
            if (this.isEmpty()) {
                return null;
            }
            ArgumentPropagatorGraphLens argumentPropagatorGraphLens = new ArgumentPropagatorGraphLens(this.appView, (BidirectionalOneToOneMap<DexField, DexField>)this.newFieldSignatures, (BidirectionalOneToOneMap<DexMethod, DexMethod>)this.newMethodSignatures, this.prototypeChanges);
            this.fixupPrototypeChangesAfterFieldSignatureChanges(argumentPropagatorGraphLens);
            return argumentPropagatorGraphLens;
        }
    }
}

