/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.UseRegistryWithResult;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorGraphLens;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ArgumentPropagatorReprocessingCriteriaCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

public class ArgumentPropagatorMethodReprocessingEnqueuer {
    private final AppView<AppInfoWithLiveness> appView;
    private final ArgumentPropagatorReprocessingCriteriaCollection reprocessingCriteriaCollection;

    public ArgumentPropagatorMethodReprocessingEnqueuer(AppView<AppInfoWithLiveness> appView, ArgumentPropagatorReprocessingCriteriaCollection reprocessingCriteriaCollection) {
        this.appView = appView;
        this.reprocessingCriteriaCollection = reprocessingCriteriaCollection;
    }

    private void enqueueAffectedCallees(ArgumentPropagatorGraphLens graphLens, PostMethodProcessor.Builder postMethodProcessorBuilder) {
        GraphLens currentGraphLens = this.appView.graphLens();
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> {
                DexMethod rewrittenMethodSignature;
                if (((DexEncodedMethod)method.getDefinition()).getCode().isSharedCodeObject()) {
                    return;
                }
                if (graphLens != null && graphLens.hasPrototypeChanges(rewrittenMethodSignature = graphLens.getNextMethodSignature((DexMethod)method.getReference()))) {
                    assert (!this.appView.appInfo().isNeverReprocessMethod((ProgramMethod)method));
                    postMethodProcessorBuilder.add((ProgramMethod)method, currentGraphLens);
                    this.appView.testing().callSiteOptimizationInfoInspector.accept((ProgramMethod)method);
                    return;
                }
                CallSiteOptimizationInfo callSiteOptimizationInfo = method.getOptimizationInfo().getArgumentInfos();
                if (this.reprocessingCriteriaCollection.getReprocessingCriteria((ProgramMethod)method).shouldReprocess(this.appView, (ProgramMethod)method, callSiteOptimizationInfo) && !this.appView.appInfo().isNeverReprocessMethod((ProgramMethod)method)) {
                    postMethodProcessorBuilder.add((ProgramMethod)method, currentGraphLens);
                    this.appView.testing().callSiteOptimizationInfoInspector.accept((ProgramMethod)method);
                }
            });
        }
    }

    private void enqueueAffectedCallers(ArgumentPropagatorGraphLens graphLens, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService) throws ExecutionException {
        GraphLens currentGraphLens = this.appView.graphLens();
        Collection<List> methodsToReprocess = ThreadUtils.processItemsWithResults(this.appView.appInfo().classes(), clazz -> {
            ArrayList methodsToReprocessInClass = new ArrayList();
            clazz.forEachProgramMethodMatching(DexEncodedMethod::hasCode, method -> {
                AffectedMethodUseRegistry registry;
                if (!postMethodProcessorBuilder.contains((ProgramMethod)method, currentGraphLens) && method.registerCodeReferencesWithResult(registry = new AffectedMethodUseRegistry(this.appView, (ProgramMethod)method, graphLens)).booleanValue()) {
                    assert (!method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite());
                    methodsToReprocessInClass.add(method);
                }
            });
            return methodsToReprocessInClass;
        }, executorService);
        methodsToReprocess.forEach(methodsToReprocessInClass -> postMethodProcessorBuilder.addAll((Collection<ProgramMethod>)methodsToReprocessInClass, currentGraphLens));
    }

    public void enqueueMethodForReprocessing(ArgumentPropagatorGraphLens graphLens, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Enqueue methods for reprocessing");
        timing.begin("Rewrite methods to reprocess");
        postMethodProcessorBuilder.rewrittenWithLens(this.appView);
        timing.end();
        timing.begin("Enqueue methods with non-trivial info");
        this.enqueueAffectedCallees(graphLens, postMethodProcessorBuilder);
        timing.end();
        timing.begin("Enqueue affected methods");
        if (graphLens != null) {
            this.enqueueAffectedCallers(graphLens, postMethodProcessorBuilder, executorService);
        }
        timing.end();
        timing.end();
    }

    static class AffectedMethodUseRegistry
    extends UseRegistryWithResult<Boolean, ProgramMethod> {
        private final AppView<AppInfoWithLiveness> appView;
        private final ArgumentPropagatorGraphLens graphLens;

        AffectedMethodUseRegistry(AppView<AppInfoWithLiveness> appView, ProgramMethod context, ArgumentPropagatorGraphLens graphLens) {
            super(appView, context, false);
            this.appView = appView;
            this.graphLens = graphLens;
        }

        private void markAffected() {
            this.setResult(Boolean.TRUE);
        }

        private void registerInvokeMethod(DexMethod method) {
            MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(method).asSingleResolution();
            if (resolutionResult == null || !resolutionResult.getResolvedHolder().isProgramClass()) {
                return;
            }
            ProgramMethod resolvedMethod = resolutionResult.getResolvedProgramMethod();
            DexMethod rewrittenMethodReference = this.graphLens.getNextMethodSignature((DexMethod)resolvedMethod.getReference());
            if (rewrittenMethodReference != resolvedMethod.getReference() || this.graphLens.hasPrototypeChanges(rewrittenMethodReference)) {
                this.markAffected();
            }
        }

        private void registerFieldAccess(DexField field) {
            FieldResolutionResult resolutionResult = this.appView.appInfo().resolveField(field);
            if (resolutionResult.getSingleProgramField() == null) {
                return;
            }
            ProgramField resolvedField = resolutionResult.getSingleProgramField();
            DexField rewrittenFieldReference = this.graphLens.internalGetNextFieldSignature((DexField)resolvedField.getReference());
            if (rewrittenFieldReference != resolvedField.getReference()) {
                this.markAffected();
            }
        }

        @Override
        public void registerInvokeDirect(DexMethod method) {
            this.registerInvokeMethod(method);
        }

        @Override
        public void registerInvokeInterface(DexMethod method) {
            this.registerInvokeMethod(method);
        }

        @Override
        public void registerInvokeStatic(DexMethod method) {
            this.registerInvokeMethod(method);
        }

        @Override
        public void registerInvokeSuper(DexMethod method) {
            this.registerInvokeMethod(method);
        }

        @Override
        public void registerInvokeVirtual(DexMethod method) {
            this.registerInvokeMethod(method);
        }

        @Override
        public void registerInstanceFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerInstanceFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldRead(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerStaticFieldWrite(DexField field) {
            this.registerFieldAccess(field);
        }

        @Override
        public void registerInitClass(DexType type) {
        }

        @Override
        public void registerTypeReference(DexType type) {
        }
    }
}

