/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RemovedArgumentInfo;
import com.android.tools.r8.graph.proto.RemovedReceiverInfo;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.graph.proto.RewrittenTypeInfo;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleValue;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.ConcreteCallSiteOptimizationInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMaps;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArraySet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSet;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntSets;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorGraphLens;
import com.android.tools.r8.optimize.argumentpropagation.utils.ParameterRemovalUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepFieldInfo;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.AccessUtils;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.IntBox;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.Pair;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.DexMethodSignatureSet;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;

public class ArgumentPropagatorProgramOptimizer {
    private final AppView<AppInfoWithLiveness> appView;
    private final ImmediateProgramSubtypingInfo immediateSubtypingInfo;
    private final Map<Set<DexProgramClass>, DexMethodSignatureSet> interfaceDispatchOutsideProgram;
    private final Map<DexClass, DexMethodSignatureSet> libraryVirtualMethods = new ConcurrentHashMap<DexClass, DexMethodSignatureSet>();

    public ArgumentPropagatorProgramOptimizer(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo, Map<Set<DexProgramClass>, DexMethodSignatureSet> interfaceDispatchOutsideProgram) {
        this.appView = appView;
        this.immediateSubtypingInfo = immediateSubtypingInfo;
        this.interfaceDispatchOutsideProgram = interfaceDispatchOutsideProgram;
    }

    private DexMethodSignatureSet getOrComputeLibraryVirtualMethods(DexClass clazz) {
        DexMethodSignatureSet libraryMethodsOnClass = this.libraryVirtualMethods.get(clazz);
        if (libraryMethodsOnClass != null) {
            return libraryMethodsOnClass;
        }
        return this.computeLibraryVirtualMethods(clazz);
    }

    private DexMethodSignatureSet computeLibraryVirtualMethods(DexClass clazz) {
        DexMethodSignatureSet libraryMethodsOnClass = DexMethodSignatureSet.create();
        this.immediateSubtypingInfo.forEachImmediateSuperClassMatching(clazz, (supertype, superclass) -> superclass != null, (supertype, superclass) -> libraryMethodsOnClass.addAll(this.getOrComputeLibraryVirtualMethods((DexClass)superclass)));
        clazz.forEachClassMethodMatching(DexEncodedMethod::belongsToVirtualPool, method -> libraryMethodsOnClass.add(method.getMethodSignature()));
        this.libraryVirtualMethods.put(clazz, libraryMethodsOnClass);
        return libraryMethodsOnClass;
    }

    public ArgumentPropagatorGraphLens run(List<Set<DexProgramClass>> stronglyConnectedProgramComponents, Consumer<DexProgramClass> affectedClassConsumer, ExecutorService executorService, Timing timing) throws ExecutionException {
        timing.begin("Optimize components");
        CompilationContext.ProcessorContext processorContext = this.appView.createProcessorContext();
        Collection<ArgumentPropagatorGraphLens.Builder> partialGraphLensBuilders = ThreadUtils.processItemsWithResults(stronglyConnectedProgramComponents, classes -> new StronglyConnectedComponentOptimizer(processorContext).optimize(classes, this.interfaceDispatchOutsideProgram.getOrDefault(classes, DexMethodSignatureSet.empty()), affectedClassConsumer), executorService);
        timing.end();
        timing.begin("Build graph lens");
        ArgumentPropagatorGraphLens.Builder graphLensBuilder = ArgumentPropagatorGraphLens.builder(this.appView);
        partialGraphLensBuilders.forEach(graphLensBuilder::mergeDisjoint);
        ArgumentPropagatorGraphLens graphLens = graphLensBuilder.build();
        timing.end();
        return graphLens;
    }

    public class StronglyConnectedComponentOptimizer {
        private final DexItemFactory dexItemFactory;
        private final InternalOptions options;
        private final InternalOptions.CallSiteOptimizationOptions callSiteOptimizationOptions;
        private final Map<DexMethodSignature, AllowedPrototypeChanges> allowedPrototypeChangesForVirtualMethods;
        private final ProgramMethodMap<SingleValue> returnValuesForVirtualMethods;
        private final Map<DexMethodSignature, Map<AllowedPrototypeChanges, DexMethodSignature>> newMethodSignatures;
        private final Map<DexMethodSignature, IntBox> newMethodSignatureSuffixes;
        private final Map<DexMethodSignature, Pair<AllowedPrototypeChanges, DexMethodSignature>> occupiedMethodSignatures;
        private final CompilationContext.ProcessorContext processorContext;

        public StronglyConnectedComponentOptimizer(CompilationContext.ProcessorContext processorContext) {
            this.dexItemFactory = ArgumentPropagatorProgramOptimizer.this.appView.dexItemFactory();
            this.options = ArgumentPropagatorProgramOptimizer.this.appView.options();
            this.callSiteOptimizationOptions = ArgumentPropagatorProgramOptimizer.this.appView.options().callSiteOptimizationOptions();
            this.allowedPrototypeChangesForVirtualMethods = new HashMap<DexMethodSignature, AllowedPrototypeChanges>();
            this.returnValuesForVirtualMethods = ProgramMethodMap.create();
            this.newMethodSignatures = new HashMap<DexMethodSignature, Map<AllowedPrototypeChanges, DexMethodSignature>>();
            this.newMethodSignatureSuffixes = new HashMap<DexMethodSignature, IntBox>();
            this.occupiedMethodSignatures = new HashMap<DexMethodSignature, Pair<AllowedPrototypeChanges, DexMethodSignature>>();
            this.processorContext = processorContext;
        }

        private ArgumentPropagatorGraphLens.Builder optimize(Set<DexProgramClass> stronglyConnectedProgramClasses, DexMethodSignatureSet interfaceDispatchOutsideProgram, Consumer<DexProgramClass> affectedClassConsumer) {
            this.reservePinnedMethodSignatures(stronglyConnectedProgramClasses);
            this.computePrototypeChangesForVirtualMethods(stronglyConnectedProgramClasses, interfaceDispatchOutsideProgram);
            ArgumentPropagatorGraphLens.Builder partialGraphLensBuilder = ArgumentPropagatorGraphLens.builder(ArgumentPropagatorProgramOptimizer.this.appView);
            ArrayList<DexProgramClass> stronglyConnectedProgramClassesWithDeterministicOrder = new ArrayList<DexProgramClass>(stronglyConnectedProgramClasses);
            stronglyConnectedProgramClassesWithDeterministicOrder.sort(Comparator.comparing(DexClass::getType));
            for (DexProgramClass clazz : stronglyConnectedProgramClassesWithDeterministicOrder) {
                if (!this.visitClass(clazz, interfaceDispatchOutsideProgram, partialGraphLensBuilder)) continue;
                affectedClassConsumer.accept(clazz);
            }
            return partialGraphLensBuilder;
        }

        private void reservePinnedMethodSignatures(Set<DexProgramClass> stronglyConnectedProgramClasses) {
            DexMethodSignatureSet pinnedMethodSignatures = DexMethodSignatureSet.create();
            Set seenLibraryClasses = Sets.newIdentityHashSet();
            for (DexProgramClass clazz : stronglyConnectedProgramClasses) {
                clazz.forEachProgramMethodMatching(method -> !method.isInstanceInitializer(), method -> {
                    KeepMethodInfo keepInfo = ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo((ProgramMethod)method);
                    if (!keepInfo.isOptimizationAllowed(this.options) || !keepInfo.isShrinkingAllowed(this.options)) {
                        pinnedMethodSignatures.add(method.getMethodSignature());
                    }
                });
                ArgumentPropagatorProgramOptimizer.this.immediateSubtypingInfo.forEachImmediateSuperClassMatching((DexClass)clazz, (supertype, superclass) -> superclass != null && !superclass.isProgramClass() && seenLibraryClasses.add(superclass), (supertype, superclass) -> pinnedMethodSignatures.addAll(ArgumentPropagatorProgramOptimizer.this.getOrComputeLibraryVirtualMethods(superclass)));
            }
            pinnedMethodSignatures.forEach(signature -> this.reserveMethodSignature((DexMethodSignature)signature, (DexMethodSignature)signature, AllowedPrototypeChanges.empty()));
        }

        private void reserveMethodSignature(DexMethodSignature newMethodSignature, DexMethodSignature originalMethodSignature, AllowedPrototypeChanges allowedPrototypeChanges) {
            ((Map)this.newMethodSignatures.computeIfAbsent(originalMethodSignature, MapUtils.ignoreKey(HashMap::new))).put(allowedPrototypeChanges, newMethodSignature);
            this.occupiedMethodSignatures.put(newMethodSignature, new Pair<AllowedPrototypeChanges, DexMethodSignature>(allowedPrototypeChanges, originalMethodSignature));
        }

        private void computePrototypeChangesForVirtualMethods(Set<DexProgramClass> stronglyConnectedProgramClasses, DexMethodSignatureSet interfaceDispatchOutsideProgram) {
            Map<DexMethodSignature, ProgramMethodSet> virtualMethodsBySignature = this.computeVirtualMethodsBySignature(stronglyConnectedProgramClasses);
            virtualMethodsBySignature.forEach((signature, methods) -> {
                if (Iterables.any(methods, method -> !this.isPrototypeChangesAllowed((ProgramMethod)method, interfaceDispatchOutsideProgram))) {
                    return;
                }
                if (this.containsImmediateInterfaceOfInstantiatedLambda((ProgramMethodSet)methods)) {
                    return;
                }
                Int2ReferenceOpenHashMap<DexType> newParameterTypes = new Int2ReferenceOpenHashMap<DexType>();
                IntArraySet removableVirtualMethodParametersInAllMethods = new IntArraySet();
                for (int parameterIndex = 0; parameterIndex < signature.getProto().getArity() + 1; ++parameterIndex) {
                    if (this.canRemoveParameterFromVirtualMethods((ProgramMethodSet)methods, parameterIndex)) {
                        removableVirtualMethodParametersInAllMethods.add(parameterIndex);
                        continue;
                    }
                    DexType newParameterType = this.getNewParameterTypeForVirtualMethods((ProgramMethodSet)methods, parameterIndex);
                    if (newParameterType == null) continue;
                    newParameterTypes.put(parameterIndex, newParameterType);
                }
                SingleValue returnValueForVirtualMethods = this.getReturnValueForVirtualMethods((ProgramMethodSet)methods, (DexMethodSignature)signature);
                DexType newReturnType = this.getNewReturnTypeForVirtualMethods((ProgramMethodSet)methods, returnValueForVirtualMethods);
                if (newReturnType != null || !newParameterTypes.isEmpty() || !removableVirtualMethodParametersInAllMethods.isEmpty()) {
                    this.allowedPrototypeChangesForVirtualMethods.put((DexMethodSignature)signature, new AllowedPrototypeChanges(newReturnType, newParameterTypes, removableVirtualMethodParametersInAllMethods));
                }
                if (newReturnType == this.dexItemFactory.voidType && returnValueForVirtualMethods != null) {
                    for (ProgramMethod method2 : methods) {
                        if (!method2.getAccessFlags().isAbstract()) continue;
                        this.returnValuesForVirtualMethods.put(method2, returnValueForVirtualMethods);
                    }
                }
            });
        }

        private Map<DexMethodSignature, ProgramMethodSet> computeVirtualMethodsBySignature(Set<DexProgramClass> stronglyConnectedProgramClasses) {
            HashMap<DexMethodSignature, ProgramMethodSet> virtualMethodsBySignature = new HashMap<DexMethodSignature, ProgramMethodSet>();
            for (DexProgramClass clazz : stronglyConnectedProgramClasses) {
                clazz.forEachProgramVirtualMethod(method -> virtualMethodsBySignature.computeIfAbsent(method.getMethodSignature(), MapUtils.ignoreKey(ProgramMethodSet::create)).add(method));
            }
            return virtualMethodsBySignature;
        }

        private boolean isPrototypeChangesAllowed(ProgramMethod method, DexMethodSignatureSet interfaceDispatchOutsideProgram) {
            return ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo(method).isParameterRemovalAllowed(this.options) && !((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isPossiblyTrue() && !((AppInfoWithLiveness)ArgumentPropagatorProgramOptimizer.this.appView.appInfo()).isBootstrapMethod(method) && !interfaceDispatchOutsideProgram.contains(method);
        }

        private SingleValue getReturnValueForVirtualMethods(ProgramMethodSet methods, DexMethodSignature signature) {
            if (signature.getReturnType().isVoidType()) {
                return null;
            }
            SingleValue returnValue = null;
            for (ProgramMethod method : methods) {
                AbstractValue returnValueForMethod;
                if (((DexEncodedMethod)method.getDefinition()).isAbstract()) continue;
                if (!((AppInfoWithLiveness)ArgumentPropagatorProgramOptimizer.this.appView.appInfo()).mayPropagateValueFor((AppView<AppInfoWithLiveness>)ArgumentPropagatorProgramOptimizer.this.appView, method)) {
                    return null;
                }
                AbstractValue abstractValue = returnValueForMethod = method.getReturnType().isAlwaysNull(ArgumentPropagatorProgramOptimizer.this.appView) ? ArgumentPropagatorProgramOptimizer.this.appView.abstractValueFactory().createNullValue() : method.getOptimizationInfo().getAbstractReturnValue();
                if (!returnValueForMethod.isSingleValue() || !returnValueForMethod.asSingleValue().isMaterializableInAllContexts(ArgumentPropagatorProgramOptimizer.this.appView) || returnValue != null && !returnValueForMethod.equals(returnValue)) {
                    return null;
                }
                returnValue = returnValueForMethod.asSingleValue();
            }
            return returnValue;
        }

        private boolean containsImmediateInterfaceOfInstantiatedLambda(ProgramMethodSet methods) {
            for (ProgramMethod method : methods) {
                ObjectAllocationInfoCollection objectAllocationInfoCollection;
                DexProgramClass holder = method.getHolder();
                if (!holder.isInterface() || !(objectAllocationInfoCollection = ((AppInfoWithLiveness)ArgumentPropagatorProgramOptimizer.this.appView.appInfo()).getObjectAllocationInfoCollection()).isImmediateInterfaceOfInstantiatedLambda(holder)) continue;
                return true;
            }
            return false;
        }

        private boolean canRemoveParameterFromVirtualMethods(ProgramMethodSet methods, int parameterIndex) {
            if (parameterIndex == 0) {
                if (methods.size() > 1) {
                    return false;
                }
                ProgramMethod method = (ProgramMethod)methods.getFirst();
                return method.getOptimizationInfo().hasUnusedArguments() && method.getOptimizationInfo().getUnusedArguments().get(parameterIndex) && ParameterRemovalUtils.canRemoveUnusedParametersFrom(ArgumentPropagatorProgramOptimizer.this.appView, method) && ParameterRemovalUtils.canRemoveUnusedParameter(ArgumentPropagatorProgramOptimizer.this.appView, method, parameterIndex);
            }
            for (ProgramMethod method : methods) {
                ConcreteCallSiteOptimizationInfo concreteOptimizationInfo;
                AbstractValue abstractValue;
                CallSiteOptimizationInfo optimizationInfo;
                if (((DexEncodedMethod)method.getDefinition()).isAbstract() || method.getOptimizationInfo().hasUnusedArguments() && method.getOptimizationInfo().getUnusedArguments().get(parameterIndex) && ParameterRemovalUtils.canRemoveUnusedParametersFrom(ArgumentPropagatorProgramOptimizer.this.appView, method) && ParameterRemovalUtils.canRemoveUnusedParameter(ArgumentPropagatorProgramOptimizer.this.appView, method, parameterIndex) || (optimizationInfo = method.getOptimizationInfo().getArgumentInfos()).isConcreteCallSiteOptimizationInfo() && (abstractValue = (concreteOptimizationInfo = optimizationInfo.asConcreteCallSiteOptimizationInfo()).getAbstractArgumentValue(parameterIndex)).isSingleValue() && abstractValue.asSingleValue().isMaterializableInContext(ArgumentPropagatorProgramOptimizer.this.appView, method)) continue;
                return false;
            }
            return true;
        }

        private DexType getNewReturnTypeForVirtualMethods(ProgramMethodSet methods, SingleValue returnValue) {
            if (returnValue != null || this.isReturnValueUnusedForVirtualMethods(methods)) {
                return this.dexItemFactory.voidType;
            }
            DexType newReturnType = null;
            for (ProgramMethod method : methods) {
                if (((DexEncodedMethod)method.getDefinition()).isAbstract()) continue;
                DexType newReturnTypeForMethod = this.getNewReturnType(method, OptionalBool.UNKNOWN, null);
                if (newReturnTypeForMethod == null || newReturnType != null && newReturnType != newReturnTypeForMethod) {
                    return null;
                }
                newReturnType = newReturnTypeForMethod;
            }
            assert (newReturnType == null || newReturnType != ((ProgramMethod)methods.getFirst()).getReturnType());
            return newReturnType;
        }

        private boolean isReturnValueUnusedForVirtualMethods(ProgramMethodSet methods) {
            ProgramMethod representative = (ProgramMethod)methods.getFirst();
            return !representative.getReturnType().isVoidType() && Iterables.all(methods, method -> ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo((ProgramMethod)method).isUnusedReturnValueOptimizationAllowed(this.options) && method.getOptimizationInfo().isReturnValueUsed().isFalse());
        }

        private DexType getNewParameterTypeForVirtualMethods(ProgramMethodSet methods, int parameterIndex) {
            if (parameterIndex == 0) {
                return null;
            }
            DexType newParameterType = null;
            for (ProgramMethod method : methods) {
                if (method.getAccessFlags().isAbstract()) continue;
                DexType newParameterTypeForMethod = this.getNewParameterType(method, parameterIndex);
                if (newParameterTypeForMethod == null || newParameterType != null && newParameterType != newParameterTypeForMethod) {
                    return null;
                }
                newParameterType = newParameterTypeForMethod;
            }
            assert (newParameterType == null || newParameterType != ((ProgramMethod)methods.getFirst()).getArgumentType(parameterIndex));
            return newParameterType;
        }

        private boolean visitClass(DexProgramClass clazz, DexMethodSignatureSet interfaceDispatchOutsideProgram, ArgumentPropagatorGraphLens.Builder partialGraphLensBuilder) {
            BooleanBox affected = new BooleanBox();
            clazz.forEachProgramFieldMatching(field -> field.getType().isClassType(), field -> {
                DexField newFieldSignature = this.getNewFieldSignature((ProgramField)field);
                if (newFieldSignature != field.getReference()) {
                    partialGraphLensBuilder.recordMove((DexField)field.getReference(), newFieldSignature);
                    affected.set();
                }
            });
            DexMethodSignatureSet instanceInitializerSignatures = DexMethodSignatureSet.create();
            ProgramMethodMap instanceInitializerPrototypeChanges = ProgramMethodMap.create();
            clazz.forEachProgramInstanceInitializer(method -> {
                RewrittenPrototypeDescription prototypeChanges = this.computePrototypeChangesForDirectMethod((ProgramMethod)method, interfaceDispatchOutsideProgram, null);
                if (prototypeChanges.isEmpty()) {
                    instanceInitializerSignatures.add((DexClassAndMethod)method);
                }
                instanceInitializerPrototypeChanges.put(method, prototypeChanges);
            });
            clazz.forEachProgramMethod(method -> {
                DexMethod newMethodSignature;
                RewrittenPrototypeDescription prototypeChanges = instanceInitializerPrototypeChanges.getOrDefault(method, () -> ((DexEncodedMethod)method.getDefinition()).belongsToDirectPool() ? this.computePrototypeChangesForDirectMethod((ProgramMethod)method, interfaceDispatchOutsideProgram, instanceInitializerSignatures) : this.computePrototypeChangesForVirtualMethod((ProgramMethod)method));
                if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                    if (prototypeChanges.isEmpty()) {
                        assert (instanceInitializerSignatures.contains((DexClassAndMethod)method));
                        return;
                    }
                    prototypeChanges = this.selectInitArgumentTypeForInstanceInitializer((ProgramMethod)method, prototypeChanges, instanceInitializerSignatures);
                }
                if ((newMethodSignature = this.getNewMethodSignature((ProgramMethod)method, prototypeChanges)) != method.getReference()) {
                    partialGraphLensBuilder.recordMove((DexMethod)method.getReference(), newMethodSignature, prototypeChanges);
                    affected.set();
                } else if (!prototypeChanges.isEmpty()) {
                    partialGraphLensBuilder.recordStaticized((DexMethod)method.getReference(), prototypeChanges);
                    affected.set();
                }
            });
            return affected.get();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private DexField getNewFieldSignature(ProgramField field) {
            DexType newStaticFieldType;
            DynamicType dynamicType = field.getOptimizationInfo().getDynamicType();
            if (dynamicType.isUnknown()) {
                return (DexField)field.getReference();
            }
            KeepFieldInfo keepInfo = ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo(field);
            assert (!keepInfo.isPinned(this.options));
            if (!keepInfo.isFieldTypeStrengtheningAllowed(this.options)) {
                return (DexField)field.getReference();
            }
            if (dynamicType.isNullType()) {
                return (DexField)field.getReference();
            }
            if (dynamicType.isNotNullType()) {
                return (DexField)field.getReference();
            }
            DynamicTypeWithUpperBound dynamicTypeWithUpperBound = dynamicType.asDynamicTypeWithUpperBound();
            TypeElement dynamicUpperBoundType = dynamicTypeWithUpperBound.getDynamicUpperBoundType();
            assert (dynamicUpperBoundType.isReferenceType());
            ClassTypeElement staticFieldType = field.getType().toTypeElement(ArgumentPropagatorProgramOptimizer.this.appView).asClassType();
            if (dynamicUpperBoundType.equalUpToNullability(staticFieldType)) {
                return (DexField)field.getReference();
            }
            if (!dynamicUpperBoundType.strictlyLessThan(staticFieldType, ArgumentPropagatorProgramOptimizer.this.appView)) {
                assert (this.options.testing.allowTypeErrors);
                return (DexField)field.getReference();
            }
            if (dynamicUpperBoundType.isClassType()) {
                ClassTypeElement dynamicUpperBoundClassType = dynamicUpperBoundType.asClassType();
                if (dynamicUpperBoundClassType.getClassType() == this.dexItemFactory.objectType) {
                    if (!dynamicUpperBoundClassType.getInterfaces().hasSingleKnownInterface()) return (DexField)field.getReference();
                    newStaticFieldType = dynamicUpperBoundClassType.getInterfaces().getSingleKnownInterface();
                } else {
                    newStaticFieldType = dynamicUpperBoundClassType.getClassType();
                }
            } else {
                newStaticFieldType = dynamicUpperBoundType.asArrayType().toDexType(this.dexItemFactory);
            }
            if (AccessUtils.isAccessibleInSameContextsAs(newStaticFieldType, field.getType(), ArgumentPropagatorProgramOptimizer.this.appView)) return ((DexField)field.getReference()).withType(newStaticFieldType, this.dexItemFactory);
            return (DexField)field.getReference();
        }

        private DexMethod getNewMethodSignature(ProgramMethod method, RewrittenPrototypeDescription prototypeChanges) {
            DexMethodSignature methodSignatureWithoutPrototypeChanges = method.getMethodSignature();
            AllowedPrototypeChanges allowedPrototypeChanges = AllowedPrototypeChanges.create(prototypeChanges);
            DexMethodSignature reservedSignature = (DexMethodSignature)this.newMethodSignatures.getOrDefault(methodSignatureWithoutPrototypeChanges, Collections.emptyMap()).get(allowedPrototypeChanges);
            if (reservedSignature != null) {
                return reservedSignature.withHolder(method.getHolderType(), this.dexItemFactory);
            }
            DexMethod methodReferenceWithParametersRemoved = prototypeChanges.rewriteMethod(method, this.dexItemFactory);
            DexMethodSignature methodSignatureWithParametersRemoved = methodReferenceWithParametersRemoved.getSignature();
            if (!this.occupiedMethodSignatures.containsKey(methodSignatureWithParametersRemoved)) {
                if (!((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                    this.reserveMethodSignature(methodSignatureWithParametersRemoved, methodSignatureWithoutPrototypeChanges, allowedPrototypeChanges);
                }
                return methodReferenceWithParametersRemoved;
            }
            Pair<AllowedPrototypeChanges, DexMethodSignature> occupant = this.occupiedMethodSignatures.get(methodSignatureWithParametersRemoved);
            assert (!occupant.getFirst().equals(allowedPrototypeChanges) || !occupant.getSecond().equals(methodSignatureWithoutPrototypeChanges));
            IntBox suffix = this.newMethodSignatureSuffixes.computeIfAbsent(methodSignatureWithParametersRemoved, MapUtils.ignoreKey(IntBox::new));
            DexMethod newMethod = this.dexItemFactory.createFreshMethodNameWithoutHolder(method.getName().toString(), methodReferenceWithParametersRemoved.getProto(), method.getHolderType(), candidate -> {
                suffix.increment();
                return this.isMethodSignatureFresh(candidate.getSignature(), methodSignatureWithoutPrototypeChanges, allowedPrototypeChanges);
            }, suffix.get());
            if (!((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                this.reserveMethodSignature(newMethod.getSignature(), methodSignatureWithoutPrototypeChanges, allowedPrototypeChanges);
            }
            return newMethod;
        }

        private boolean isMethodSignatureFresh(DexMethodSignature signature, DexMethodSignature previous, AllowedPrototypeChanges allowedPrototypeChanges) {
            Pair<AllowedPrototypeChanges, DexMethodSignature> candidateOccupant = this.occupiedMethodSignatures.get(signature);
            if (candidateOccupant == null) {
                return true;
            }
            return candidateOccupant.getFirst().equals(allowedPrototypeChanges) && candidateOccupant.getSecond().equals(previous);
        }

        private RewrittenPrototypeDescription computePrototypeChangesForDirectMethod(ProgramMethod method, DexMethodSignatureSet interfaceDispatchOutsideProgram, DexMethodSignatureSet instanceInitializerSignatures) {
            RewrittenPrototypeDescription prototypeChanges;
            assert (((DexEncodedMethod)method.getDefinition()).belongsToDirectPool());
            RewrittenPrototypeDescription rewrittenPrototypeDescription = prototypeChanges = this.isPrototypeChangesAllowed(method, interfaceDispatchOutsideProgram) ? this.computePrototypeChangesForMethod(method) : RewrittenPrototypeDescription.none();
            if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer() && instanceInitializerSignatures != null) {
                prototypeChanges = this.selectInitArgumentTypeForInstanceInitializer(method, prototypeChanges, instanceInitializerSignatures);
            }
            return prototypeChanges;
        }

        private RewrittenPrototypeDescription selectInitArgumentTypeForInstanceInitializer(ProgramMethod method, RewrittenPrototypeDescription prototypeChanges, DexMethodSignatureSet instanceInitializerSignatures) {
            DexMethod rewrittenMethod = prototypeChanges.rewriteMethod(method, this.dexItemFactory);
            if (instanceInitializerSignatures.add(rewrittenMethod)) {
                return prototypeChanges;
            }
            if (!this.callSiteOptimizationOptions.isForceSyntheticsForInstanceInitializersEnabled()) {
                for (DexType extraArgumentType : ImmutableList.of(this.dexItemFactory.intType, this.dexItemFactory.objectType)) {
                    RewrittenPrototypeDescription candidatePrototypeChanges = prototypeChanges.withExtraParameters(new ExtraUnusedNullParameter(extraArgumentType));
                    rewrittenMethod = candidatePrototypeChanges.rewriteMethod(method, this.dexItemFactory);
                    if (!instanceInitializerSignatures.add(rewrittenMethod)) continue;
                    return candidatePrototypeChanges;
                }
            }
            DexType extraArgumentType = ArgumentPropagatorProgramOptimizer.this.appView.getSyntheticItems().createClass(kinds -> kinds.NON_FIXED_INIT_TYPE_ARGUMENT, this.processorContext.createMethodProcessingContext(method).createUniqueContext(), ArgumentPropagatorProgramOptimizer.this.appView).getType();
            RewrittenPrototypeDescription finalPrototypeChanges = prototypeChanges.withExtraParameters(new ExtraUnusedNullParameter(extraArgumentType));
            boolean added = instanceInitializerSignatures.add(finalPrototypeChanges.rewriteMethod(method, this.dexItemFactory));
            assert (added);
            return finalPrototypeChanges;
        }

        private RewrittenPrototypeDescription computePrototypeChangesForVirtualMethod(ProgramMethod method) {
            AllowedPrototypeChanges allowedPrototypeChanges = this.allowedPrototypeChangesForVirtualMethods.get(method.getMethodSignature());
            if (allowedPrototypeChanges == null) {
                return RewrittenPrototypeDescription.none();
            }
            IntSet removableParameterIndices = allowedPrototypeChanges.removableParameterIndices;
            Int2ReferenceMap<DexType> newParameterTypes = allowedPrototypeChanges.newParameterTypes;
            if (method.getAccessFlags().isAbstract()) {
                return this.computePrototypeChangesForAbstractVirtualMethod(method, allowedPrototypeChanges.newReturnType, newParameterTypes, removableParameterIndices);
            }
            RewrittenPrototypeDescription prototypeChanges = this.computePrototypeChangesForMethod(method, allowedPrototypeChanges.newReturnType, newParameterTypes::get, removableParameterIndices::contains);
            assert (prototypeChanges.getArgumentInfoCollection().numberOfRemovedArguments() == removableParameterIndices.size());
            return prototypeChanges;
        }

        private RewrittenPrototypeDescription computePrototypeChangesForAbstractVirtualMethod(ProgramMethod method, DexType newReturnType, Int2ReferenceMap<DexType> newParameterTypes, IntSet removableParameterIndices) {
            ArgumentInfoCollection.Builder argumentInfoCollectionBuilder = ArgumentInfoCollection.builder().setArgumentInfosSize(((DexEncodedMethod)method.getDefinition()).getNumberOfArguments());
            for (int argumentIndex = 0; argumentIndex < ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments(); ++argumentIndex) {
                if (removableParameterIndices.contains(argumentIndex)) {
                    argumentInfoCollectionBuilder.addArgumentInfo(argumentIndex, ((RemovedArgumentInfo.Builder)RemovedArgumentInfo.builder().setType(method.getArgumentType(argumentIndex))).build());
                    continue;
                }
                if (!newParameterTypes.containsKey(argumentIndex)) continue;
                DexType newParameterType = (DexType)newParameterTypes.get(argumentIndex);
                argumentInfoCollectionBuilder.addArgumentInfo(argumentIndex, RewrittenTypeInfo.builder().setCastType(newParameterType).setOldType(method.getArgumentType(argumentIndex)).setNewType(newParameterType).build());
            }
            return RewrittenPrototypeDescription.create(Collections.emptyList(), this.computeReturnChangesForMethod(method, newReturnType), argumentInfoCollectionBuilder.build());
        }

        private RewrittenPrototypeDescription computePrototypeChangesForMethod(ProgramMethod method) {
            IntFunction<DexType> parameterIndexToParameterType = ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo(method).isParameterTypeStrengtheningAllowed(this.options) ? parameterIndex -> this.getNewParameterType(method, parameterIndex) : parameterIndex -> null;
            return this.computePrototypeChangesForMethod(method, this.getNewReturnType(method), parameterIndexToParameterType, parameterIndex -> true);
        }

        private DexType getNewReturnType(ProgramMethod method) {
            return this.getNewReturnType(method, method.getOptimizationInfo().isReturnValueUsed(), this.getReturnValue(method));
        }

        private DexType getNewReturnType(ProgramMethod method, OptionalBool isReturnValueUsed, SingleValue returnValue) {
            DexType staticType = method.getReturnType();
            if (staticType.isVoidType()) {
                return null;
            }
            if (returnValue != null) {
                return this.dexItemFactory.voidType;
            }
            KeepMethodInfo keepInfo = ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo(method);
            if (keepInfo.isUnusedReturnValueOptimizationAllowed(this.options) && isReturnValueUsed.isFalse()) {
                return this.dexItemFactory.voidType;
            }
            if (!keepInfo.isReturnTypeStrengtheningAllowed(this.options)) {
                return null;
            }
            TypeElement newReturnTypeElement = method.getOptimizationInfo().getDynamicType().getDynamicUpperBoundType(staticType.toTypeElement(ArgumentPropagatorProgramOptimizer.this.appView));
            assert (newReturnTypeElement.isTop() || newReturnTypeElement.lessThanOrEqual(staticType.toTypeElement(ArgumentPropagatorProgramOptimizer.this.appView), ArgumentPropagatorProgramOptimizer.this.appView));
            if (!newReturnTypeElement.isClassType()) {
                assert (newReturnTypeElement.isArrayType() || newReturnTypeElement.isNullType() || newReturnTypeElement.isTop());
                return null;
            }
            DexType newReturnType = newReturnTypeElement.asClassType().toDexType(this.dexItemFactory);
            if (newReturnType == staticType) {
                return null;
            }
            if (!((AppInfoWithLiveness)ArgumentPropagatorProgramOptimizer.this.appView.appInfo()).isSubtype(newReturnType, staticType)) {
                return null;
            }
            return AccessUtils.isAccessibleInSameContextsAs(newReturnType, method.getReturnType(), ArgumentPropagatorProgramOptimizer.this.appView) ? newReturnType : null;
        }

        private SingleValue getReturnValue(ProgramMethod method) {
            AbstractValue returnValue;
            if (method.getReturnType().isAlwaysNull(ArgumentPropagatorProgramOptimizer.this.appView)) {
                returnValue = ArgumentPropagatorProgramOptimizer.this.appView.abstractValueFactory().createNullValue();
            } else if (((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool() && this.returnValuesForVirtualMethods.containsKey(method)) {
                assert (method.getAccessFlags().isAbstract());
                returnValue = (AbstractValue)this.returnValuesForVirtualMethods.get(method);
            } else {
                returnValue = method.getOptimizationInfo().getAbstractReturnValue();
            }
            return returnValue.isSingleValue() && returnValue.asSingleValue().isMaterializableInAllContexts(ArgumentPropagatorProgramOptimizer.this.appView) ? returnValue.asSingleValue() : null;
        }

        private DexType getNewParameterType(ProgramMethod method, int parameterIndex) {
            if (!ArgumentPropagatorProgramOptimizer.this.appView.getKeepInfo(method).isParameterTypeStrengtheningAllowed(this.options)) {
                return null;
            }
            DexType staticType = method.getArgumentType(parameterIndex);
            if (!staticType.isClassType()) {
                return null;
            }
            DynamicType dynamicType = method.getOptimizationInfo().getArgumentInfos().getDynamicType(parameterIndex);
            if (dynamicType == null || dynamicType.isUnknown()) {
                return null;
            }
            TypeElement staticTypeElement = staticType.toTypeElement(ArgumentPropagatorProgramOptimizer.this.appView);
            TypeElement dynamicUpperBoundType = dynamicType.getDynamicUpperBoundType(staticTypeElement);
            assert (dynamicUpperBoundType.lessThanOrEqual(staticTypeElement, ArgumentPropagatorProgramOptimizer.this.appView));
            assert (dynamicUpperBoundType.isReferenceType());
            if (dynamicUpperBoundType.isNullType()) {
                return null;
            }
            if (dynamicUpperBoundType.isArrayType()) {
                return null;
            }
            assert (dynamicUpperBoundType.isClassType());
            DexType newParameterType = dynamicUpperBoundType.asClassType().toDexType(this.dexItemFactory);
            if (newParameterType == staticType) {
                return null;
            }
            if (!((AppInfoWithLiveness)ArgumentPropagatorProgramOptimizer.this.appView.appInfo()).isSubtype(newParameterType, staticType)) {
                return null;
            }
            return AccessUtils.isAccessibleInSameContextsAs(newParameterType, staticType, ArgumentPropagatorProgramOptimizer.this.appView) ? newParameterType : null;
        }

        private RewrittenPrototypeDescription computePrototypeChangesForMethod(ProgramMethod method, DexType newReturnType, IntFunction<DexType> newParameterTypes, IntPredicate removableParameterIndices) {
            return RewrittenPrototypeDescription.create(Collections.emptyList(), this.computeReturnChangesForMethod(method, newReturnType), this.computeParameterChangesForMethod(method, newParameterTypes, removableParameterIndices));
        }

        private ArgumentInfoCollection computeParameterChangesForMethod(ProgramMethod method, IntFunction<DexType> newParameterTypes, IntPredicate removableParameterIndices) {
            ArgumentInfoCollection.Builder parameterChangesBuilder = ArgumentInfoCollection.builder().setArgumentInfosSize(((DexEncodedMethod)method.getDefinition()).getNumberOfArguments());
            if (((DexEncodedMethod)method.getDefinition()).isInstance() && removableParameterIndices.test(0) && method.getOptimizationInfo().hasUnusedArguments() && method.getOptimizationInfo().getUnusedArguments().get(0) && ParameterRemovalUtils.canRemoveUnusedParametersFrom(ArgumentPropagatorProgramOptimizer.this.appView, method) && ParameterRemovalUtils.canRemoveUnusedParameter(ArgumentPropagatorProgramOptimizer.this.appView, method, 0)) {
                parameterChangesBuilder.addArgumentInfo(0, ((RemovedReceiverInfo.Builder)RemovedReceiverInfo.Builder.create().setType(method.getHolderType())).build()).setIsConvertedToStaticMethod();
            }
            CallSiteOptimizationInfo optimizationInfo = method.getOptimizationInfo().getArgumentInfos();
            for (int argumentIndex = ((DexEncodedMethod)method.getDefinition()).getFirstNonReceiverArgumentIndex(); argumentIndex < ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments(); ++argumentIndex) {
                DexType dynamicType;
                if (removableParameterIndices.test(argumentIndex)) {
                    if (method.getOptimizationInfo().hasUnusedArguments() && method.getOptimizationInfo().getUnusedArguments().get(argumentIndex) && ParameterRemovalUtils.canRemoveUnusedParametersFrom(ArgumentPropagatorProgramOptimizer.this.appView, method) && ParameterRemovalUtils.canRemoveUnusedParameter(ArgumentPropagatorProgramOptimizer.this.appView, method, argumentIndex)) {
                        parameterChangesBuilder.addArgumentInfo(argumentIndex, ((RemovedArgumentInfo.Builder)RemovedArgumentInfo.builder().setType(method.getArgumentType(argumentIndex))).build());
                        continue;
                    }
                    AbstractValue abstractValue = optimizationInfo.getAbstractArgumentValue(argumentIndex);
                    if (abstractValue.isSingleValue() && abstractValue.asSingleValue().isMaterializableInContext(ArgumentPropagatorProgramOptimizer.this.appView, method)) {
                        parameterChangesBuilder.addArgumentInfo(argumentIndex, ((RemovedArgumentInfo.Builder)((RemovedArgumentInfo.Builder)RemovedArgumentInfo.builder().setSingleValue(abstractValue.asSingleValue())).setType(method.getArgumentType(argumentIndex))).build());
                        continue;
                    }
                }
                if ((dynamicType = newParameterTypes.apply(argumentIndex)) == null) continue;
                DexType staticType = method.getArgumentType(argumentIndex);
                assert (dynamicType != staticType);
                parameterChangesBuilder.addArgumentInfo(argumentIndex, RewrittenTypeInfo.builder().setCastType(dynamicType).setOldType(staticType).setNewType(dynamicType).build());
            }
            return parameterChangesBuilder.build();
        }

        private RewrittenTypeInfo computeReturnChangesForMethod(ProgramMethod method, DexType newReturnType) {
            if (newReturnType == null) {
                assert (!this.returnValuesForVirtualMethods.containsKey(method));
                return null;
            }
            assert (newReturnType != method.getReturnType());
            return RewrittenTypeInfo.builder().applyIf(newReturnType == this.dexItemFactory.voidType, builder -> builder.setSingleValue(this.getReturnValue(method))).setCastType(newReturnType).setOldType(method.getReturnType()).setNewType(newReturnType).build();
        }
    }

    static class AllowedPrototypeChanges {
        private static final AllowedPrototypeChanges EMPTY = new AllowedPrototypeChanges(null, Int2ReferenceMaps.emptyMap(), IntSets.EMPTY_SET);
        DexType newReturnType;
        Int2ReferenceMap<DexType> newParameterTypes;
        IntSet removableParameterIndices;

        AllowedPrototypeChanges(DexType newReturnType, Int2ReferenceMap<DexType> newParameterTypes, IntSet removableParameterIndices) {
            this.newReturnType = newReturnType;
            this.newParameterTypes = newParameterTypes;
            this.removableParameterIndices = removableParameterIndices;
        }

        public static AllowedPrototypeChanges create(RewrittenPrototypeDescription prototypeChanges) {
            if (prototypeChanges.isEmpty()) {
                return AllowedPrototypeChanges.empty();
            }
            DexType newReturnType = prototypeChanges.hasRewrittenReturnInfo() ? prototypeChanges.getRewrittenReturnInfo().getNewType() : null;
            Int2ReferenceOpenHashMap<DexType> newParameterTypes = new Int2ReferenceOpenHashMap<DexType>();
            IntOpenHashSet removableParameterIndices = new IntOpenHashSet();
            prototypeChanges.getArgumentInfoCollection().forEach((argumentIndex, argumentInfo) -> {
                if (argumentInfo.isRemovedArgumentInfo()) {
                    removableParameterIndices.add(argumentIndex);
                } else {
                    assert (argumentInfo.isRewrittenTypeInfo());
                    RewrittenTypeInfo rewrittenTypeInfo = argumentInfo.asRewrittenTypeInfo();
                    newParameterTypes.put(argumentIndex, rewrittenTypeInfo.getNewType());
                }
            });
            return new AllowedPrototypeChanges(newReturnType, newParameterTypes, removableParameterIndices);
        }

        public static AllowedPrototypeChanges empty() {
            return EMPTY;
        }

        public int hashCode() {
            return Objects.hash(this.newReturnType, this.newParameterTypes, this.removableParameterIndices);
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AllowedPrototypeChanges other = (AllowedPrototypeChanges)obj;
            return this.newReturnType == other.newReturnType && this.newParameterTypes.equals(other.newParameterTypes) && this.removableParameterIndices.equals(other.removableParameterIndices);
        }
    }
}

