/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReferenceTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.utils.WideningUtils;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.SetUtils;
import java.util.Collections;
import java.util.Set;

public class ConcreteClassTypeParameterState
extends ConcreteReferenceTypeParameterState {
    private AbstractValue abstractValue;
    private DynamicType dynamicType;

    public ConcreteClassTypeParameterState(MethodParameter inParameter) {
        this(AbstractValue.bottom(), DynamicType.bottom(), SetUtils.newHashSet(inParameter));
    }

    public ConcreteClassTypeParameterState(AbstractValue abstractValue, DynamicType dynamicType) {
        this(abstractValue, dynamicType, Collections.emptySet());
    }

    public ConcreteClassTypeParameterState(AbstractValue abstractValue, DynamicType dynamicType, Set<MethodParameter> inParameters) {
        super(inParameters);
        this.abstractValue = abstractValue;
        this.dynamicType = dynamicType;
        assert (!this.isEffectivelyBottom()) : "Must use BottomClassTypeParameterState instead";
        assert (!this.isEffectivelyUnknown()) : "Must use UnknownParameterState instead";
    }

    @Override
    public ParameterState clearInParameters() {
        if (this.hasInParameters()) {
            if (this.abstractValue.isBottom()) {
                assert (this.dynamicType.isBottom());
                return ConcreteClassTypeParameterState.bottomClassTypeParameter();
            }
            this.internalClearInParameters();
        }
        assert (!this.isEffectivelyBottom());
        return this;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<AppInfoWithLiveness> appView) {
        if (this.getDynamicType().getNullability().isDefinitelyNull()) {
            assert (this.abstractValue == null || this.abstractValue.isNull());
            return appView.abstractValueFactory().createNullValue();
        }
        return this.abstractValue;
    }

    @Override
    public DynamicType getDynamicType() {
        return this.dynamicType;
    }

    @Override
    public Nullability getNullability() {
        return this.getDynamicType().getNullability();
    }

    @Override
    public ConcreteParameterState.ConcreteParameterStateKind getKind() {
        return ConcreteParameterState.ConcreteParameterStateKind.CLASS;
    }

    @Override
    public boolean isClassParameter() {
        return true;
    }

    @Override
    public ConcreteClassTypeParameterState asClassParameter() {
        return this;
    }

    public boolean isEffectivelyBottom() {
        return this.abstractValue.isBottom() && this.dynamicType.isBottom() && !this.hasInParameters();
    }

    public boolean isEffectivelyUnknown() {
        return this.abstractValue.isUnknown() && this.dynamicType.isUnknown();
    }

    @Override
    public ParameterState mutableCopy() {
        return new ConcreteClassTypeParameterState(this.abstractValue, this.dynamicType, this.copyInParameters());
    }

    @Override
    public ParameterState mutableJoin(AppView<AppInfoWithLiveness> appView, ConcreteReferenceTypeParameterState parameterState, DexType parameterType, Action onChangedAction) {
        DynamicType widenedDynamicType;
        assert (parameterType.isClassType());
        boolean allowNullOrAbstractValue = true;
        boolean allowNonConstantNumbers = false;
        AbstractValue oldAbstractValue = this.abstractValue;
        this.abstractValue = this.abstractValue.join(parameterState.getAbstractValue(appView), appView.abstractValueFactory(), allowNullOrAbstractValue, allowNonConstantNumbers);
        DynamicType oldDynamicType = this.dynamicType;
        DynamicType joinedDynamicType = this.dynamicType.join(appView, parameterState.getDynamicType());
        this.dynamicType = widenedDynamicType = WideningUtils.widenDynamicNonReceiverType(appView, joinedDynamicType, parameterType);
        if (this.abstractValue.isUnknown() && this.dynamicType.isUnknown()) {
            return ConcreteClassTypeParameterState.unknown();
        }
        boolean inParametersChanged = this.mutableJoinInParameters(parameterState);
        if (this.widenInParameters(appView)) {
            return ConcreteClassTypeParameterState.unknown();
        }
        if (this.abstractValue != oldAbstractValue || !this.dynamicType.equals(oldDynamicType) || inParametersChanged) {
            onChangedAction.execute();
        }
        return this;
    }
}

