/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteArrayTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteClassTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePrimitiveTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReceiverParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReferenceTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.NonEmptyParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class ConcreteParameterState
extends NonEmptyParameterState {
    private Set<MethodParameter> inParameters;

    ConcreteParameterState(Set<MethodParameter> inParameters) {
        this.inParameters = inParameters;
    }

    public abstract ParameterState clearInParameters();

    void internalClearInParameters() {
        this.inParameters = Collections.emptySet();
    }

    public Set<MethodParameter> copyInParameters() {
        if (this.inParameters.isEmpty()) {
            assert (this.inParameters == Collections.emptySet());
            return this.inParameters;
        }
        return new HashSet<MethodParameter>(this.inParameters);
    }

    public boolean hasInParameters() {
        return !this.inParameters.isEmpty();
    }

    public Set<MethodParameter> getInParameters() {
        assert (this.inParameters.isEmpty() || this.inParameters instanceof HashSet);
        return this.inParameters;
    }

    public abstract ConcreteParameterStateKind getKind();

    public boolean isArrayParameter() {
        return false;
    }

    public ConcreteArrayTypeParameterState asArrayParameter() {
        return null;
    }

    public boolean isClassParameter() {
        return false;
    }

    public ConcreteClassTypeParameterState asClassParameter() {
        return null;
    }

    public boolean isPrimitiveParameter() {
        return false;
    }

    public ConcretePrimitiveTypeParameterState asPrimitiveParameter() {
        return null;
    }

    public boolean isReceiverParameter() {
        return false;
    }

    public ConcreteReceiverParameterState asReceiverParameter() {
        return null;
    }

    public boolean isReferenceParameter() {
        return false;
    }

    public ConcreteReferenceTypeParameterState asReferenceParameter() {
        return null;
    }

    @Override
    public boolean isConcrete() {
        return true;
    }

    @Override
    public ConcreteParameterState asConcrete() {
        return this;
    }

    @Override
    public final ParameterState mutableJoin(AppView<AppInfoWithLiveness> appView, ParameterState parameterState, DexType parameterType, StateCloner cloner, Action onChangedAction) {
        if (parameterState.isBottom()) {
            return this;
        }
        if (parameterState.isUnknown()) {
            return parameterState;
        }
        ConcreteParameterState concreteParameterState = parameterState.asConcrete();
        if (this.isReferenceParameter()) {
            assert (concreteParameterState.isReferenceParameter());
            return this.asReferenceParameter().mutableJoin(appView, concreteParameterState.asReferenceParameter(), parameterType, onChangedAction);
        }
        return this.asPrimitiveParameter().mutableJoin(appView, concreteParameterState.asPrimitiveParameter(), parameterType, onChangedAction);
    }

    boolean mutableJoinInParameters(ConcreteParameterState parameterState) {
        if (parameterState.inParameters.isEmpty()) {
            return false;
        }
        if (this.inParameters.isEmpty()) {
            assert (this.inParameters == Collections.emptySet());
            this.inParameters = new HashSet<MethodParameter>();
        }
        return this.inParameters.addAll(parameterState.inParameters);
    }

    boolean widenInParameters(AppView<AppInfoWithLiveness> appView) {
        return this.inParameters != null && this.inParameters.size() > appView.options().callSiteOptimizationOptions().getMaxNumberOfInParameters();
    }

    public static enum ConcreteParameterStateKind {
        ARRAY,
        CLASS,
        PRIMITIVE,
        RECEIVER;

    }
}

