/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodStateOrUnknown;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodStateOrBottom;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcretePolymorphicMethodStateOrUnknown;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class ConcretePolymorphicMethodState
extends ConcreteMethodState
implements ConcretePolymorphicMethodStateOrBottom,
ConcretePolymorphicMethodStateOrUnknown {
    private final Map<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> receiverBoundsToState;

    private ConcretePolymorphicMethodState(Map<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> receiverBoundsToState) {
        this.receiverBoundsToState = receiverBoundsToState;
        assert (!this.isEffectivelyBottom());
        assert (!this.isEffectivelyUnknown());
    }

    private ConcretePolymorphicMethodState(DynamicTypeWithUpperBound receiverBounds, ConcreteMonomorphicMethodStateOrUnknown methodState) {
        this.receiverBoundsToState = new HashMap<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown>(1);
        this.receiverBoundsToState.put(receiverBounds, methodState);
        assert (!this.isEffectivelyUnknown());
    }

    public static ConcretePolymorphicMethodStateOrUnknown create(DynamicTypeWithUpperBound receiverBounds, ConcreteMonomorphicMethodStateOrUnknown methodState) {
        return receiverBounds.isUnknown() && methodState.isUnknown() ? MethodState.unknown() : new ConcretePolymorphicMethodState(receiverBounds, methodState);
    }

    private ConcretePolymorphicMethodStateOrUnknown add(AppView<AppInfoWithLiveness> appView, DexMethodSignature methodSignature, DynamicTypeWithUpperBound bounds, ConcreteMonomorphicMethodStateOrUnknown methodState, StateCloner cloner) {
        assert (!this.isEffectivelyBottom());
        assert (!this.isEffectivelyUnknown());
        if (methodState.isUnknown()) {
            if (bounds.isUnknown()) {
                return ConcretePolymorphicMethodState.unknown();
            }
            this.receiverBoundsToState.put(bounds, methodState);
            return this;
        }
        assert (methodState.isMonomorphic());
        ConcreteMonomorphicMethodStateOrUnknown newMethodStateForBounds = ConcretePolymorphicMethodState.joinInner(appView, methodSignature, this.receiverBoundsToState.get(bounds), methodState, cloner);
        if (bounds.isUnknown() && newMethodStateForBounds.isUnknown()) {
            return ConcretePolymorphicMethodState.unknown();
        }
        this.receiverBoundsToState.put(bounds, newMethodStateForBounds);
        return this;
    }

    private static ConcreteMonomorphicMethodStateOrUnknown joinInner(AppView<AppInfoWithLiveness> appView, DexMethodSignature methodSignature, ConcreteMonomorphicMethodStateOrUnknown methodState, ConcreteMonomorphicMethodStateOrUnknown other, StateCloner cloner) {
        if (methodState == null) {
            return (ConcreteMonomorphicMethodStateOrUnknown)cloner.mutableCopy(other);
        }
        if (methodState.isUnknown() || other.isUnknown()) {
            return ConcretePolymorphicMethodState.unknown();
        }
        assert (methodState.isMonomorphic());
        return methodState.asMonomorphic().mutableJoin(appView, methodSignature, other.asMonomorphic(), cloner);
    }

    public void forEach(BiConsumer<? super DynamicTypeWithUpperBound, ? super ConcreteMonomorphicMethodStateOrUnknown> consumer) {
        this.receiverBoundsToState.forEach(consumer);
    }

    public MethodState getMethodStateForBounds(DynamicTypeWithUpperBound dynamicType) {
        ConcreteMonomorphicMethodStateOrUnknown methodStateForBounds = this.receiverBoundsToState.get(dynamicType);
        if (methodStateForBounds != null) {
            return methodStateForBounds;
        }
        return MethodState.bottom();
    }

    public boolean isEffectivelyBottom() {
        return this.receiverBoundsToState.isEmpty();
    }

    public boolean isEffectivelyUnknown() {
        return this.getMethodStateForBounds(DynamicType.unknown()).isUnknown();
    }

    @Override
    public MethodState mutableCopy() {
        assert (!this.isEffectivelyBottom());
        assert (!this.isEffectivelyUnknown());
        HashMap<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> receiverBoundsToState = new HashMap<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown>();
        this.forEach((bounds, methodState) -> receiverBoundsToState.put((DynamicTypeWithUpperBound)bounds, methodState.mutableCopy()));
        return new ConcretePolymorphicMethodState(receiverBoundsToState);
    }

    public MethodState mutableCopyWithRewrittenBounds(AppView<AppInfoWithLiveness> appView, Function<DynamicTypeWithUpperBound, DynamicTypeWithUpperBound> boundsRewriter, DexMethodSignature methodSignature, StateCloner cloner) {
        assert (!this.isEffectivelyBottom());
        assert (!this.isEffectivelyUnknown());
        HashMap<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> rewrittenReceiverBoundsToState = new HashMap<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown>();
        for (Map.Entry<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> entry : this.receiverBoundsToState.entrySet()) {
            DynamicTypeWithUpperBound rewrittenBounds = boundsRewriter.apply(entry.getKey());
            if (rewrittenBounds == null) continue;
            ConcreteMonomorphicMethodStateOrUnknown existingMethodStateForBounds = (ConcreteMonomorphicMethodStateOrUnknown)rewrittenReceiverBoundsToState.get(rewrittenBounds);
            ConcreteMonomorphicMethodStateOrUnknown newMethodStateForBounds = ConcretePolymorphicMethodState.joinInner(appView, methodSignature, existingMethodStateForBounds, entry.getValue(), cloner);
            if (rewrittenBounds.isUnknown() && newMethodStateForBounds.isUnknown()) {
                return ConcretePolymorphicMethodState.unknown();
            }
            rewrittenReceiverBoundsToState.put(rewrittenBounds, newMethodStateForBounds);
        }
        return rewrittenReceiverBoundsToState.isEmpty() ? ConcretePolymorphicMethodState.bottom() : new ConcretePolymorphicMethodState(rewrittenReceiverBoundsToState);
    }

    public MethodState mutableJoin(AppView<AppInfoWithLiveness> appView, DexMethodSignature methodSignature, ConcretePolymorphicMethodState methodState, StateCloner cloner) {
        assert (!this.isEffectivelyBottom());
        assert (!this.isEffectivelyUnknown());
        assert (!methodState.isEffectivelyBottom());
        assert (!methodState.isEffectivelyUnknown());
        for (Map.Entry<DynamicTypeWithUpperBound, ConcreteMonomorphicMethodStateOrUnknown> entry : methodState.receiverBoundsToState.entrySet()) {
            ConcretePolymorphicMethodStateOrUnknown result = this.add(appView, methodSignature, entry.getKey(), entry.getValue(), cloner);
            if (result.isUnknown()) {
                return result;
            }
            assert (result == this);
        }
        assert (!this.isEffectivelyUnknown());
        return this;
    }

    public Collection<ConcreteMonomorphicMethodStateOrUnknown> values() {
        return this.receiverBoundsToState.values();
    }

    @Override
    public boolean isPolymorphic() {
        return true;
    }

    @Override
    public ConcretePolymorphicMethodState asPolymorphic() {
        return this;
    }

    @Override
    public ConcretePolymorphicMethodStateOrBottom asPolymorphicOrBottom() {
        return this;
    }
}

