/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteReferenceTypeParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import java.util.Collections;
import java.util.Set;

public class ConcreteReceiverParameterState
extends ConcreteReferenceTypeParameterState {
    private DynamicType dynamicType;

    public ConcreteReceiverParameterState(DynamicType dynamicType) {
        this(dynamicType, Collections.emptySet());
    }

    public ConcreteReceiverParameterState(DynamicType dynamicType, Set<MethodParameter> inParameters) {
        super(inParameters);
        this.dynamicType = dynamicType;
        assert (!this.isEffectivelyBottom()) : "Must use BottomReceiverParameterState instead";
        assert (!this.isEffectivelyUnknown()) : "Must use UnknownParameterState instead";
    }

    @Override
    public ParameterState clearInParameters() {
        if (this.hasInParameters()) {
            if (this.dynamicType.isBottom()) {
                return ConcreteReceiverParameterState.bottomReceiverParameter();
            }
            this.internalClearInParameters();
        }
        assert (!this.isEffectivelyBottom());
        return this;
    }

    @Override
    public AbstractValue getAbstractValue(AppView<AppInfoWithLiveness> appView) {
        return AbstractValue.unknown();
    }

    @Override
    public DynamicType getDynamicType() {
        return this.dynamicType;
    }

    @Override
    public Nullability getNullability() {
        return this.getDynamicType().getNullability();
    }

    @Override
    public ConcreteParameterState.ConcreteParameterStateKind getKind() {
        return ConcreteParameterState.ConcreteParameterStateKind.RECEIVER;
    }

    public boolean isEffectivelyBottom() {
        return this.dynamicType.isBottom() && !this.hasInParameters();
    }

    public boolean isEffectivelyUnknown() {
        return this.dynamicType.isUnknown();
    }

    @Override
    public boolean isReceiverParameter() {
        return true;
    }

    @Override
    public ConcreteReceiverParameterState asReceiverParameter() {
        return this;
    }

    @Override
    public ParameterState mutableCopy() {
        return new ConcreteReceiverParameterState(this.dynamicType, this.copyInParameters());
    }

    @Override
    public ParameterState mutableJoin(AppView<AppInfoWithLiveness> appView, ConcreteReferenceTypeParameterState parameterState, DexType parameterType, Action onChangedAction) {
        assert (parameterType == null || parameterType.isClassType());
        DynamicType oldDynamicType = this.dynamicType;
        this.dynamicType = this.dynamicType.join(appView, parameterState.getDynamicType());
        if (this.dynamicType.isUnknown()) {
            return ConcreteReceiverParameterState.unknown();
        }
        boolean inParametersChanged = this.mutableJoinInParameters(parameterState);
        if (this.widenInParameters(appView)) {
            return ConcreteReceiverParameterState.unknown();
        }
        if (!this.dynamicType.equals(oldDynamicType) || inParametersChanged) {
            onChangedAction.execute();
        }
        return this;
    }
}

