/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.codescanner;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodSignature;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.ImmediateProgramSubtypingInfo;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.optimize.argumentpropagation.ArgumentPropagatorCodeScanner;
import com.android.tools.r8.optimize.argumentpropagation.utils.DepthFirstTopDownClassHierarchyTraversal;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class VirtualRootMethodsAnalysis
extends DepthFirstTopDownClassHierarchyTraversal {
    private final Map<DexProgramClass, Map<DexMethodSignature, VirtualRootMethod>> virtualRootMethodsPerClass = new IdentityHashMap<DexProgramClass, Map<DexMethodSignature, VirtualRootMethod>>();
    private final Set<DexMethod> monomorphicVirtualMethods = Sets.newIdentityHashSet();
    private final Map<DexMethod, DexMethod> virtualRootMethods = new IdentityHashMap<DexMethod, DexMethod>();

    public VirtualRootMethodsAnalysis(AppView<AppInfoWithLiveness> appView, ImmediateProgramSubtypingInfo immediateSubtypingInfo) {
        super(appView, immediateSubtypingInfo);
    }

    private Map<DexMethodSignature, VirtualRootMethod> computeVirtualRootMethodsState(DexProgramClass clazz) {
        HashMap<DexMethodSignature, VirtualRootMethod> virtualRootMethodsForClass = new HashMap<DexMethodSignature, VirtualRootMethod>();
        this.immediateSubtypingInfo.forEachImmediateProgramSuperClass(clazz, superclass -> {
            Map<DexMethodSignature, VirtualRootMethod> virtualRootMethodsForSuperclass = this.virtualRootMethodsPerClass.get(superclass);
            virtualRootMethodsForSuperclass.forEach((signature, info) -> virtualRootMethodsForClass.computeIfAbsent((DexMethodSignature)signature, MapUtils.ignoreKey(() -> new VirtualRootMethod(info.getRoot(), (VirtualRootMethod)info))));
        });
        clazz.forEachProgramVirtualMethod(method -> {
            DexMethodSignature signature = method.getMethodSignature();
            if (virtualRootMethodsForClass.containsKey(signature)) {
                ((VirtualRootMethod)virtualRootMethodsForClass.get(signature)).getParent().addOverride((ProgramMethod)method);
            } else {
                virtualRootMethodsForClass.put(signature, new VirtualRootMethod((ProgramMethod)method));
            }
        });
        return virtualRootMethodsForClass;
    }

    private void promoteToFinalIfPossible(DexProgramClass clazz) {
        if (!this.appView.testing().disableMarkingClassesFinal && !clazz.isAbstract() && !clazz.isInterface() && this.appView.getKeepInfo(clazz).isOptimizationAllowed(this.appView.options())) {
            clazz.getAccessFlags().promoteToFinal();
        }
    }

    private void promoteToFinalIfPossible(ProgramMethod method, VirtualRootMethod virtualRootMethod) {
        if (!(this.appView.testing().disableMarkingMethodsFinal || method.getHolder().isInterface() || method.getAccessFlags().isAbstract() || virtualRootMethod.hasOverrides() || !this.appView.getKeepInfo(method).isOptimizationAllowed(this.appView.options()))) {
            method.getAccessFlags().promoteToFinal();
        }
    }

    public void initializeVirtualRootMethods(Collection<DexProgramClass> stronglyConnectedComponent, ArgumentPropagatorCodeScanner codeScanner) {
        this.run(stronglyConnectedComponent);
        codeScanner.addMonomorphicVirtualMethods(this.monomorphicVirtualMethods);
        codeScanner.addVirtualRootMethods(this.virtualRootMethods);
    }

    @Override
    public void forEachSubClass(DexProgramClass clazz, Consumer<DexProgramClass> consumer) {
        List<DexProgramClass> subclasses = this.immediateSubtypingInfo.getSubclasses(clazz);
        if (subclasses.isEmpty()) {
            this.promoteToFinalIfPossible(clazz);
        } else {
            subclasses.forEach(consumer);
        }
    }

    @Override
    public void visit(DexProgramClass clazz) {
        Map<DexMethodSignature, VirtualRootMethod> state = this.computeVirtualRootMethodsState(clazz);
        this.virtualRootMethodsPerClass.put(clazz, state);
    }

    @Override
    public void prune(DexProgramClass clazz) {
        Map<DexMethodSignature, VirtualRootMethod> virtualRootMethodsForClass = this.virtualRootMethodsPerClass.remove(clazz);
        clazz.forEachProgramVirtualMethod(rootCandidate -> {
            boolean isMonomorphicVirtualMethod;
            VirtualRootMethod virtualRootMethod = (VirtualRootMethod)virtualRootMethodsForClass.remove(rootCandidate.getMethodSignature());
            this.promoteToFinalIfPossible((ProgramMethod)rootCandidate, virtualRootMethod);
            if (!rootCandidate.isStructurallyEqualTo(virtualRootMethod.getRoot())) {
                return;
            }
            boolean bl = isMonomorphicVirtualMethod = !clazz.isInterface() && !virtualRootMethod.hasOverrides();
            if (isMonomorphicVirtualMethod) {
                this.monomorphicVirtualMethods.add((DexMethod)rootCandidate.getReference());
            } else {
                ProgramMethod singleNonAbstractMethod = virtualRootMethod.getSingleNonAbstractMethod();
                if (singleNonAbstractMethod != null && !virtualRootMethod.isInterfaceMethodWithSiblings()) {
                    virtualRootMethod.forEach(method -> this.virtualRootMethods.put((DexMethod)method.getReference(), (DexMethod)singleNonAbstractMethod.getReference()));
                    if (!singleNonAbstractMethod.getHolder().isInterface()) {
                        this.monomorphicVirtualMethods.add((DexMethod)singleNonAbstractMethod.getReference());
                    }
                } else {
                    virtualRootMethod.forEach(method -> this.virtualRootMethods.put((DexMethod)method.getReference(), (DexMethod)rootCandidate.getReference()));
                }
            }
        });
    }

    static class VirtualRootMethod {
        private final VirtualRootMethod parent;
        private final ProgramMethod root;
        private final ProgramMethodSet overrides = ProgramMethodSet.create();

        VirtualRootMethod(ProgramMethod root) {
            this(root, null);
        }

        VirtualRootMethod(ProgramMethod root, VirtualRootMethod parent) {
            this.parent = parent;
            this.root = root;
        }

        void addOverride(ProgramMethod override) {
            assert (override != this.root);
            assert (override.getMethodSignature().equals(this.root.getMethodSignature()));
            this.overrides.add(override);
            if (this.hasParent()) {
                this.getParent().addOverride(override);
            }
        }

        boolean hasParent() {
            return this.parent != null;
        }

        VirtualRootMethod getParent() {
            return this.parent;
        }

        ProgramMethod getRoot() {
            return this.root;
        }

        ProgramMethod getSingleNonAbstractMethod() {
            ProgramMethod singleNonAbstractMethod = this.root.getAccessFlags().isAbstract() ? null : this.root;
            for (ProgramMethod override : this.overrides) {
                if (override.getAccessFlags().isAbstract()) continue;
                if (singleNonAbstractMethod != null) {
                    return null;
                }
                singleNonAbstractMethod = override;
            }
            assert (singleNonAbstractMethod == null || !singleNonAbstractMethod.getAccessFlags().isAbstract());
            return singleNonAbstractMethod;
        }

        void forEach(Consumer<ProgramMethod> consumer) {
            consumer.accept(this.root);
            this.overrides.forEach(consumer);
        }

        boolean hasOverrides() {
            return !this.overrides.isEmpty();
        }

        boolean isInterfaceMethodWithSiblings() {
            return this.root.getHolder().isInterface();
        }
    }
}

