/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.lenscoderewriter;

import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.FieldGet;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.WorkList;
import java.util.IdentityHashMap;
import java.util.Map;

public abstract class NullCheckInserter {
    public static NullCheckInserter create(AppView<? extends AppInfoWithClassHierarchy> appView, IRCode code, GraphLens.NonIdentityGraphLens graphLens, GraphLens codeLens) {
        Object previousLens = graphLens.find(lens -> lens.isArgumentPropagatorGraphLens() || lens == codeLens);
        if (previousLens != null && previousLens != codeLens && ((GraphLens)previousLens).isArgumentPropagatorGraphLens()) {
            return new NullCheckInserterImpl(appView.withLiveness(), code, graphLens);
        }
        return new EmptyNullCheckInserter();
    }

    public abstract void insertNullCheckForInvokeReceiverIfNeeded(InvokeMethod var1, InvokeMethod var2, GraphLens.MethodLookupResult var3);

    public abstract void processWorklist();

    static class EmptyNullCheckInserter
    extends NullCheckInserter {
        EmptyNullCheckInserter() {
        }

        @Override
        public void insertNullCheckForInvokeReceiverIfNeeded(InvokeMethod invoke, InvokeMethod rewrittenInvoke, GraphLens.MethodLookupResult lookup) {
        }

        @Override
        public void processWorklist() {
        }
    }

    static class NullCheckInserterImpl
    extends NullCheckInserter {
        private final AppView<AppInfoWithLiveness> appView;
        private final IRCode code;
        private final GraphLens.NonIdentityGraphLens graphLens;
        private final Map<InvokeStatic, Value> worklist = new IdentityHashMap<InvokeStatic, Value>();

        NullCheckInserterImpl(AppView<AppInfoWithLiveness> appView, IRCode code, GraphLens.NonIdentityGraphLens graphLens) {
            this.appView = appView;
            this.code = code;
            this.graphLens = graphLens;
        }

        private boolean isReadOfEffectivelyUnreadField(Value value) {
            if (value.isPhi()) {
                boolean hasSeenReadOfEffectivelyUnreadField = false;
                WorkList<Phi> reachablePhis = WorkList.newIdentityWorkList(value.asPhi());
                while (reachablePhis.hasNext()) {
                    Phi currentPhi = reachablePhis.next();
                    for (Value operand : currentPhi.getOperands()) {
                        if (operand.isPhi()) {
                            reachablePhis.addIfNotSeen(operand.asPhi());
                            continue;
                        }
                        if (!this.isReadOfEffectivelyUnreadField(operand.getDefinition())) {
                            return false;
                        }
                        hasSeenReadOfEffectivelyUnreadField = true;
                    }
                }
                assert (hasSeenReadOfEffectivelyUnreadField);
                return true;
            }
            return this.isReadOfEffectivelyUnreadField(value.getDefinition());
        }

        private boolean isReadOfEffectivelyUnreadField(Instruction instruction) {
            if (instruction.isFieldGet()) {
                FieldGet fieldGet = instruction.asFieldGet();
                DexField field = fieldGet.getField();
                DexField rewrittenField = this.appView.graphLens().lookupField(field, this.graphLens);
                FieldResolutionResult resolutionResult = this.appView.appInfo().resolveField(rewrittenField);
                return resolutionResult.isSingleFieldResolutionResult() && !this.appView.appInfo().isFieldRead(resolutionResult.getResolvedField());
            }
            return false;
        }

        @Override
        public void insertNullCheckForInvokeReceiverIfNeeded(InvokeMethod invoke, InvokeMethod rewrittenInvoke, GraphLens.MethodLookupResult lookup) {
            if (!invoke.isInvokeMethodWithReceiver() || !rewrittenInvoke.isInvokeStatic()) {
                return;
            }
            ArgumentInfo receiverArgumentInfo = lookup.getPrototypeChanges().getArgumentInfoCollection().getArgumentInfo(0);
            if (!receiverArgumentInfo.isRemovedReceiverInfo()) {
                return;
            }
            Value receiver = invoke.asInvokeMethodWithReceiver().getReceiver();
            TypeElement receiverType = receiver.getType();
            if (receiverType.isDefinitelyNotNull()) {
                return;
            }
            if (receiver.isDefinedByInstructionSatisfying(Instruction::isUnusedArgument)) {
                return;
            }
            this.worklist.put(rewrittenInvoke.asInvokeStatic(), receiver);
        }

        @Override
        public void processWorklist() {
            if (this.worklist.isEmpty()) {
                return;
            }
            BasicBlockIterator blockIterator = this.code.listIterator();
            while (blockIterator.hasNext()) {
                BasicBlock block = blockIterator.next();
                InstructionListIterator instructionIterator = block.listIterator(this.code);
                while (instructionIterator.hasNext()) {
                    Value receiver;
                    InvokeStatic invoke;
                    Instruction instruction = (Instruction)instructionIterator.next();
                    if (!instruction.isInvokeStatic() || !this.worklist.containsKey(invoke = instruction.asInvokeStatic()) || this.isReadOfEffectivelyUnreadField(receiver = this.worklist.get(invoke))) continue;
                    instructionIterator.previous();
                    Position nullCheckPosition = invoke.getPosition().getOutermostCallerMatchingOrElse(Position::isRemoveInnerFramesIfThrowingNpe, invoke.getPosition());
                    if (nullCheckPosition.isRemoveInnerFramesIfThrowingNpe()) {
                        Object newCallerPositionTail = ((Position.PositionBuilder)nullCheckPosition.builderWithCopy().setRemoveInnerFramesIfThrowingNpe(false)).build();
                        invoke.forceOverwritePosition(invoke.getPosition().replacePosition(nullCheckPosition, (Position)newCallerPositionTail));
                        nullCheckPosition = newCallerPositionTail;
                    }
                    instructionIterator.insertNullCheckInstruction(this.appView, this.code, blockIterator, receiver, nullCheckPosition);
                    if (invoke.getBlock().hasCatchHandlers()) {
                        BasicBlock splitBlock = invoke.getBlock();
                        BasicBlock previousBlock = blockIterator.previousUntil(b -> b == splitBlock);
                        assert (previousBlock == splitBlock);
                        blockIterator.next();
                        instructionIterator = splitBlock.listIterator(this.code);
                    }
                    Instruction next = (Instruction)instructionIterator.next();
                    assert (next == invoke);
                }
            }
        }
    }
}

