/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.propagation;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodStateCollectionByReference;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.NonEmptyParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.StateCloner;
import com.android.tools.r8.optimize.argumentpropagation.utils.BidirectedGraph;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.ThreadUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class InParameterFlowPropagator {
    final AppView<AppInfoWithLiveness> appView;
    final IRConverter converter;
    final MethodStateCollectionByReference methodStates;

    public InParameterFlowPropagator(AppView<AppInfoWithLiveness> appView, IRConverter converter, MethodStateCollectionByReference methodStates) {
        this.appView = appView;
        this.converter = converter;
        this.methodStates = methodStates;
    }

    private void process(Set<ParameterNode> stronglyConnectedComponent) {
        ArrayDeque<ParameterNode> worklist = new ArrayDeque<ParameterNode>(stronglyConnectedComponent);
        while (!worklist.isEmpty()) {
            ParameterNode parameterNode = (ParameterNode)worklist.removeLast();
            parameterNode.unsetPending();
            this.propagate(parameterNode, affectedNode -> {
                if (!affectedNode.isPending() && affectedNode.hasSuccessors()) {
                    worklist.add((ParameterNode)affectedNode);
                    affectedNode.setPending();
                }
            });
        }
    }

    private void propagate(ParameterNode parameterNode, Consumer<ParameterNode> affectedNodeConsumer) {
        ParameterState parameterState = parameterNode.getState();
        if (parameterState.isBottom()) {
            return;
        }
        ArrayList<ParameterNode> newlyUnknownParameterNodes = new ArrayList<ParameterNode>();
        for (ParameterNode successorNode : parameterNode.getSuccessors()) {
            ParameterState newParameterState = successorNode.addState(this.appView, parameterState.asNonEmpty(), () -> affectedNodeConsumer.accept(successorNode));
            if (!newParameterState.isUnknown()) continue;
            newlyUnknownParameterNodes.add(successorNode);
        }
        for (ParameterNode newlyUnknownParameterNode : newlyUnknownParameterNodes) {
            newlyUnknownParameterNode.clearPredecessors();
        }
    }

    private void postProcessMethodStates(ExecutorService executorService) throws ExecutionException {
        ThreadUtils.processItems(this.appView.appInfo().classes(), this::postProcessMethodStates, executorService);
    }

    private void postProcessMethodStates(DexProgramClass clazz) {
        clazz.forEachProgramMethod(this::postProcessMethodState);
    }

    private void postProcessMethodState(ProgramMethod method) {
        ConcreteMethodState methodState = this.methodStates.get(method).asConcrete();
        if (methodState == null) {
            return;
        }
        assert (methodState.isMonomorphic());
        ConcreteMonomorphicMethodState monomorphicMethodState = methodState.asMonomorphic();
        if (monomorphicMethodState.isEffectivelyBottom()) {
            this.methodStates.set(method, MethodState.bottom());
        } else if (monomorphicMethodState.isEffectivelyUnknown()) {
            this.methodStates.set(method, MethodState.unknown());
        }
    }

    public void run(ExecutorService executorService) throws ExecutionException {
        FlowGraph flowGraph = new FlowGraph(this.appView.appInfo().classes());
        List stronglyConnectedComponents = flowGraph.computeStronglyConnectedComponents();
        ThreadUtils.processItems(stronglyConnectedComponents, this::process, executorService);
        this.postProcessMethodStates(executorService);
    }

    static class ParameterNode {
        private final ConcreteMonomorphicMethodState methodState;
        private final int parameterIndex;
        private final DexType parameterType;
        private final Set<ParameterNode> predecessors = Sets.newIdentityHashSet();
        private final Set<ParameterNode> successors = Sets.newIdentityHashSet();
        private boolean pending = true;

        ParameterNode(ConcreteMonomorphicMethodState methodState, int parameterIndex, DexType parameterType) {
            this.methodState = methodState;
            this.parameterIndex = parameterIndex;
            this.parameterType = parameterType;
        }

        void addPredecessor(ParameterNode predecessor) {
            predecessor.successors.add(this);
            this.predecessors.add(predecessor);
        }

        void clearPredecessors() {
            for (ParameterNode predecessor : this.predecessors) {
                predecessor.successors.remove(this);
            }
            this.predecessors.clear();
        }

        Set<ParameterNode> getPredecessors() {
            return this.predecessors;
        }

        ParameterState getState() {
            return this.methodState.getParameterState(this.parameterIndex);
        }

        Set<ParameterNode> getSuccessors() {
            return this.successors;
        }

        boolean hasSuccessors() {
            return !this.successors.isEmpty();
        }

        boolean isPending() {
            return this.pending;
        }

        ParameterState addState(AppView<AppInfoWithLiveness> appView, NonEmptyParameterState parameterStateToAdd, Action onChangedAction) {
            ParameterState oldParameterState = this.getState();
            ParameterState newParameterState = oldParameterState.mutableJoin(appView, parameterStateToAdd, this.parameterType, StateCloner.getCloner(), onChangedAction);
            if (newParameterState != oldParameterState) {
                this.setState(newParameterState);
                onChangedAction.execute();
            }
            return newParameterState;
        }

        void setPending() {
            assert (!this.isPending());
            this.pending = true;
        }

        void setState(ParameterState parameterState) {
            this.methodState.setParameterState(this.parameterIndex, parameterState);
        }

        void unsetPending() {
            assert (this.pending);
            this.pending = false;
        }
    }

    public class FlowGraph
    extends BidirectedGraph<ParameterNode> {
        private final Map<DexMethod, Int2ReferenceMap<ParameterNode>> nodes = new IdentityHashMap<DexMethod, Int2ReferenceMap<ParameterNode>>();

        public FlowGraph(Iterable<DexProgramClass> classes) {
            classes.forEach(this::add);
        }

        private void add(DexProgramClass clazz) {
            clazz.forEachProgramMethod(this::add);
        }

        private void add(ProgramMethod method) {
            MethodState methodState = InParameterFlowPropagator.this.methodStates.get(method);
            if (methodState.isBottom() || methodState.isUnknown()) {
                return;
            }
            ConcreteMonomorphicMethodState monomorphicMethodState = methodState.asMonomorphic();
            List<ParameterState> parameterStates = monomorphicMethodState.getParameterStates();
            for (int parameterIndex = 0; parameterIndex < parameterStates.size(); ++parameterIndex) {
                ParameterState parameterState = parameterStates.get(parameterIndex);
                this.add(method, parameterIndex, monomorphicMethodState, parameterState);
            }
        }

        private void add(ProgramMethod method, int parameterIndex, ConcreteMonomorphicMethodState methodState, ParameterState parameterState) {
            if (parameterState.isBottom() || parameterState.isUnknown()) {
                return;
            }
            ConcreteParameterState concreteParameterState = parameterState.asConcrete();
            if (!concreteParameterState.hasInParameters()) {
                return;
            }
            ParameterNode node = this.getOrCreateParameterNode(method, parameterIndex, methodState);
            for (MethodParameter inParameter : concreteParameterState.getInParameters()) {
                ProgramMethod enclosingMethod = this.getEnclosingMethod(inParameter);
                if (enclosingMethod == null) {
                    assert (InParameterFlowPropagator.this.converter.getInliner().verifyIsPrunedDueToSingleCallerInlining(inParameter.getMethod()));
                    continue;
                }
                MethodState enclosingMethodState = this.getMethodState(enclosingMethod);
                if (enclosingMethodState.isBottom()) continue;
                if (enclosingMethodState.isUnknown()) {
                    node.clearPredecessors();
                    node.setState(ParameterState.unknown());
                    break;
                }
                assert (enclosingMethodState.isConcrete());
                assert (enclosingMethodState.asConcrete().isMonomorphic());
                ParameterNode predecessor = this.getOrCreateParameterNode(enclosingMethod, inParameter.getIndex(), enclosingMethodState.asConcrete().asMonomorphic());
                node.addPredecessor(predecessor);
            }
            if (!node.getState().isUnknown()) {
                assert (node.getState() == concreteParameterState);
                node.setState(concreteParameterState.clearInParameters());
            }
        }

        private ParameterNode getOrCreateParameterNode(ProgramMethod method, int parameterIndex, ConcreteMonomorphicMethodState methodState) {
            Int2ReferenceMap parameterNodesForMethod = this.nodes.computeIfAbsent((DexMethod)method.getReference(), MapUtils.ignoreKey(Int2ReferenceOpenHashMap::new));
            return parameterNodesForMethod.compute(parameterIndex, (ignore, parameterNode) -> parameterNode != null ? parameterNode : new ParameterNode(methodState, parameterIndex, method.getArgumentType(parameterIndex)));
        }

        private ProgramMethod getEnclosingMethod(MethodParameter methodParameter) {
            DexMethod methodReference = methodParameter.getMethod();
            return methodReference.lookupOnProgramClass(DexProgramClass.asProgramClassOrNull(InParameterFlowPropagator.this.appView.definitionFor(methodParameter.getMethod().getHolderType())));
        }

        private MethodState getMethodState(ProgramMethod method) {
            if (method == null) {
                assert (false);
                return MethodState.unknown();
            }
            return InParameterFlowPropagator.this.methodStates.get(method);
        }

        @Override
        public void forEachNeighbor(ParameterNode node, Consumer<? super ParameterNode> consumer) {
            node.getPredecessors().forEach(consumer);
            node.getSuccessors().forEach(consumer);
        }

        @Override
        public void forEachNode(Consumer<? super ParameterNode> consumer) {
            this.nodes.values().forEach(nodesForMethod -> nodesForMethod.values().forEach(consumer));
        }
    }
}

