/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceOpenHashMap;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.MethodReprocessingCriteria;
import com.android.tools.r8.optimize.argumentpropagation.reprocessingcriteria.ParameterReprocessingCriteria;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ArgumentPropagatorReprocessingCriteriaCollection {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<DexMethod, MethodReprocessingCriteria> reproccessingCriteria = new IdentityHashMap<DexMethod, MethodReprocessingCriteria>();
    private final Map<DexMethod, MethodReprocessingCriteria> delayedReproccessingCriteria = new ConcurrentHashMap<DexMethod, MethodReprocessingCriteria>();

    public ArgumentPropagatorReprocessingCriteriaCollection(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private ParameterReprocessingCriteria analyzeArgumentUses(Argument argument) {
        if (argument.getOutType().isPrimitiveType()) {
            return ParameterReprocessingCriteria.alwaysReprocess();
        }
        ParameterReprocessingCriteria.Builder builder = ParameterReprocessingCriteria.builder();
        if (argument.outValue().hasAnyUsers()) {
            builder.setReprocessDueToAbstractValue().setReprocessDueToNullability();
        }
        for (Instruction instruction : argument.outValue().aliasedUsers()) {
            switch (instruction.opcode()) {
                case 9: 
                case 25: 
                case 28: 
                case 30: 
                case 56: {
                    break;
                }
                case 33: 
                case 38: {
                    break;
                }
                case 34: 
                case 39: 
                case 40: {
                    MethodResolutionResult.SingleResolutionResult resolutionResult;
                    InvokeMethodWithReceiver invoke = instruction.asInvokeMethodWithReceiver();
                    if (invoke.getReceiver().getAliasedValue() != argument.outValue() || (resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invoke.getInvokedMethod()).asSingleResolution()) == null || !resolutionResult.getResolvedHolder().isProgramClass()) break;
                    builder.setReprocessDueToDynamicType();
                    break;
                }
                default: {
                    builder.setReprocessDueToDynamicType();
                }
            }
            if (!builder.shouldAlwaysReprocess()) continue;
            break;
        }
        return builder.build();
    }

    public MethodReprocessingCriteria getReprocessingCriteria(ProgramMethod method) {
        return this.reproccessingCriteria.getOrDefault(method.getReference(), MethodReprocessingCriteria.alwaysReprocess());
    }

    public void publishDelayedReprocessingCriteria() {
        this.reproccessingCriteria.putAll(this.delayedReproccessingCriteria);
        this.delayedReproccessingCriteria.clear();
    }

    public void analyzeArgumentUses(ProgramMethod method, IRCode code) {
        Int2ReferenceOpenHashMap<ParameterReprocessingCriteria> methodReprocessingCriteria = new Int2ReferenceOpenHashMap<ParameterReprocessingCriteria>();
        InstructionIterator instructionIterator = code.entryBlock().iterator();
        Argument argument = ((Instruction)instructionIterator.next()).asArgument();
        while (argument != null) {
            ParameterReprocessingCriteria reprocessingCriteria = this.analyzeArgumentUses(argument);
            if (!reprocessingCriteria.isAlwaysReprocess()) {
                methodReprocessingCriteria.put(argument.getIndex(), reprocessingCriteria);
            }
            argument = ((Instruction)instructionIterator.next()).asArgument();
        }
        if (!methodReprocessingCriteria.isEmpty()) {
            this.delayedReproccessingCriteria.put((DexMethod)method.getReference(), new MethodReprocessingCriteria(methodReprocessingCriteria));
        }
    }

    public boolean verifyNoDelayedReprocessingCriteria() {
        assert (this.delayedReproccessingCriteria.isEmpty());
        return true;
    }
}

