/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.unusedarguments;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.MethodParameter;
import com.android.tools.r8.optimize.argumentpropagation.unusedarguments.EffectivelyUnusedArgumentsGraphNode;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.dfs.DFSStack;
import com.android.tools.r8.utils.dfs.DFSWorklistItem;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

class EffectivelyUnusedArgumentsGraph {
    private final AppView<AppInfoWithLiveness> appView;
    private final Map<MethodParameter, EffectivelyUnusedArgumentsGraphNode> nodes = new HashMap<MethodParameter, EffectivelyUnusedArgumentsGraphNode>();

    private EffectivelyUnusedArgumentsGraph(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public static EffectivelyUnusedArgumentsGraph create(AppView<AppInfoWithLiveness> appView, Map<MethodParameter, Set<MethodParameter>> constraints) {
        EffectivelyUnusedArgumentsGraph graph = new EffectivelyUnusedArgumentsGraph(appView);
        constraints.forEach((methodParameter, constraintsForMethodParameter) -> {
            EffectivelyUnusedArgumentsGraphNode node = graph.getOrCreateNode((MethodParameter)methodParameter);
            for (MethodParameter constraint : constraintsForMethodParameter) {
                graph.addConstraintEdge(node, constraint, constraints);
            }
        });
        return graph;
    }

    void addConstraintEdge(EffectivelyUnusedArgumentsGraphNode node, MethodParameter constraint, Map<MethodParameter, Set<MethodParameter>> constraints) {
        ProgramMethod dependencyMethod = DexClassAndMethod.asProgramMethodOrNull(this.appView.definitionFor(constraint.getMethod()));
        if (dependencyMethod == null) {
            assert (false);
            node.setUnoptimizable();
            return;
        }
        if (((DexEncodedMethod)dependencyMethod.getDefinition()).isInstance() && constraint.getIndex() == 0 && node.isNullable()) {
            node.setUnoptimizable();
            return;
        }
        if (!constraints.containsKey(constraint)) {
            MethodOptimizationInfo optimizationInfo = dependencyMethod.getOptimizationInfo();
            if (!optimizationInfo.hasUnusedArguments() || !optimizationInfo.getUnusedArguments().get(constraint.getIndex())) {
                node.setUnoptimizable();
            }
            return;
        }
        EffectivelyUnusedArgumentsGraphNode successor = this.getOrCreateNode(constraint, dependencyMethod);
        if (node != successor) {
            node.addSuccessor(successor);
        }
    }

    Collection<EffectivelyUnusedArgumentsGraphNode> getNodes() {
        return this.nodes.values();
    }

    EffectivelyUnusedArgumentsGraphNode getOrCreateNode(MethodParameter parameter) {
        ProgramMethod method = DexClassAndMethod.asProgramMethodOrNull(this.appView.definitionFor(parameter.getMethod()));
        return method != null ? this.getOrCreateNode(parameter, method) : null;
    }

    EffectivelyUnusedArgumentsGraphNode getOrCreateNode(MethodParameter parameter, ProgramMethod method) {
        return this.nodes.computeIfAbsent(parameter, p -> new EffectivelyUnusedArgumentsGraphNode(method, p.getIndex()));
    }

    void remove(EffectivelyUnusedArgumentsGraphNode node) {
        assert (node.getSuccessors().isEmpty());
        assert (node.getPredecessors().isEmpty());
        MethodParameter methodParameter = new MethodParameter((DexMethod)node.getMethod().getReference(), node.getArgumentIndex());
        EffectivelyUnusedArgumentsGraphNode removed = this.nodes.remove(methodParameter);
        assert (removed == node);
    }

    void removeClosedCycles(Consumer<EffectivelyUnusedArgumentsGraphNode> reprocess) {
        Set<EffectivelyUnusedArgumentsGraphNode> seen = Sets.newIdentityHashSet();
        for (EffectivelyUnusedArgumentsGraphNode root : this.getNodes()) {
            if (seen.contains(root)) continue;
            DFSStack stack = DFSStack.createIdentityStack();
            ArrayDeque<DFSWorklistItem> worklist = new ArrayDeque<DFSWorklistItem>();
            worklist.add(new DFSWorklistItem.NewlyVisitedDFSWorklistItem<EffectivelyUnusedArgumentsGraphNode>(root));
            while (!worklist.isEmpty()) {
                DFSWorklistItem item = (DFSWorklistItem)worklist.removeLast();
                stack.handle(item);
                if (item.isFullyVisited()) continue;
                EffectivelyUnusedArgumentsGraphNode node = (EffectivelyUnusedArgumentsGraphNode)item.getValue();
                seen.add(node);
                worklist.add(item.asNewlyVisited().toFullyVisited());
                node.getSuccessors().removeIf(successor -> {
                    if (stack.contains(successor)) {
                        Deque<EffectivelyUnusedArgumentsGraphNode> cycle = stack.getCycleStartingAt(successor);
                        boolean isClosedCycle = Iterables.all(cycle, member -> member.getSuccessors().size() == 1);
                        if (isClosedCycle) {
                            boolean removed = successor.getPredecessors().remove(node);
                            assert (removed);
                            reprocess.accept(node);
                            return true;
                        }
                    } else {
                        worklist.add(new DFSWorklistItem.NewlyVisitedDFSWorklistItem<EffectivelyUnusedArgumentsGraphNode>((EffectivelyUnusedArgumentsGraphNode)successor));
                    }
                    return false;
                });
            }
        }
    }

    boolean verifyContains(EffectivelyUnusedArgumentsGraphNode node) {
        MethodParameter methodParameter = new MethodParameter((DexMethod)node.getMethod().getReference(), node.getArgumentIndex());
        return this.nodes.containsKey(methodParameter);
    }

    void removeUnoptimizableNodes() {
        WorkList<EffectivelyUnusedArgumentsGraphNode> worklist = WorkList.newIdentityWorkList();
        for (EffectivelyUnusedArgumentsGraphNode node : this.getNodes()) {
            if (!node.isUnoptimizable()) continue;
            worklist.addIfNotSeen(node);
        }
        while (worklist.hasNext()) {
            EffectivelyUnusedArgumentsGraphNode node = (EffectivelyUnusedArgumentsGraphNode)worklist.next();
            worklist.addIfNotSeen(node.getPredecessors());
            node.cleanForRemoval();
            this.remove(node);
        }
    }
}

