/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.utils;

import com.android.tools.r8.utils.WorkList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public abstract class BidirectedGraph<T> {
    public abstract void forEachNeighbor(T var1, Consumer<? super T> var2);

    public abstract void forEachNode(Consumer<? super T> var1);

    public List<Set<T>> computeStronglyConnectedComponents() {
        HashSet seen = new HashSet();
        ArrayList<Set<T>> stronglyConnectedComponents = new ArrayList<Set<T>>();
        this.forEachNode(node -> {
            if (seen.contains(node)) {
                return;
            }
            Set<Object> stronglyConnectedComponent = this.computeStronglyConnectedComponent(node);
            stronglyConnectedComponents.add(stronglyConnectedComponent);
            seen.addAll(stronglyConnectedComponent);
        });
        return stronglyConnectedComponents;
    }

    public Set<T> computeStronglyConnectedComponent(T node) {
        WorkList<T> worklist = WorkList.newEqualityWorkList(node);
        while (worklist.hasNext()) {
            T current = worklist.next();
            this.forEachNeighbor(current, worklist::addIfNotSeen);
        }
        return worklist.getSeenSet();
    }
}

