/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.utils;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepMethodInfo;
import com.android.tools.r8.utils.InternalOptions;

public class ParameterRemovalUtils {
    public static boolean canRemoveUnusedParametersFrom(AppView<AppInfoWithLiveness> appView, ProgramMethod method) {
        InternalOptions options;
        KeepMethodInfo keepInfo = appView.getKeepInfo(method);
        if (!keepInfo.isParameterRemovalAllowed(options = appView.options())) {
            return false;
        }
        if (!appView.getKeepInfo(method).isUnusedArgumentOptimizationAllowed(options)) {
            return false;
        }
        return ((DexEncodedMethod)method.getDefinition()).isLibraryMethodOverride().isFalse();
    }

    public static boolean canRemoveUnusedParameter(AppView<AppInfoWithLiveness> appView, ProgramMethod method, int argumentIndex) {
        assert (ParameterRemovalUtils.canRemoveUnusedParametersFrom(appView, method));
        if (argumentIndex == 0) {
            if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                return false;
            }
            if (((DexEncodedMethod)method.getDefinition()).isInstance()) {
                InternalOptions options;
                if (method.getAccessFlags().isSynchronized()) {
                    return false;
                }
                KeepMethodInfo keepInfo = appView.getKeepInfo(method);
                if (!keepInfo.isMethodStaticizingAllowed(options = appView.options())) {
                    return false;
                }
            }
        }
        return true;
    }
}

