/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.argumentpropagation.utils;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ObjectAllocationInfoCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class WideningUtils {
    public static DynamicType widenDynamicReceiverType(AppView<AppInfoWithLiveness> appView, ProgramMethod resolvedMethod, DynamicType dynamicReceiverType) {
        return WideningUtils.internalWidenDynamicClassType(appView, dynamicReceiverType, resolvedMethod.getHolderType(), Nullability.definitelyNotNull());
    }

    public static DynamicType widenDynamicNonReceiverType(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType, DexType staticType) {
        return WideningUtils.widenDynamicNonReceiverType(appView, dynamicType, staticType, Nullability.maybeNull());
    }

    public static DynamicType widenDynamicNonReceiverType(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType, DexType staticType, Nullability staticNullability) {
        return WideningUtils.internalWidenDynamicClassType(appView, dynamicType, staticType, staticNullability);
    }

    private static DynamicType internalWidenDynamicClassType(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType, DexType staticType, Nullability staticNullability) {
        assert (staticType.isClassType());
        if (dynamicType.isBottom() || dynamicType.isNullType() || dynamicType.isNotNullType() || dynamicType.isUnknown()) {
            return dynamicType;
        }
        DynamicTypeWithUpperBound dynamicTypeWithUpperBound = dynamicType.asDynamicTypeWithUpperBound();
        TypeElement dynamicUpperBoundType = dynamicTypeWithUpperBound.getDynamicUpperBoundType();
        ClassTypeElement staticTypeElement = staticType.toTypeElement(appView).asClassType().getOrCreateVariant(staticNullability);
        if (dynamicType.getNullability().strictlyLessThan(staticNullability)) {
            if (dynamicType.getNullability().isDefinitelyNotNull() && dynamicUpperBoundType.equalUpToNullability(staticTypeElement) && WideningUtils.hasTrivialLowerBound(appView, dynamicType, staticType)) {
                return DynamicType.definitelyNotNull();
            }
            return dynamicType;
        }
        if (!dynamicUpperBoundType.equals(staticTypeElement)) {
            return dynamicType;
        }
        if (!dynamicType.hasDynamicLowerBoundType()) {
            return DynamicType.unknown();
        }
        return WideningUtils.isEffectivelyFinal(appView, staticType) ? DynamicType.unknown() : dynamicType;
    }

    private static boolean hasTrivialLowerBound(AppView<AppInfoWithLiveness> appView, DynamicType dynamicType, DexType staticType) {
        return !dynamicType.hasDynamicLowerBoundType() || WideningUtils.isEffectivelyFinal(appView, staticType);
    }

    private static boolean isEffectivelyFinal(AppView<AppInfoWithLiveness> appView, DexType staticType) {
        DexClass staticTypeClass = appView.definitionFor(staticType);
        if (staticTypeClass == null) {
            return false;
        }
        if (!staticTypeClass.isProgramClass()) {
            return staticTypeClass.isFinal();
        }
        ObjectAllocationInfoCollection objectAllocationInfoCollection = appView.appInfo().getObjectAllocationInfoCollection();
        return !objectAllocationInfoCollection.hasInstantiatedStrictSubtype(staticTypeClass.asProgramClass());
    }
}

