/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.bridgehoisting;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.code.Base3Format;
import com.android.tools.r8.code.Instruction;
import com.android.tools.r8.code.InvokeVirtual;
import com.android.tools.r8.code.InvokeVirtualRange;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.BottomUpClassHierarchyTraversal;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.SubtypingInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackSimple;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeInfo;
import com.android.tools.r8.ir.optimize.info.bridge.VirtualBridgeInfo;
import com.android.tools.r8.optimize.bridgehoisting.BridgeHoistingLens;
import com.android.tools.r8.optimize.bridgehoisting.BridgeHoistingResult;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class BridgeHoisting {
    private static final OptimizationFeedbackSimple feedback = OptimizationFeedbackSimple.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final BridgeHoistingResult result;

    public BridgeHoisting(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.result = new BridgeHoistingResult(appView);
    }

    private void processClass(DexProgramClass clazz, SubtypingInfo subtypingInfo) {
        Set<DexType> subtypes = subtypingInfo.allImmediateSubtypes(clazz.type);
        TreeSet<DexProgramClass> subclasses = new TreeSet<DexProgramClass>(Comparator.comparing(DexClass::getType));
        for (DexType dexType : subtypes) {
            DexProgramClass subclass = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(dexType));
            if (subclass == null) {
                return;
            }
            subclasses.add(subclass);
        }
        for (Equivalence.Wrapper wrapper : this.getCandidatesForHoisting(subclasses)) {
            this.hoistBridgeIfPossible((DexMethod)wrapper.get(), clazz, subclasses);
        }
    }

    private Set<Equivalence.Wrapper<DexMethod>> getCandidatesForHoisting(Set<DexProgramClass> subclasses) {
        MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
        HashSet<Equivalence.Wrapper<DexMethod>> candidates = new HashSet<Equivalence.Wrapper<DexMethod>>();
        for (DexProgramClass subclass : subclasses) {
            for (DexEncodedMethod method : subclass.virtualMethods()) {
                BridgeInfo bridgeInfo = method.getOptimizationInfo().getBridgeInfo();
                if (bridgeInfo == null) continue;
                candidates.add(equivalence.wrap((DexMethod)method.getReference()));
            }
        }
        return candidates;
    }

    private void hoistBridgeIfPossible(DexMethod method, DexProgramClass clazz, Set<DexProgramClass> subclasses) {
        if (clazz.lookupMethod(method) != null) {
            return;
        }
        HashMap<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> eligibleVirtualInvokeBridges = new HashMap<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>>();
        for (DexProgramClass subclass : subclasses) {
            DexEncodedMethod definition = subclass.lookupVirtualMethod(method);
            if (definition == null) {
                DexEncodedMethod resolutionTarget = this.appView.appInfo().resolveMethodOnClass(method, (DexClass)subclass).getSingleTarget();
                if (resolutionTarget == null || resolutionTarget.isAbstract()) continue;
                return;
            }
            BridgeInfo currentBridgeInfo = definition.getOptimizationInfo().getBridgeInfo();
            if (currentBridgeInfo == null) continue;
            assert (currentBridgeInfo.isVirtualBridgeInfo());
            VirtualBridgeInfo currentVirtualBridgeInfo = currentBridgeInfo.asVirtualBridgeInfo();
            DexMethod invokedMethod = currentVirtualBridgeInfo.getInvokedMethod();
            Equivalence.Wrapper<DexMethod> wrapper = MethodSignatureEquivalence.get().wrap(invokedMethod);
            eligibleVirtualInvokeBridges.computeIfAbsent(wrapper, ignore -> new ArrayList()).add(subclass);
        }
        assert (!eligibleVirtualInvokeBridges.isEmpty());
        Map.Entry<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> mostFrequentBridge = BridgeHoisting.findMostFrequentBridge(eligibleVirtualInvokeBridges);
        assert (mostFrequentBridge != null);
        DexMethod invokedMethod = mostFrequentBridge.getKey().get();
        List<DexProgramClass> eligibleSubclasses = mostFrequentBridge.getValue();
        List<ProgramMethod> eligibleBridgeMethods = this.getBridgesEligibleForHoisting(eligibleSubclasses, method);
        ProgramMethod representative = eligibleBridgeMethods.iterator().next();
        if (this.mayBecomeInaccessibleAfterHoisting(clazz, representative)) {
            return;
        }
        DexMethod methodToInvoke = this.appView.dexItemFactory().createMethod(clazz.type, invokedMethod.proto, invokedMethod.name);
        MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(methodToInvoke, (DexClass)clazz);
        if (!resolutionResult.isSingleResolution()) {
            return;
        }
        representative.setCode(this.createCodeForVirtualBridge(representative, methodToInvoke), this.appView);
        feedback.setBridgeInfo((DexEncodedMethod)representative.getDefinition(), new VirtualBridgeInfo(methodToInvoke));
        DexMethod newMethodReference = this.appView.dexItemFactory().createMethod(clazz.type, method.proto, method.name);
        DexEncodedMethod newMethod = ((DexEncodedMethod)representative.getDefinition()).toTypeSubstitutedMethod(newMethodReference);
        if (newMethod.getAccessFlags().isFinal()) {
            newMethod.getAccessFlags().demoteFromFinal();
        }
        clazz.addVirtualMethod(newMethod);
        this.result.move(Iterables.transform(eligibleBridgeMethods, DexClassAndMember::getReference), newMethodReference, (DexMethod)representative.getReference());
        for (DexProgramClass subclass : eligibleSubclasses) {
            assert (!this.appView.appInfo().isPinned(method));
            DexEncodedMethod removed = subclass.removeMethod(method);
            assert (removed != null);
        }
    }

    private static Map.Entry<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> findMostFrequentBridge(Map<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> eligibleVirtualInvokeBridges) {
        Map.Entry<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> result = null;
        for (Map.Entry<Equivalence.Wrapper<DexMethod>, List<DexProgramClass>> candidate : eligibleVirtualInvokeBridges.entrySet()) {
            List<DexProgramClass> eligibleSubclassesCandidate = candidate.getValue();
            if (result != null && eligibleSubclassesCandidate.size() <= result.getValue().size()) continue;
            result = candidate;
        }
        return result;
    }

    private List<ProgramMethod> getBridgesEligibleForHoisting(Iterable<DexProgramClass> subclasses, DexMethod reference) {
        ArrayList<ProgramMethod> result = new ArrayList<ProgramMethod>();
        for (DexProgramClass subclass : subclasses) {
            ProgramMethod method = subclass.lookupProgramMethod(reference);
            if (method == null) continue;
            result.add(method);
        }
        assert (!result.isEmpty());
        return result;
    }

    private boolean mayBecomeInaccessibleAfterHoisting(DexProgramClass clazz, ProgramMethod representative) {
        if (clazz.type.isSamePackage(representative.getHolder().type)) {
            return false;
        }
        return !((DexEncodedMethod)representative.getDefinition()).isPublic();
    }

    private Code createCodeForVirtualBridge(ProgramMethod representative, DexMethod methodToInvoke) {
        Code code = ((DexEncodedMethod)representative.getDefinition()).getCode();
        if (code.isCfCode()) {
            return this.createCfCodeForVirtualBridge(code.asCfCode(), methodToInvoke);
        }
        if (code.isDexCode()) {
            return this.createDexCodeForVirtualBridge(code.asDexCode(), methodToInvoke);
        }
        throw new Unreachable("Unexpected code object of type " + code.getClass().getTypeName());
    }

    private CfCode createCfCodeForVirtualBridge(CfCode code, DexMethod methodToInvoke) {
        ArrayList<CfInstruction> newInstructions = new ArrayList<CfInstruction>();
        boolean modified = false;
        for (CfInstruction instruction : code.getInstructions()) {
            if (instruction.isInvoke() && instruction.asInvoke().getMethod() != methodToInvoke) {
                CfInvoke invoke = instruction.asInvoke();
                assert (invoke.isInvokeVirtual());
                assert (!invoke.isInterface());
                assert (invoke.getMethod().match(methodToInvoke));
                newInstructions.add(new CfInvoke(invoke.getOpcode(), methodToInvoke, false));
                modified = true;
                continue;
            }
            newInstructions.add(instruction);
        }
        return modified ? new CfCode(methodToInvoke.holder, code.getMaxStack(), code.getMaxLocals(), newInstructions, code.getTryCatchRanges(), code.getLocalVariables()) : code;
    }

    private DexCode createDexCodeForVirtualBridge(DexCode code, DexMethod methodToInvoke) {
        Instruction[] newInstructions = new Instruction[code.instructions.length];
        boolean modified = false;
        for (int i = 0; i < code.instructions.length; ++i) {
            Base3Format newInvoke;
            Base3Format invoke;
            Instruction instruction = code.instructions[i];
            if (instruction.isInvokeVirtual() && instruction.asInvokeVirtual().getMethod() != methodToInvoke) {
                invoke = instruction.asInvokeVirtual();
                newInvoke = new InvokeVirtual((int)((InvokeVirtual)invoke).A, methodToInvoke, (int)((InvokeVirtual)invoke).C, (int)((InvokeVirtual)invoke).D, (int)((InvokeVirtual)invoke).E, (int)((InvokeVirtual)invoke).F, (int)((InvokeVirtual)invoke).G);
                newInvoke.setOffset(invoke.getOffset());
                newInstructions[i] = newInvoke;
                modified = true;
                continue;
            }
            if (instruction.isInvokeVirtualRange() && instruction.asInvokeVirtualRange().getMethod() != methodToInvoke) {
                invoke = instruction.asInvokeVirtualRange();
                newInvoke = new InvokeVirtualRange((int)((InvokeVirtualRange)invoke).CCCC, (int)((InvokeVirtualRange)invoke).AA, methodToInvoke);
                newInvoke.setOffset(invoke.getOffset());
                modified = true;
                newInstructions[i] = newInvoke;
                continue;
            }
            newInstructions[i] = instruction;
        }
        return modified ? new DexCode(code.registerSize, code.incomingRegisterSize, code.outgoingRegisterSize, newInstructions, code.tries, code.handlers, code.getDebugInfo()) : code;
    }

    public void run() {
        SubtypingInfo subtypingInfo = this.appView.appInfo().computeSubtypingInfo();
        ((BottomUpClassHierarchyTraversal)BottomUpClassHierarchyTraversal.forProgramClasses(this.appView, subtypingInfo).excludeInterfaces()).visit(this.appView.appInfo().classes(), clazz -> this.processClass((DexProgramClass)clazz, subtypingInfo));
        if (!this.result.isEmpty()) {
            MethodAccessInfoCollection.IdentityBuilder bridgeMethodAccessInfoCollectionBuilder = MethodAccessInfoCollection.identityBuilder();
            this.result.recordNonReboundMethodAccesses(bridgeMethodAccessInfoCollectionBuilder);
            BridgeHoistingLens lens = this.result.buildLens();
            this.appView.rewriteWithLens(lens);
            MethodAccessInfoCollection.Modifier methodAccessInfoCollectionModifier = this.appView.appInfo().getMethodAccessInfoCollection().modifier();
            methodAccessInfoCollectionModifier.addAll(bridgeMethodAccessInfoCollectionBuilder.build());
            this.result.forEachHoistedBridge((bridge, bridgeInfo) -> {
                if (bridgeInfo.isVirtualBridgeInfo()) {
                    DexMethod reference = bridgeInfo.asVirtualBridgeInfo().getInvokedMethod();
                    methodAccessInfoCollectionModifier.registerInvokeVirtualInContext(reference, (ProgramMethod)bridge);
                } else assert (false);
            });
        }
    }
}

