/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.bridgehoisting;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.MethodAccessInfoCollection;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeInfo;
import com.android.tools.r8.optimize.bridgehoisting.BridgeHoistingLens;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.BidirectionalManyToOneRepresentativeHashMap;
import com.android.tools.r8.utils.collections.MutableBidirectionalManyToOneRepresentativeMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiConsumer;

class BridgeHoistingResult {
    private final AppView<AppInfoWithLiveness> appView;
    private final MutableBidirectionalManyToOneRepresentativeMap<DexMethod, DexMethod> bridgeToHoistedBridgeMap = BidirectionalManyToOneRepresentativeHashMap.newIdentityHashMap();

    BridgeHoistingResult(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public void forEachHoistedBridge(BiConsumer<ProgramMethod, BridgeInfo> consumer) {
        this.bridgeToHoistedBridgeMap.forEachManyToOneMapping((bridges, hoistedBridge) -> {
            DexProgramClass clazz = this.appView.definitionForProgramType(hoistedBridge.getHolderType());
            ProgramMethod method = hoistedBridge.lookupOnProgramClass(clazz);
            if (method != null) {
                consumer.accept(method, ((DexEncodedMethod)method.getDefinition()).getOptimizationInfo().getBridgeInfo());
            }
        });
    }

    public boolean isEmpty() {
        return this.bridgeToHoistedBridgeMap.isEmpty();
    }

    public void move(Iterable<DexMethod> from, DexMethod to, DexMethod representative) {
        DexMethod originalRepresentative = this.bridgeToHoistedBridgeMap.getRepresentativeKeyOrDefault(representative, representative);
        LinkedHashSet<DexMethod> originalFrom = Sets.newLinkedHashSet();
        for (DexMethod method : from) {
            Set keys2 = this.bridgeToHoistedBridgeMap.removeValue(method);
            if (keys2.isEmpty()) {
                originalFrom.add(method);
                continue;
            }
            originalFrom.addAll(keys2);
        }
        assert (originalFrom.contains(originalRepresentative));
        this.bridgeToHoistedBridgeMap.put(originalFrom, to);
        this.bridgeToHoistedBridgeMap.setRepresentative(to, originalRepresentative);
    }

    public void recordNonReboundMethodAccesses(MethodAccessInfoCollection.IdentityBuilder bridgeMethodAccessInfoCollectionBuilder) {
        MethodAccessInfoCollection methodAccessInfoCollection = this.appView.appInfo().getMethodAccessInfoCollection();
        this.bridgeToHoistedBridgeMap.keySet().forEach(from -> {
            methodAccessInfoCollection.forEachSuperInvokeContext((DexMethod)from, context -> bridgeMethodAccessInfoCollectionBuilder.registerInvokeSuperInContext((DexMethod)from, (ProgramMethod)context));
            methodAccessInfoCollection.forEachVirtualInvokeContext((DexMethod)from, context -> bridgeMethodAccessInfoCollectionBuilder.registerInvokeVirtualInContext((DexMethod)from, (ProgramMethod)context));
        });
    }

    public BridgeHoistingLens buildLens() {
        assert (!this.isEmpty());
        return new BridgeHoistingLens(this.appView, this.bridgeToHoistedBridgeMap);
    }
}

