/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.interfaces.analysis;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.InterfaceCollection;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.FieldPut;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.optimize.interfaces.analysis.OpenClosedInterfacesAnalysis;
import com.android.tools.r8.optimize.interfaces.collection.NonEmptyOpenClosedInterfacesCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.WorkList;
import java.util.Set;
import java.util.stream.Collectors;

public class OpenClosedInterfacesAnalysisImpl
extends OpenClosedInterfacesAnalysis {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private Set<DexClass> openInterfaces;

    public OpenClosedInterfacesAnalysisImpl(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private void analyzeArrayPut(ArrayPut arrayPut) {
        Value array = arrayPut.array();
        TypeElement arrayType = array.getType();
        if (!arrayType.isArrayType()) {
            return;
        }
        TypeElement valueType = arrayPut.value().getType();
        TypeElement arrayMemberType = arrayType.asArrayType().getMemberType();
        this.checkAssignment(valueType, arrayMemberType);
    }

    private void analyzeFieldPut(FieldPut fieldPut) {
        TypeElement valueType = fieldPut.value().getType();
        TypeElement fieldType = fieldPut.getField().getTypeElement(this.appView);
        this.checkAssignment(valueType, fieldType);
    }

    private void analyzeInvokeMethod(InvokeMethod invoke) {
        DexTypeList parameters = invoke.getInvokedMethod().getParameters();
        for (int parameterIndex = 0; parameterIndex < parameters.size(); ++parameterIndex) {
            Value argument = invoke.getArgumentForParameter(parameterIndex);
            TypeElement argumentType = argument.getType();
            TypeElement parameterType = parameters.get(parameterIndex).toTypeElement(this.appView);
            this.checkAssignment(argumentType, parameterType);
        }
    }

    private void analyzeReturn(Return returnInstruction, ProgramMethod context) {
        if (returnInstruction.isReturnVoid()) {
            return;
        }
        TypeElement valueType = returnInstruction.returnValue().getType();
        TypeElement returnType = context.getReturnType().toTypeElement(this.appView);
        this.checkAssignment(valueType, returnType);
    }

    private void checkAssignment(TypeElement fromType, TypeElement toType) {
        if (!toType.isClassType()) {
            return;
        }
        ClassTypeElement toClassType = toType.asClassType();
        if (toClassType.getClassType() != this.dexItemFactory.objectType) {
            return;
        }
        InterfaceCollection interfaceCollection = toClassType.getInterfaces();
        interfaceCollection.forEachKnownInterface(knownInterfaceType -> {
            DexClass knownInterface = this.appView.definitionFor((DexType)knownInterfaceType);
            if (knownInterface == null) {
                return;
            }
            assert (knownInterface.isInterface());
            if (fromType.lessThanOrEqualUpToNullability(toType, this.appView)) {
                return;
            }
            assert (this.verifyOpenInterfaceWitnessIsSuppressed(fromType, knownInterface));
            this.openInterfaces.add(knownInterface);
        });
    }

    private void includeParentOpenInterfaces() {
        WorkList<DexClass> worklist = WorkList.newWorkList(this.openInterfaces);
        worklist.addAllIgnoringSeenSet(this.openInterfaces);
        while (worklist.hasNext()) {
            DexClass openInterface = worklist.next();
            for (DexType indirectOpenInterfaceType : openInterface.getInterfaces()) {
                DexClass indirectOpenInterfaceDefinition = this.appView.definitionFor(indirectOpenInterfaceType);
                if (indirectOpenInterfaceDefinition == null) continue;
                worklist.addIfNotSeen(indirectOpenInterfaceDefinition);
            }
        }
    }

    private boolean verifyOpenInterfaceWitnessIsSuppressed(TypeElement valueType, DexClass openInterface) {
        InternalOptions.OpenClosedInterfacesOptions options = this.appView.options().getOpenClosedInterfacesOptions();
        assert (options.isSuppressed(this.appView, valueType, openInterface)) : "Unexpected open interface " + openInterface.getTypeName() + " (assignment: " + valueType + ")";
        return true;
    }

    @Override
    public void analyze(ProgramMethod method, IRCode code) {
        if (this.openInterfaces == null) {
            return;
        }
        for (Instruction instruction : code.instructions()) {
            switch (instruction.opcode()) {
                case 8: {
                    this.analyzeArrayPut(instruction.asArrayPut());
                    break;
                }
                case 30: 
                case 60: {
                    this.analyzeFieldPut(instruction.asFieldPut());
                    break;
                }
                case 33: 
                case 34: 
                case 38: 
                case 39: 
                case 40: {
                    this.analyzeInvokeMethod(instruction.asInvokeMethod());
                    break;
                }
                case 56: {
                    this.analyzeReturn(instruction.asReturn(), method);
                    break;
                }
            }
        }
    }

    @Override
    public void prepareForPrimaryOptimizationPass() {
        this.openInterfaces = Sets.newConcurrentHashSet();
    }

    @Override
    public void onPrimaryOptimizationPassComplete() {
        InternalOptions.OpenClosedInterfacesOptions options = this.appView.options().getOpenClosedInterfacesOptions();
        assert (options.isOpenInterfacesAllowed() || !options.hasSuppressions() || !this.openInterfaces.isEmpty()) : "Expected to find at least one open interface";
        this.includeParentOpenInterfaces();
        this.appView.setOpenClosedInterfacesCollection(new NonEmptyOpenClosedInterfacesCollection(this.openInterfaces.stream().map(DexClass::getType).collect(Collectors.toCollection(() -> SetUtils.newIdentityHashSet(this.openInterfaces.size())))));
        this.openInterfaces = null;
    }
}

