/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.interfaces.collection;

import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.optimize.interfaces.collection.OpenClosedInterfacesCollection;
import com.android.tools.r8.utils.SetUtils;
import java.util.Set;

public class NonEmptyOpenClosedInterfacesCollection
extends OpenClosedInterfacesCollection {
    private final Set<DexType> openInterfaceTypes;

    public NonEmptyOpenClosedInterfacesCollection(Set<DexType> openInterfaceTypes) {
        this.openInterfaceTypes = openInterfaceTypes;
    }

    @Override
    public boolean isDefinitelyClosed(DexClass clazz) {
        assert (clazz.isInterface());
        return !this.openInterfaceTypes.contains(clazz.getType());
    }

    @Override
    public OpenClosedInterfacesCollection rewrittenWithLens(GraphLens graphLens) {
        Set<DexType> rewrittenOpenInterfaceTypes = SetUtils.newIdentityHashSet(this.openInterfaceTypes.size());
        for (DexType openInterfaceType : this.openInterfaceTypes) {
            rewrittenOpenInterfaceTypes.add(graphLens.lookupType(openInterfaceType));
        }
        return new NonEmptyOpenClosedInterfacesCollection(rewrittenOpenInterfaceTypes);
    }

    @Override
    public OpenClosedInterfacesCollection withoutPrunedItems(PrunedItems prunedItems) {
        if (!prunedItems.hasRemovedClasses()) {
            return this;
        }
        Set<DexType> prunedOpenInterfaceTypes = SetUtils.newIdentityHashSet(this.openInterfaceTypes.size());
        for (DexType openInterfaceType : this.openInterfaceTypes) {
            if (prunedItems.isRemoved(openInterfaceType)) continue;
            prunedOpenInterfaceTypes.add(openInterfaceType);
        }
        return new NonEmptyOpenClosedInterfacesCollection(prunedOpenInterfaceTypes);
    }
}

