/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.optimize.interfaces.collection;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.optimize.interfaces.collection.DefaultOpenClosedInterfacesCollection;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.function.Supplier;

public abstract class OpenClosedInterfacesCollection {
    public static DefaultOpenClosedInterfacesCollection getDefault() {
        return DefaultOpenClosedInterfacesCollection.getInstance();
    }

    public abstract boolean isDefinitelyClosed(DexClass var1);

    public final boolean isMaybeOpen(DexClass clazz) {
        return !this.isDefinitelyClosed(clazz);
    }

    public final boolean isDefinitelyInstanceOfStaticType(AppView<AppInfoWithLiveness> appView, Value value) {
        return this.isDefinitelyInstanceOfStaticType(appView, () -> value.getDynamicType(appView), value.getType());
    }

    public final boolean isDefinitelyInstanceOfStaticType(AppView<?> appView, Supplier<DynamicType> dynamicTypeSupplier, TypeElement staticType) {
        if (!staticType.isClassType()) {
            return true;
        }
        ClassTypeElement staticClassType = staticType.asClassType();
        if (staticClassType.getClassType() != appView.dexItemFactory().objectType) {
            return true;
        }
        if (staticClassType.nullability().isDefinitelyNull()) {
            return true;
        }
        boolean isStaticTypeDefinitelyClosed = staticClassType.getInterfaces().allKnownInterfacesMatch(knownInterfaceType -> {
            DexClass knownInterface = appView.definitionFor((DexType)knownInterfaceType);
            return knownInterface != null && this.isDefinitelyClosed(knownInterface);
        });
        if (isStaticTypeDefinitelyClosed) {
            return true;
        }
        DynamicType dynamicType = dynamicTypeSupplier.get();
        if (dynamicType.isNullType()) {
            return true;
        }
        if (dynamicType.isUnknown()) {
            return false;
        }
        TypeElement dynamicUpperBoundType = dynamicType.getDynamicUpperBoundType(staticType);
        if (!dynamicUpperBoundType.isClassType()) {
            assert (false);
            return false;
        }
        ClassTypeElement dynamicUpperBoundClassType = dynamicUpperBoundType.asClassType();
        if (dynamicUpperBoundClassType.getClassType() != appView.dexItemFactory().objectType) {
            return dynamicUpperBoundClassType.lessThanOrEqualUpToNullability(staticType, appView);
        }
        return false;
    }

    public abstract OpenClosedInterfacesCollection rewrittenWithLens(GraphLens var1);

    public abstract OpenClosedInterfacesCollection withoutPrunedItems(PrunedItems var1);
}

