/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.position;

import com.android.tools.r8.Keep;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.position.Position;
import com.android.tools.r8.references.MethodReference;
import com.android.tools.r8.references.TypeReference;
import java.util.List;
import java.util.stream.Collectors;

@Keep
public class MethodPosition
implements Position {
    private final MethodReference method;
    private final Position textPosition;

    @Deprecated
    public MethodPosition(DexMethod method) {
        this(method.asMethodReference());
    }

    @Deprecated
    public MethodPosition(MethodReference method) {
        this(method, Position.UNKNOWN);
    }

    private MethodPosition(MethodReference method, Position textPosition) {
        this.method = method;
        this.textPosition = textPosition;
    }

    public static MethodPosition create(ProgramMethod method) {
        return MethodPosition.create((DexEncodedMethod)method.getDefinition());
    }

    public static MethodPosition create(DexEncodedMethod method) {
        Position position = UNKNOWN;
        if (method.hasCode() && method.getCode().isCfCode()) {
            position = method.getCode().asCfCode().getDiagnosticPosition();
        }
        return MethodPosition.create(((DexMethod)method.getReference()).asMethodReference(), position);
    }

    public static MethodPosition create(MethodReference method) {
        return new MethodPosition(method, Position.UNKNOWN);
    }

    public static MethodPosition create(MethodReference method, Position position) {
        return new MethodPosition(method, position);
    }

    public MethodReference getMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getMethodName();
    }

    public String getHolder() {
        return this.method.getHolderClass().getDescriptor();
    }

    public String getReturnType() {
        return this.method.getReturnType().getDescriptor();
    }

    public List<String> getParameterTypes() {
        return this.method.getFormalTypes().stream().map(TypeReference::getDescriptor).collect(Collectors.toList());
    }

    public Position getTextPosition() {
        return this.textPosition;
    }

    public String toString() {
        return this.method.toString();
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    public int hashCode() {
        return this.method.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MethodPosition) {
            return this.method.equals(((MethodPosition)o).method);
        }
        return false;
    }
}

