/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.references;

import com.android.tools.r8.Keep;
import com.android.tools.r8.KeepForRetraceApi;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Objects;

@Keep
@KeepForRetraceApi
public class PackageReference {
    private final String packageName;

    PackageReference(String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException("Package name cannot be null.");
        }
        if (!packageName.isEmpty() && !DescriptorUtils.isValidJavaType(packageName)) {
            throw new IllegalArgumentException("Package name '" + packageName + "' is not valid.");
        }
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PackageReference)) {
            return false;
        }
        PackageReference that = (PackageReference)o;
        return this.packageName.equals(that.packageName);
    }

    public int hashCode() {
        return Objects.hash(this.packageName);
    }
}

